/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncTrophySystem {
    private BlockPos pos;
    private ResourceLocation projectileType;
    private boolean allowed;

    public SyncTrophySystem() {
    }

    public SyncTrophySystem(BlockPos pos, EntityType<?> projectileType, boolean allowed) {
        this.pos = pos;
        this.projectileType = projectileType.getRegistryName();
        this.allowed = allowed;
    }

    public static void encode(SyncTrophySystem message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130085_(message.projectileType);
        buf.writeBoolean(message.allowed);
    }

    public static SyncTrophySystem decode(FriendlyByteBuf buf) {
        SyncTrophySystem message = new SyncTrophySystem();
        message.pos = buf.m_130135_();
        message.projectileType = buf.m_130281_();
        message.allowed = buf.readBoolean();
        return message;
    }

    public static void onMessage(SyncTrophySystem message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            EntityType projectileType = (EntityType)ForgeRegistries.ENTITIES.getValue(message.projectileType);
            if (projectileType != null) {
                TrophySystemBlockEntity te;
                Level world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
                BlockPos pos = message.pos;
                boolean allowed = message.allowed;
                BlockEntity te$temp = world.m_7702_(pos);
                if (te$temp instanceof TrophySystemBlockEntity && (te = (TrophySystemBlockEntity)te$temp).getOwner().isOwner((Player)((NetworkEvent.Context)ctx.get()).getSender())) {
                    BlockState state = world.m_8055_(pos);
                    te.setFilter(projectileType, allowed);
                    world.m_7260_(pos, state, state, 2);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

