/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import java.util.Calendar;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeypadChestTileEntityRenderer
extends ChestRenderer<KeypadChestBlockEntity> {
    private static final Material ACTIVE = KeypadChestTileEntityRenderer.createMaterial("active");
    private static final Material INACTIVE = KeypadChestTileEntityRenderer.createMaterial("inactive");
    private static final Material LEFT_ACTIVE = KeypadChestTileEntityRenderer.createMaterial("left_active");
    private static final Material LEFT_INACTIVE = KeypadChestTileEntityRenderer.createMaterial("left_inactive");
    private static final Material RIGHT_ACTIVE = KeypadChestTileEntityRenderer.createMaterial("right_active");
    private static final Material RIGHT_INACTIVE = KeypadChestTileEntityRenderer.createMaterial("right_inactive");
    private static final Material CHRISTMAS = KeypadChestTileEntityRenderer.createMaterial("christmas");
    private static final Material CHRISTMAS_LEFT = KeypadChestTileEntityRenderer.createMaterial("christmas_left");
    private static final Material CHRISTMAS_RIGHT = KeypadChestTileEntityRenderer.createMaterial("christmas_right");
    protected boolean isChristmas;

    public KeypadChestTileEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    protected Material getMaterial(KeypadChestBlockEntity te, ChestType type) {
        if (this.isChristmas) {
            return this.getMaterialForType(type, CHRISTMAS_LEFT, CHRISTMAS_RIGHT, CHRISTMAS);
        }
        if (te.m_6683_(0.0f) >= 0.9f) {
            return this.getMaterialForType(type, LEFT_ACTIVE, RIGHT_ACTIVE, ACTIVE);
        }
        return this.getMaterialForType(type, LEFT_INACTIVE, RIGHT_INACTIVE, INACTIVE);
    }

    private Material getMaterialForType(ChestType type, Material left, Material right, Material single) {
        return switch (type) {
            case ChestType.LEFT -> left;
            case ChestType.RIGHT -> right;
            case ChestType.SINGLE -> single;
            default -> single;
        };
    }

    private static Material createMaterial(String name) {
        return new Material(Sheets.f_110740_, new ResourceLocation("securitycraft", "entity/chest/" + name));
    }
}

