/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.ProjectorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderProperties;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorTileEntityRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    public ProjectorTileEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ProjectorBlockEntity te, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int combinedOverlay) {
        if (te.isActive() && !te.m_7983_()) {
            Random random = new Random();
            BlockState state = te.getProjectedBlock().m_49966_();
            RenderSystem.m_69464_();
            for (int x = 0; x < te.getProjectionWidth(); ++x) {
                for (int y = 0; y < te.getProjectionHeight(); ++y) {
                    pose.m_85836_();
                    BlockPos pos = !te.isHorizontal() ? this.translateProjection(te.m_58899_(), pose, (Direction)te.m_58900_().m_61143_((Property)ProjectorBlock.FACING), x, y, te.getProjectionRange(), te.getProjectionOffset()) : this.translateProjection(te.m_58899_(), pose, (Direction)te.m_58900_().m_61143_((Property)ProjectorBlock.FACING), x, te.getProjectionRange() - 16, y + 1, te.getProjectionOffset());
                    if (pos != null && te.m_58904_().m_46859_(pos)) {
                        switch (state.m_60799_()) {
                            case MODEL: {
                                for (RenderType rendertype : RenderType.m_110506_()) {
                                    if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)rendertype)) continue;
                                    Minecraft.m_91087_().m_91289_().m_110924_(state, pos, (BlockAndTintGetter)te.m_58904_(), pose, buffer.m_6299_(rendertype), true, random);
                                }
                                break;
                            }
                            case ENTITYBLOCK_ANIMATED: {
                                ItemStack tileEntityStack = new ItemStack((ItemLike)state.m_60734_());
                                RenderProperties.get((ItemStack)tileEntityStack).getItemStackRenderer().m_108829_(tileEntityStack, ItemTransforms.TransformType.NONE, pose, buffer, packedLight, OverlayTexture.f_118083_);
                                break;
                            }
                        }
                    }
                    pose.m_85849_();
                }
            }
            RenderSystem.m_69481_();
        }
    }

    private BlockPos translateProjection(BlockPos tePos, PoseStack pose, Direction direction, int x, int y, double distance, double offset) {
        BlockPos pos = null;
        if (direction == Direction.NORTH) {
            pos = new BlockPos((double)(tePos.m_123341_() + x) + offset, (double)(tePos.m_123342_() + y), (double)tePos.m_123343_() + distance);
            pose.m_85837_(0.0 + (double)x + offset, 0.0 + (double)y, distance);
        } else if (direction == Direction.SOUTH) {
            pos = new BlockPos((double)(tePos.m_123341_() + x) + offset, (double)(tePos.m_123342_() + y), (double)tePos.m_123343_() + -distance);
            pose.m_85837_(0.0 + (double)x + offset, 0.0 + (double)y, -distance);
        } else if (direction == Direction.WEST) {
            pos = new BlockPos((double)tePos.m_123341_() + distance, (double)(tePos.m_123342_() + y), (double)(tePos.m_123343_() + x) + offset);
            pose.m_85837_(distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        } else if (direction == Direction.EAST) {
            pos = new BlockPos((double)tePos.m_123341_() + -distance, (double)(tePos.m_123342_() + y), (double)(tePos.m_123343_() + x) + offset);
            pose.m_85837_(-distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        }
        return pos;
    }

    public boolean shouldRenderOffScreen(ProjectorBlockEntity te) {
        return true;
    }
}

