/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.RetinalScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class RetinalScannerTileEntityRenderer
implements BlockEntityRenderer<RetinalScannerBlockEntity> {
    private static final float CORRECT_FACTOR = 0.0018181818f;

    public RetinalScannerTileEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(RetinalScannerBlockEntity te, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = (Direction)te.m_58900_().m_61143_((Property)RetinalScannerBlock.FACING);
        if (!te.hasModule(ModuleType.DISGUISE) && direction != null) {
            matrix.m_85836_();
            switch (direction) {
                case NORTH: {
                    matrix.m_85837_(0.25, 0.0625, 0.0);
                    break;
                }
                case SOUTH: {
                    matrix.m_85837_(0.75, 0.0625, 1.0);
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    break;
                }
                case WEST: {
                    matrix.m_85837_(0.0, 0.0625, 0.75);
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                    break;
                }
                case EAST: {
                    matrix.m_85837_(1.0, 0.0625, 0.25);
                    matrix.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                    break;
                }
            }
            matrix.m_85841_(-1.0f, -1.0f, 1.0f);
            VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)RetinalScannerTileEntityRenderer.getSkinTexture(te.getPlayerProfile())));
            Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
            Matrix3f normalMatrix = matrix.m_85850_().m_85864_();
            Vec3i normalVector = direction.m_122436_();
            BlockPos offsetPos = te.m_58899_().m_142300_(direction);
            combinedLight = LightTexture.m_109885_((int)te.m_58904_().m_45517_(LightLayer.BLOCK, offsetPos), (int)te.m_58904_().m_45517_(LightLayer.SKY, offsetPos));
            vertexBuilder.m_85982_(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.125f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.125f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.25f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.25f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, 0.0018181818f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.625f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, 0.0018181818f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.625f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, -0.5018182f, -0.5009091f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.75f, 0.125f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            vertexBuilder.m_85982_(positionMatrix, -0.5018182f, 0.0027272727f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.75f, 0.25f).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_85977_(normalMatrix, (float)normalVector.m_123341_(), (float)normalVector.m_123342_(), (float)normalVector.m_123343_()).m_5752_();
            matrix.m_85849_();
        }
    }

    private static ResourceLocation getSkinTexture(@Nullable GameProfile profile) {
        if (((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() && profile != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(profile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.m_118627_((UUID)Player.m_36198_((GameProfile)profile));
        }
        return DefaultPlayerSkin.m_118626_();
    }
}

