/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.StackHoverChecker;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import net.minecraftforge.fmlclient.gui.widget.Slider;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public class BlockPocketManagerScreen
extends AbstractContainerScreen<BlockPocketManagerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager.png");
    private static final ResourceLocation TEXTURE_STORAGE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager_storage.png");
    private static final ItemStack BLOCK_POCKET_WALL = new ItemStack((ItemLike)SCContent.BLOCK_POCKET_WALL.get());
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack((ItemLike)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get());
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get());
    private final TranslatableComponent blockPocketManager = Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]);
    private final TranslatableComponent youNeed = Utils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0]);
    private final boolean storage;
    private final boolean isOwner;
    private final int[] materialCounts = new int[3];
    public BlockPocketManagerBlockEntity te;
    private int size = 5;
    private final int[] allowedSizes = new int[]{5, 9, 13, 17, 21, 25};
    private Button toggleButton;
    private Button sizeButton;
    private Button assembleButton;
    private Button outlineButton;
    private Slider offsetSlider;
    private StackHoverChecker[] hoverCheckers = new StackHoverChecker[3];
    private TextHoverChecker assembleHoverChecker;
    private int wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
    private int pillarsNeededOverall = (this.size - 2) * 12 - 1;
    private final int chiseledNeededOverall = 8;
    private int wallsStillNeeded;
    private int pillarsStillNeeded;
    private int chiseledStillNeeded;

    public BlockPocketManagerScreen(BlockPocketManagerMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.te = container.te;
        this.size = this.te.size;
        this.isOwner = container.isOwner;
        this.storage = container.storage;
        if (this.storage) {
            this.f_97726_ = 256;
        }
        this.f_97727_ = !this.storage ? 194 : 240;
    }

    public void m_7856_() {
        int[] nArray;
        super.m_7856_();
        int width = this.storage ? 123 : this.f_97726_;
        int widgetWidth = this.storage ? 110 : 120;
        int widgetOffset = widgetWidth / 2;
        if (this.storage) {
            int[] nArray2 = new int[5];
            nArray2[0] = -76;
            nArray2[1] = -100;
            nArray2[2] = -52;
            nArray2[3] = -28;
            nArray = nArray2;
            nArray2[4] = -4;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = -40;
            nArray3[1] = -70;
            nArray3[2] = 23;
            nArray3[3] = 47;
            nArray = nArray3;
            nArray3[4] = 71;
        }
        int[] yOffset = nArray;
        this.toggleButton = new IdButton(0, this.f_97735_ + width / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[0], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager." + (!this.te.enabled ? "activate" : "deactivate"), new Object[0]), this::toggleButtonClicked);
        this.m_142416_((GuiEventListener)this.toggleButton);
        this.sizeButton = new ToggleComponentButton(1, this.f_97735_ + width / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[1], widgetWidth, 20, this::updateSizeButtonText, ArrayUtils.indexOf((int[])this.allowedSizes, (int)this.size), this.allowedSizes.length, this::sizeButtonClicked);
        this.m_142416_((GuiEventListener)this.sizeButton);
        this.assembleButton = new IdButton(2, this.f_97735_ + width / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[2], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.assemble", new Object[0]), this::assembleButtonClicked);
        this.m_142416_((GuiEventListener)this.assembleButton);
        this.outlineButton = new IdButton(3, this.f_97735_ + width / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[3], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]), this::outlineButtonClicked);
        this.m_142416_((GuiEventListener)this.outlineButton);
        this.offsetSlider = new NamedSlider((Component)Utils.localize("gui.securitycraft:projector.offset", this.te.autoBuildOffset), TextComponent.f_131282_, 4, this.f_97735_ + width / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[4], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.offset", ""), "", (-this.size + 2) / 2, (this.size - 2) / 2, this.te.autoBuildOffset, false, true, null, this::offsetSliderReleased);
        this.m_142416_((GuiEventListener)this.offsetSlider);
        this.offsetSlider.updateSlider();
        if (!this.te.getOwner().isOwner((Player)Minecraft.m_91087_().f_91074_)) {
            this.offsetSlider.f_93623_ = false;
            this.outlineButton.f_93623_ = false;
            this.assembleButton.f_93623_ = false;
            this.toggleButton.f_93623_ = false;
            this.sizeButton.f_93623_ = false;
        } else {
            this.updateMaterialInformation(true);
            this.offsetSlider.f_93623_ = !this.te.enabled;
            this.sizeButton.f_93623_ = this.offsetSlider.f_93623_;
        }
        if (!this.storage) {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 23, this.f_97735_ + 43);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 75, this.f_97735_ + 95);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 128, this.f_97735_ + 148);
        } else {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.f_97736_ + this.f_97727_ - 73, this.f_97736_ + this.f_97727_ - 54, this.f_97735_ + 174, this.f_97735_ + 191);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.f_97736_ + this.f_97727_ - 50, this.f_97736_ + this.f_97727_ - 31, this.f_97735_ + 174, this.f_97735_ + 191);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.f_97736_ + this.f_97727_ - 27, this.f_97736_ + this.f_97727_ - 9, this.f_97735_ + 174, this.f_97735_ + 191);
        }
        this.assembleHoverChecker = new TextHoverChecker((AbstractWidget)this.assembleButton, Arrays.asList(Utils.localize("gui.securitycraft:blockPocketManager.needStorageModule", new Object[0]), Utils.localize("messages.securitycraft:blockpocket.notEnoughItems", new Object[0])));
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrix, (Component)this.blockPocketManager, (float)((this.storage ? 123 : this.f_97726_) / 2 - this.f_96547_.m_92852_((FormattedText)this.blockPocketManager) / 2), 6.0f, 0x404040);
        if (this.storage) {
            this.f_96547_.m_92889_(matrix, this.f_169604_, 8.0f, (float)(this.f_97727_ - 94), 0x404040);
            this.m_7025_(matrix, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (!this.te.enabled && this.isOwner) {
            if (!this.storage) {
                this.f_96547_.m_92889_(matrix, (Component)this.youNeed, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.youNeed) / 2), 83.0f, 0x404040);
                this.f_96547_.m_92883_(matrix, "" + this.wallsNeededOverall, 42.0f, 100.0f, 0x404040);
                this.f_96541_.m_91291_().m_115203_(BLOCK_POCKET_WALL, 25, 96);
                this.f_96547_.m_92883_(matrix, "" + this.pillarsNeededOverall, 94.0f, 100.0f, 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 77, 96);
                this.f_96547_.m_92883_(matrix, "8", 147.0f, 100.0f, 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 130, 96);
            } else {
                this.f_96547_.m_92889_(matrix, (Component)this.youNeed, (float)(212 - this.f_96547_.m_92852_((FormattedText)this.youNeed) / 2), (float)(this.f_97727_ - 83), 0x404040);
                this.f_96547_.m_92883_(matrix, "" + Math.max(0, this.wallsStillNeeded), 192.0f, (float)(this.f_97727_ - 66), 0x404040);
                this.f_96541_.m_91291_().m_115203_(BLOCK_POCKET_WALL, 175, this.f_97727_ - 70);
                this.f_96547_.m_92883_(matrix, "" + Math.max(0, this.pillarsStillNeeded), 192.0f, (float)(this.f_97727_ - 44), 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 175, this.f_97727_ - 48);
                this.f_96547_.m_92883_(matrix, "" + Math.max(0, this.chiseledStillNeeded), 192.0f, (float)(this.f_97727_ - 22), 0x404040);
                this.f_96541_.m_91291_().m_115203_(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 175, this.f_97727_ - 26);
            }
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (!this.te.enabled && this.isOwner) {
            for (StackHoverChecker shc : this.hoverCheckers) {
                if (!shc.checkHover(mouseX, mouseY)) continue;
                this.m_6057_(matrix, shc.getStack(), mouseX, mouseY);
                return;
            }
        }
        if (!this.te.enabled && this.isOwner && !this.assembleButton.f_93623_ && this.assembleHoverChecker.checkHover(mouseX, mouseY)) {
            if (!this.storage) {
                GuiUtils.drawHoveringText((PoseStack)matrix, this.assembleHoverChecker.getLines().subList(0, 1), (int)mouseX, (int)mouseY, (int)this.f_96543_, (int)this.f_96544_, (int)-1, (Font)this.f_96547_);
            } else {
                GuiUtils.drawHoveringText((PoseStack)matrix, this.assembleHoverChecker.getLines().subList(1, 2), (int)mouseX, (int)mouseY, (int)this.f_96543_, (int)this.f_96544_, (int)-1, (Font)this.f_96547_);
            }
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)(this.storage ? TEXTURE_STORAGE : TEXTURE));
        this.m_93228_(matrix, startX, startY, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
        this.updateMaterialInformation(true);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.offsetSlider.dragging) {
            this.offsetSlider.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void updateMaterialInformation(boolean recalculateStoredStacks) {
        if (recalculateStoredStacks) {
            this.materialCounts[2] = 0;
            this.materialCounts[1] = 0;
            this.materialCounts[0] = 0;
            this.te.getStorageHandler().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    Item blockItem$temp = stack.m_41720_();
                    if (!(blockItem$temp instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)blockItem$temp;
                    Block block = blockItem.m_40614_();
                    if (block == SCContent.BLOCK_POCKET_WALL.get()) {
                        this.materialCounts[0] = this.materialCounts[0] + stack.m_41613_();
                        continue;
                    }
                    if (block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                        this.materialCounts[1] = this.materialCounts[1] + stack.m_41613_();
                        continue;
                    }
                    if (block != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) continue;
                    this.materialCounts[2] = this.materialCounts[2] + stack.m_41613_();
                }
            });
        }
        this.wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
        this.pillarsNeededOverall = (this.size - 2) * 12 - 1;
        this.wallsStillNeeded = this.wallsNeededOverall - this.materialCounts[0];
        this.pillarsStillNeeded = this.pillarsNeededOverall - this.materialCounts[1];
        this.chiseledStillNeeded = 8 - this.materialCounts[2];
        this.assembleButton.f_93623_ = this.isOwner && (this.f_96541_.f_91074_.m_7500_() || !this.te.enabled && this.storage && this.wallsStillNeeded <= 0 && this.pillarsStillNeeded <= 0 && this.chiseledStillNeeded <= 0);
    }

    public void toggleButtonClicked(IdButton button) {
        if (this.te.enabled) {
            this.te.disableMultiblock();
        } else {
            this.te.size = this.size;
            TranslatableComponent feedback = this.te.enableMultiblock();
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer((Player)Minecraft.m_91087_().f_91074_, (MutableComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), (MutableComponent)feedback, ChatFormatting.DARK_AQUA, true);
            }
        }
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    public void sizeButtonClicked(IdButton button) {
        this.size = this.allowedSizes[((ToggleComponentButton)button).getCurrentIndex()];
        int newMin = (-this.size + 2) / 2;
        int newMax = (this.size - 2) / 2;
        int newOffset = this.te.autoBuildOffset > 0 ? Math.min(this.te.autoBuildOffset, newMax) : Math.max(this.te.autoBuildOffset, newMin);
        this.updateMaterialInformation(false);
        this.te.size = this.size;
        this.offsetSlider.minValue = newMin;
        this.offsetSlider.maxValue = newMax;
        this.te.autoBuildOffset = newOffset;
        this.offsetSlider.setValue((double)newOffset);
        this.offsetSlider.updateSlider();
        this.sync();
        ((ToggleComponentButton)button).onValueChange();
    }

    public Component updateSizeButtonText(int index) {
        return Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size);
    }

    public void assembleButtonClicked(IdButton button) {
        this.te.size = this.size;
        MutableComponent feedback = this.te.autoAssembleMultiblock();
        if (feedback != null) {
            PlayerUtils.sendMessageToPlayer((Player)Minecraft.m_91087_().f_91074_, (MutableComponent)Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), feedback, ChatFormatting.DARK_AQUA, true);
        }
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    public void outlineButtonClicked(IdButton button) {
        this.te.toggleOutline();
        this.outlineButton.m_93666_((Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]));
        this.sync();
    }

    public void offsetSliderReleased(Slider slider) {
        this.te.autoBuildOffset = slider.getValueInt();
        this.sync();
    }

    private void sync() {
        SecurityCraft.channel.send(PacketDistributor.SERVER.noArg(), (Object)new SyncBlockPocketManager(this.te.m_58899_(), this.te.size, this.te.showOutline, this.te.autoBuildOffset));
    }
}

