/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.SecurityCraftBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CameraMonitorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final TranslatableComponent selectCameras = Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]);
    private Inventory playerInventory;
    private CameraMonitorItem cameraMonitor;
    private CompoundTag nbtTag;
    private IdButton prevPageButton;
    private IdButton nextPageButton;
    private IdButton[] cameraButtons = new IdButton[10];
    private IdButton[] unbindButtons = new IdButton[10];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private SecurityCraftBlockEntity[] cameraTEs = new SecurityCraftBlockEntity[10];
    private ResourceLocation[] cameraViewDim = new ResourceLocation[10];
    private int xSize = 176;
    private int ySize = 166;
    private int page = 1;

    public CameraMonitorScreen(Inventory inventory, CameraMonitorItem item, CompoundTag itemNBTTag) {
        super((Component)new TranslatableComponent(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_()));
        this.playerInventory = inventory;
        this.cameraMonitor = item;
        this.nbtTag = itemNBTTag;
    }

    public CameraMonitorScreen(Inventory inventory, CameraMonitorItem item, CompoundTag itemNBTTag, int page) {
        this(inventory, item, itemNBTTag);
        this.page = page;
    }

    public void m_7856_() {
        int i;
        super.m_7856_();
        this.prevPageButton = new IdButton(-1, this.f_96543_ / 2 - 68, this.f_96544_ / 2 + 40, 20, 20, "<", this::actionPerformed);
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.nextPageButton = new IdButton(0, this.f_96543_ / 2 + 52, this.f_96544_ / 2 + 40, 20, 20, ">", this::actionPerformed);
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.cameraButtons[0] = new IdButton(1, this.f_96543_ / 2 - 38, this.f_96544_ / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[1] = new IdButton(2, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[2] = new IdButton(3, this.f_96543_ / 2 + 22, this.f_96544_ / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[3] = new IdButton(4, this.f_96543_ / 2 - 38, this.f_96544_ / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[4] = new IdButton(5, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[5] = new IdButton(6, this.f_96543_ / 2 + 22, this.f_96544_ / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[6] = new IdButton(7, this.f_96543_ / 2 - 38, this.f_96544_ / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[7] = new IdButton(8, this.f_96543_ / 2 - 8, this.f_96544_ / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[8] = new IdButton(9, this.f_96543_ / 2 + 22, this.f_96544_ / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[9] = new IdButton(10, this.f_96543_ / 2 - 38, this.f_96544_ / 2 + 40, 80, 20, "", this::actionPerformed);
        this.unbindButtons[0] = new IdButton(11, this.f_96543_ / 2 - 19, this.f_96544_ / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[1] = new IdButton(12, this.f_96543_ / 2 + 11, this.f_96544_ / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[2] = new IdButton(13, this.f_96543_ / 2 + 41, this.f_96544_ / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[3] = new IdButton(14, this.f_96543_ / 2 - 19, this.f_96544_ / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[4] = new IdButton(15, this.f_96543_ / 2 + 11, this.f_96544_ / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[5] = new IdButton(16, this.f_96543_ / 2 + 41, this.f_96544_ / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[6] = new IdButton(17, this.f_96543_ / 2 - 19, this.f_96544_ / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[7] = new IdButton(18, this.f_96543_ / 2 + 11, this.f_96544_ / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[8] = new IdButton(19, this.f_96543_ / 2 + 41, this.f_96544_ / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[9] = new IdButton(20, this.f_96543_ / 2 + 41, this.f_96544_ / 2 + 32, 8, 8, "x", this::actionPerformed);
        for (i = 0; i < 10; ++i) {
            IdButton button = this.cameraButtons[i];
            int camID = button.id + (this.page - 1) * 10;
            ArrayList<GlobalPos> views = this.cameraMonitor.getCameraPositions(this.nbtTag);
            button.m_93666_((Component)button.m_6035_().m_6879_().m_7220_((Component)new TextComponent("" + camID)));
            this.m_142416_((GuiEventListener)button);
            GlobalPos view = views.get(camID - 1);
            if (view != null) {
                SecurityCameraBlockEntity te;
                BlockEntity blockEntity;
                if (!view.m_122640_().equals((Object)Minecraft.m_91087_().f_91074_.f_19853_.m_46472_())) {
                    this.hoverCheckers[button.id - 1] = new HoverChecker((AbstractWidget)button);
                    this.cameraViewDim[button.id - 1] = view.m_122640_().m_135782_();
                }
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                BlockEntity tile = world.m_7702_(view.m_122646_());
                if (world.m_8055_(view.m_122646_()).m_60734_() != SCContent.SECURITY_CAMERA.get() || (blockEntity = tile) instanceof SecurityCameraBlockEntity && !(te = (SecurityCameraBlockEntity)blockEntity).getOwner().isOwner((Player)Minecraft.m_91087_().f_91074_) && !te.hasModule(ModuleType.SMART)) {
                    button.f_93623_ = false;
                    this.cameraTEs[button.id - 1] = null;
                    continue;
                }
                this.cameraTEs[button.id - 1] = (SecurityCraftBlockEntity)tile;
                this.hoverCheckers[button.id - 1] = new HoverChecker((AbstractWidget)button);
                continue;
            }
            button.f_93623_ = false;
            this.unbindButtons[button.id - 1].f_93623_ = false;
            this.cameraTEs[button.id - 1] = null;
        }
        for (i = 0; i < 10; ++i) {
            this.m_142416_((GuiEventListener)this.unbindButtons[i]);
        }
        if (this.page == 1) {
            this.prevPageButton.f_93623_ = false;
        }
        if (this.page == 3 || this.cameraMonitor.getCameraPositions(this.nbtTag).size() < this.page * 10 + 1) {
            this.nextPageButton.f_93623_ = false;
        }
        for (i = this.cameraMonitor.getCameraPositions(this.nbtTag).size() + 1; i <= this.page * 10; ++i) {
            this.cameraButtons[i - 1 - (this.page - 1) * 10].f_93623_ = false;
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_93228_(matrix, startX, startY, 0, 0, this.xSize, this.ySize);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(matrix, (Component)this.selectCameras, (float)(startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.selectCameras) / 2), (float)(startY + 6), 0x404040);
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (this.cameraTEs[i] == null) {
                this.m_96617_(matrix, this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:monitor.cameraInDifferentDim", this.cameraViewDim[i]), 150), mouseX, mouseY);
            }
            if (this.cameraTEs[i] == null || !this.cameraTEs[i].hasCustomSCName()) continue;
            this.m_96617_(matrix, this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:monitor.cameraName", this.cameraTEs[i].getCustomSCName()), 150), mouseX, mouseY);
        }
    }

    protected void actionPerformed(IdButton button) {
        if (button.id == this.prevPageButton.id) {
            this.f_96541_.m_91152_((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page - 1));
        } else if (button.id == this.nextPageButton.id) {
            this.f_96541_.m_91152_((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page + 1));
        } else if (button.id < 11) {
            int camID = button.id + (this.page - 1) * 10;
            GlobalPos view = this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1);
            Block block = Minecraft.m_91087_().f_91073_.m_8055_(view.m_122646_()).m_60734_();
            if (block == SCContent.SECURITY_CAMERA.get()) {
                ((SecurityCameraBlock)block).mountCamera((Level)Minecraft.m_91087_().f_91073_, view.m_122646_(), camID, (Player)Minecraft.m_91087_().f_91074_);
                SecurityCraft.channel.sendToServer((Object)new MountCamera(view.m_122646_(), camID));
                Minecraft.m_91087_().f_91074_.m_6915_();
            } else {
                button.f_93623_ = false;
            }
        } else {
            int camID = button.id - 10 + (this.page - 1) * 10;
            SecurityCraft.channel.sendToServer((Object)new RemoveCameraTag(PlayerUtils.getSelectedItemStack(this.playerInventory, (Item)SCContent.CAMERA_MONITOR.get()), camID));
            this.nbtTag.m_128473_(CameraMonitorItem.getTagNameFromPosition(this.nbtTag, this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1)));
            button.f_93623_ = false;
            this.cameraButtons[(camID - 1) % 10].f_93623_ = false;
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

