/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmlclient.gui.widget.Slider;

@OnlyIn(value=Dist.CLIENT)
public class CustomizeBlockScreen
extends AbstractContainerScreen<CustomizeBlockMenu> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft:textures/gui/container/customize0.png"), new ResourceLocation("securitycraft:textures/gui/container/customize1.png"), new ResourceLocation("securitycraft:textures/gui/container/customize2.png"), new ResourceLocation("securitycraft:textures/gui/container/customize3.png"), new ResourceLocation("securitycraft:textures/gui/container/customize4.png"), new ResourceLocation("securitycraft:textures/gui/container/customize5.png")};
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private IModuleInventory moduleInv;
    private PictureButton[] descriptionButtons = new PictureButton[5];
    private Button[] optionButtons = new Button[5];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private final String blockName;

    public CustomizeBlockScreen(CustomizeBlockMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.moduleInv = container.moduleInv;
        this.blockName = container.moduleInv.getTileEntity().m_58900_().m_60734_().m_7705_().substring(5);
    }

    public void m_7856_() {
        ICustomizable customizable;
        super.m_7856_();
        int numberOfColumns = 2;
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = new PictureButton(i, this.f_97735_ + 127 + column * 22, this.f_97736_ + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.f_96542_, new ItemStack((ItemLike)this.moduleInv.acceptedModules()[i].getItem()));
            this.m_142416_((GuiEventListener)this.descriptionButtons[i]);
            this.hoverCheckers[i] = new HoverChecker((AbstractWidget)this.descriptionButtons[i]);
        }
        BlockEntity te = this.moduleInv.getTileEntity();
        BlockEntity blockEntity = te;
        if (blockEntity instanceof ICustomizable && (customizable = (ICustomizable)blockEntity).customOptions() != null) {
            for (int i = 0; i < customizable.customOptions().length; ++i) {
                Option<?> option = customizable.customOptions()[i];
                if (option instanceof Slider.ISlider && option.isSlider()) {
                    TranslatableComponent translatedBlockName = Utils.localize(this.blockName, new Object[0]);
                    if (option instanceof Option.DoubleOption) {
                        this.optionButtons[i] = new NamedSlider((Component)Utils.localize("option" + this.blockName + "." + option.getName(), option.toString()), (Component)translatedBlockName, i, this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, TextComponent.f_131282_, "", (Double)((Option.DoubleOption)option).getMin(), (Double)((Option.DoubleOption)option).getMax(), (Double)((Option.DoubleOption)option).get(), true, false, (Slider.ISlider)option, null);
                    } else if (option instanceof Option.IntOption) {
                        this.optionButtons[i] = new NamedSlider((Component)Utils.localize("option" + this.blockName + "." + option.getName(), option.toString()), (Component)translatedBlockName, i, this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, TextComponent.f_131282_, "", (Integer)((Option.IntOption)option).getMin(), (Integer)((Option.IntOption)option).getMax(), (Integer)((Option.IntOption)option).get(), true, false, (Slider.ISlider)option, null);
                    }
                    this.optionButtons[i].setFGColor(0xE0E0E0);
                } else {
                    this.optionButtons[i] = new IdButton(i, this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option), this::actionPerformed);
                    this.optionButtons[i].setFGColor(option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
                }
                this.m_142416_((GuiEventListener)this.optionButtons[i]);
                this.hoverCheckers[i + this.moduleInv.getMaxNumberOfModules()] = new HoverChecker((AbstractWidget)this.optionButtons[i]);
            }
        }
        for (Button button : this.optionButtons) {
            if (button == null) continue;
            this.extraAreas.add(new Rect2i(button.f_93620_, button.f_93621_, button.m_5711_(), button.m_93694_()));
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (Button b : this.optionButtons) {
            Button button2 = b;
            if (!(button2 instanceof Slider)) continue;
            Slider slider = (Slider)button2;
            if (!slider.dragging) continue;
            slider.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().m_7993_().m_41619_()) {
            this.m_6057_(matrix, this.getSlotUnderMouse().m_7993_(), mouseX, mouseY);
        }
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (i < this.moduleInv.getMaxNumberOfModules()) {
                this.m_96617_(matrix, this.f_96541_.f_91062_.m_92923_((FormattedText)this.getModuleDescription(i), 150), mouseX, mouseY);
                continue;
            }
            this.m_96617_(matrix, this.f_96541_.f_91062_.m_92923_((FormattedText)this.getOptionDescription(i), 150), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        TranslatableComponent s = Utils.localize(this.moduleInv.getTileEntity().m_58900_().m_60734_().m_7705_(), new Object[0]);
        this.f_96547_.m_92889_(matrix, (Component)s, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)s) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrix, (Component)Utils.localize("container.inventory", new Object[0]), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURES[this.moduleInv.getMaxNumberOfModules()]);
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrix, startX, startY, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void actionPerformed(IdButton button) {
        Option<?> tempOption = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[button.id];
        tempOption.toggle();
        button.setFGColor(tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
        button.m_93666_(this.getOptionButtonTitle(tempOption));
        SecurityCraft.channel.sendToServer((Object)new ToggleOption(this.moduleInv.getTileEntity().m_58899_().m_123341_(), this.moduleInv.getTileEntity().m_58899_().m_123342_(), this.moduleInv.getTileEntity().m_58899_().m_123343_(), button.id));
    }

    private Component getModuleDescription(int buttonID) {
        String moduleDescription = "module" + this.blockName + "." + this.descriptionButtons[buttonID].getItemStack().m_5524_().substring(5).replace("securitycraft.", "") + ".description";
        return Utils.localize(this.descriptionButtons[buttonID].getItemStack().m_5524_(), new Object[0]).m_7220_((Component)new TextComponent(":")).m_130940_(ChatFormatting.RESET).m_7220_((Component)new TextComponent("\n\n")).m_7220_((Component)Utils.localize(moduleDescription, new Object[0]));
    }

    private TranslatableComponent getOptionDescription(int buttonID) {
        Option<?> option = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[buttonID - this.moduleInv.getSlots()];
        String optionDescription = "option" + this.blockName + "." + option.getName() + ".description";
        return Utils.localize("gui.securitycraft:customize.tooltip", new TranslatableComponent(optionDescription), new TranslatableComponent("gui.securitycraft:customize.currentSetting", new Object[]{this.getValueText(option)}));
    }

    private Component getOptionButtonTitle(Option<?> option) {
        return Utils.localize("option" + this.blockName + "." + option.getName(), this.getValueText(option));
    }

    private Component getValueText(Option<?> option) {
        Option<?> option2 = option;
        if (option2 instanceof Option.BooleanOption) {
            Option.BooleanOption booleanOption = (Option.BooleanOption)option2;
            return new TranslatableComponent((Boolean)booleanOption.get() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no");
        }
        return new TextComponent(option.toString());
    }

    public List<Rect2i> getGuiExtraAreas() {
        return this.extraAreas;
    }
}

