/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayDeque;
import java.util.Objects;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.ColorableScrollPanel;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditModuleScreen
extends Screen {
    private static CompoundTag savedModule;
    private static final ResourceLocation TEXTURE;
    private final TranslatableComponent editModule = Utils.localize("gui.securitycraft:editModule", new Object[0]);
    private ItemStack module = ItemStack.f_41583_;
    private EditBox inputField;
    private IdButton addButton;
    private IdButton removeButton;
    private IdButton copyButton;
    private IdButton pasteButton;
    private IdButton clearButton;
    private int xSize = 247;
    private int ySize = 166;
    private PlayerList playerList;
    private int guiLeft;

    public EditModuleScreen(ItemStack item) {
        super((Component)new TranslatableComponent(item.m_41778_()));
        this.module = item;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        int controlsStartX = (int)((float)this.guiLeft + (float)this.xSize * 0.75f) - 43;
        this.f_96541_.f_91068_.m_90926_(true);
        this.inputField = new EditBox(this.f_96547_, controlsStartX - 17, this.f_96544_ / 2 - 65, 110, 15, TextComponent.f_131282_);
        this.m_142416_((GuiEventListener)this.inputField);
        this.addButton = new IdButton(0, controlsStartX, this.f_96544_ / 2 - 45, 76, 20, (Component)Utils.localize("gui.securitycraft:editModule.add", new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.addButton);
        this.removeButton = new IdButton(1, controlsStartX, this.f_96544_ / 2 - 20, 76, 20, (Component)Utils.localize("gui.securitycraft:editModule.remove", new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.removeButton);
        this.copyButton = new IdButton(2, controlsStartX, this.f_96544_ / 2 + 5, 76, 20, (Component)Utils.localize("gui.securitycraft:editModule.copy", new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.copyButton);
        this.pasteButton = new IdButton(3, controlsStartX, this.f_96544_ / 2 + 30, 76, 20, (Component)Utils.localize("gui.securitycraft:editModule.paste", new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.pasteButton);
        this.clearButton = new IdButton(4, controlsStartX, this.f_96544_ / 2 + 55, 76, 20, (Component)Utils.localize("gui.securitycraft:editModule.clear", new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.clearButton);
        this.m_142416_((GuiEventListener)this.clearButton);
        this.playerList = new PlayerList(this.f_96541_, 110, 141, this.f_96544_ / 2 - 66, this.guiLeft + 10);
        this.m_169394_((Widget)this.playerList);
        this.addButton.f_93623_ = false;
        this.removeButton.f_93623_ = false;
        if (this.module.m_41783_() == null || this.module.m_41783_().m_128456_() || this.module.m_41783_() != null && this.module.m_41783_().equals((Object)savedModule)) {
            this.copyButton.f_93623_ = false;
        }
        if (savedModule == null || savedModule.m_128456_() || this.module.m_41783_() != null && this.module.m_41783_().equals((Object)savedModule)) {
            this.pasteButton.f_93623_ = false;
        }
        if (this.module.m_41783_() == null || this.module.m_41783_().m_128456_()) {
            this.clearButton.f_93623_ = false;
        }
        this.inputField.m_94199_(16);
        this.inputField.m_94153_(s -> !s.contains(" "));
        this.inputField.m_94151_(s -> {
            if (s.isEmpty()) {
                this.addButton.f_93623_ = false;
            } else {
                if (this.module.m_41782_()) {
                    for (int i = 1; i <= 50; ++i) {
                        if (!s.equals(this.module.m_41783_().m_128461_("Player" + i))) continue;
                        this.addButton.f_93623_ = false;
                        this.removeButton.f_93623_ = true;
                        this.playerList.setSelectedIndex(i - 1);
                        return;
                    }
                }
                this.addButton.f_93623_ = true;
            }
            this.removeButton.f_93623_ = false;
            this.playerList.setSelectedIndex(-1);
        });
        this.m_94718_((GuiEventListener)this.inputField);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(false);
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_93228_(matrix, startX, startY, 0, 0, this.xSize, this.ySize);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92857_((FormattedText)this.editModule, startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.editModule) / 2, startY + 6, this.f_96543_, 0x404040);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.playerList != null && this.playerList.m_5953_(mouseX, mouseY)) {
            this.playerList.m_6050_(mouseX, mouseY, scroll);
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.playerList != null) {
            this.playerList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void actionPerformed(IdButton button) {
        if (button.id == this.addButton.id) {
            if (this.inputField.m_94155_().isEmpty()) {
                return;
            }
            if (this.module.m_41783_() == null) {
                this.module.m_41751_(new CompoundTag());
            }
            for (int i = 1; i <= 50; ++i) {
                if (!this.module.m_41783_().m_128441_("Player" + i) || !this.module.m_41783_().m_128461_("Player" + i).equals(this.inputField.m_94155_())) continue;
                if (i == 9) {
                    this.addButton.f_93623_ = false;
                }
                return;
            }
            this.module.m_41783_().m_128359_("Player" + this.getNextFreeSlot(this.module.m_41783_()), this.inputField.m_94155_());
            if (this.module.m_41783_() != null && this.module.m_41783_().m_128441_("Player50")) {
                this.addButton.f_93623_ = false;
            }
            this.inputField.m_94144_("");
        } else if (button.id == this.removeButton.id) {
            if (this.inputField.m_94155_().isEmpty()) {
                return;
            }
            if (this.module.m_41783_() == null) {
                this.module.m_41751_(new CompoundTag());
            }
            for (int i = 1; i <= 50; ++i) {
                if (!this.module.m_41783_().m_128441_("Player" + i) || !this.module.m_41783_().m_128461_("Player" + i).equals(this.inputField.m_94155_())) continue;
                this.module.m_41783_().m_128473_("Player" + i);
                this.defragmentTag(this.module.m_41783_());
            }
            this.inputField.m_94144_("");
        } else {
            if (button.id == this.copyButton.id) {
                savedModule = this.module.m_41783_().m_6426_();
                this.copyButton.f_93623_ = false;
                return;
            }
            if (button.id == this.pasteButton.id) {
                this.module.m_41751_(savedModule.m_6426_());
            } else if (button.id == this.clearButton.id) {
                this.module.m_41751_(new CompoundTag());
                this.inputField.m_94144_("");
            } else {
                return;
            }
        }
        if (this.module.m_41783_() != null) {
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(this.module));
        }
        this.addButton.f_93623_ = this.module.m_41783_() != null && !this.module.m_41783_().m_128441_("Player50") && !this.inputField.m_94155_().isEmpty();
        this.removeButton.f_93623_ = this.module.m_41783_() != null && !this.module.m_41783_().m_128456_() && !this.inputField.m_94155_().isEmpty();
        this.copyButton.f_93623_ = this.module.m_41783_() != null && !this.module.m_41783_().m_128456_() && (this.module.m_41783_() == null || !this.module.m_41783_().equals((Object)savedModule));
        this.pasteButton.f_93623_ = savedModule != null && !savedModule.m_128456_() && (this.module.m_41783_() == null || !this.module.m_41783_().equals((Object)savedModule));
        this.clearButton.f_93623_ = this.module.m_41783_() != null && !this.module.m_41783_().m_128456_();
    }

    private int getNextFreeSlot(CompoundTag tag) {
        for (int i = 1; i <= 50; ++i) {
            if (tag.m_128441_("Player" + i) && !tag.m_128461_("Player" + i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    private void defragmentTag(CompoundTag tag) {
        ArrayDeque<Integer> freeIndices = new ArrayDeque<Integer>();
        for (int i = 1; i <= 50; ++i) {
            if (!tag.m_128441_("Player" + i) || tag.m_128461_("Player" + i).isEmpty()) {
                freeIndices.add(i);
                continue;
            }
            if (freeIndices.isEmpty()) continue;
            String player = tag.m_128461_("Player" + i);
            int nextFreeIndex = (Integer)freeIndices.poll();
            tag.m_128359_("Player" + nextFreeIndex, player);
            tag.m_128473_("Player" + i);
            freeIndices.add(i);
        }
    }

    static {
        TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/edit_module.png");
    }

    class PlayerList
    extends ColorableScrollPanel {
        private final int slotHeight = 12;
        private final int listLength = 50;
        private int selectedIndex;

        public PlayerList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.listLength = 50;
            this.selectedIndex = -1;
        }

        protected int getContentHeight() {
            Objects.requireNonNull(EditModuleScreen.this.f_96547_);
            int height = 50 + 50 * 9;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY) && mouseX < (double)(this.left + this.width - 6)) {
                int clickedIndex = (int)(mouseY - (double)this.top + (double)this.scrollDistance - 4.0) / 12;
                if (EditModuleScreen.this.module.m_41782_() && EditModuleScreen.this.module.m_41783_().m_128441_("Player" + (clickedIndex + 1))) {
                    this.selectedIndex = clickedIndex;
                    EditModuleScreen.this.inputField.m_94144_(EditModuleScreen.this.module.m_41783_().m_128461_("Player" + (clickedIndex + 1)));
                }
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        protected void drawPanel(PoseStack matrix, int entryRight, int relativeY, Tesselator tessellator, int mouseX, int mouseY) {
            if (EditModuleScreen.this.module.m_41782_()) {
                CompoundTag tag = EditModuleScreen.this.module.m_41783_();
                int baseY = this.top + 4 - (int)this.scrollDistance;
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 4.0f);
                int slotIndex = mouseListY / 12;
                if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 50 && mouseY >= this.top && mouseY <= this.bottom && tag.m_128441_("Player" + (slotIndex + 1)) && !tag.m_128461_("Player" + (slotIndex + 1)).isEmpty()) {
                    this.renderBox(tessellator.m_85915_(), this.left, entryRight - 6, baseY + slotIndex * 12, 8, 128);
                }
                if (this.selectedIndex >= 0) {
                    this.renderBox(tessellator.m_85915_(), this.left, entryRight - 6, baseY + this.selectedIndex * 12, 8, 255);
                }
                for (int i = 0; i < 50; ++i) {
                    String name;
                    if (!tag.m_128441_("Player" + (i + 1)) || (name = tag.m_128461_("Player" + (i + 1))).isEmpty()) continue;
                    EditModuleScreen.this.f_96547_.m_92883_(matrix, name, (float)(this.left - 2 + this.width / 2 - EditModuleScreen.this.f_96547_.m_92895_(name) / 2), (float)(relativeY + 12 * i), 0xC6C6C6);
                }
            }
        }

        private void renderBox(BufferBuilder bufferBuilder, int min, int max, int slotTop, int slotBuffer, int borderColor) {
            RenderSystem.m_69478_();
            RenderSystem.m_69472_();
            RenderSystem.m_69453_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(0.0f, 1.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(1.0f, 1.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
            bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_7421_(1.0f, 0.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
            bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_7421_(0.0f, 0.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }
    }
}

