/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InventoryScannerScreen
extends AbstractContainerScreen<InventoryScannerMenu> {
    private static final ResourceLocation REGULAR_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    private InventoryScannerBlockEntity tileEntity;
    private boolean owns = false;
    private boolean hasRedstoneModule = false;
    private boolean hasStorageModule = false;
    private Component infoStringRedstone;
    private Component infoStringStorage;
    private static final Style UNDERLINE = Style.f_131099_.m_131157_(ChatFormatting.UNDERLINE);
    private final Component redstoneModuleNotInstalled = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)SCContent.REDSTONE_MODULE.get()).m_5524_(), new Object[0]));
    private final Component storageModuleNotInstalled = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)SCContent.STORAGE_MODULE.get()).m_5524_(), new Object[0]));

    public InventoryScannerScreen(InventoryScannerMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tileEntity = container.te;
        this.owns = this.tileEntity.getOwner().isOwner(inv.f_35978_);
        this.hasRedstoneModule = this.tileEntity.hasModule(ModuleType.REDSTONE);
        this.hasStorageModule = this.tileEntity.hasModule(ModuleType.STORAGE);
        this.infoStringRedstone = Utils.localize("gui.securitycraft:invScan.emit_redstone", Utils.localize("gui.securitycraft:invScan." + (this.hasRedstoneModule ? "yes" : "no"), new Object[0]));
        this.infoStringStorage = Utils.localize("gui.securitycraft:invScan.check_inv", Utils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0]));
        this.f_97726_ = this.hasStorageModule ? 246 : 190;
        this.f_97727_ = 196;
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92857_((FormattedText)this.infoStringRedstone, this.f_97735_ + 28, this.f_97736_ + 45, 150, 0x404040);
        this.f_96547_.m_92857_((FormattedText)this.infoStringStorage, this.f_97735_ + 28, this.f_97736_ + 75, 150, 0x404040);
        ClientUtils.renderModuleInfo(matrix, ModuleType.REDSTONE, null, this.redstoneModuleNotInstalled, this.hasRedstoneModule, this.f_97735_ + 8, this.f_97736_ + 45, this.f_96543_, this.f_96544_, mouseX, mouseY);
        ClientUtils.renderModuleInfo(matrix, ModuleType.STORAGE, null, this.storageModuleNotInstalled, this.hasStorageModule, this.f_97735_ + 8, this.f_97736_ + 75, this.f_96543_, this.f_96544_, mouseX, mouseY);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().m_7993_().m_41619_()) {
            this.m_6057_(matrix, this.getSlotUnderMouse().m_7993_(), mouseX, mouseY);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrix, (Component)Utils.localize("gui.securitycraft:invScan.prohibitedItems", new Object[0]), 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrix, (Component)Utils.localize("gui.securitycraft:invScan.mode." + (this.tileEntity.getOwner().isOwner((Player)this.f_96541_.f_91074_) ? "admin" : "view"), new Object[0]).m_6270_(UNDERLINE), 112.0f, 6.0f, 0x404040);
        if (this.hasStorageModule && this.owns) {
            this.f_96547_.m_92889_(matrix, (Component)Utils.localize("gui.securitycraft:invScan.storage", new Object[0]), 188.0f, 18.0f, 0x404040);
        }
        this.f_96547_.m_92889_(matrix, (Component)Utils.localize("container.inventory", new Object[0]), 15.0f, (float)(this.f_97727_ - 93), 0x404040);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)(this.hasStorageModule && this.owns ? ENHANCED_INVENTORY : REGULAR_INVENTORY));
        this.m_93228_(matrix, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_ + 30);
    }
}

