/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.screen.components.FixedExtendedButton;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class KeycardReaderScreen
extends AbstractContainerScreen<KeycardReaderMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/keycard_reader.png");
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation RESET_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset.png");
    private static final ResourceLocation RESET_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset_inactive.png");
    private static final ResourceLocation RETURN_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return.png");
    private static final ResourceLocation RETURN_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return_inactive.png");
    private static final ResourceLocation WORLD_SELECTION_ICONS = new ResourceLocation("textures/gui/world_selection.png");
    private static final Component EQUALS = new TextComponent("=");
    private static final Component GREATER_THAN_EQUALS = new TextComponent(">=");
    private final Component blockName = Utils.localize(((Block)SCContent.KEYCARD_READER.get()).m_7705_(), new Object[0]);
    private final Component inventoryText = Utils.localize("container.inventory", new Object[0]);
    private final Component keycardLevelsText = Utils.localize("gui.securitycraft:keycard_reader.keycard_levels", new Object[0]);
    private final Component linkText = Utils.localize("gui.securitycraft:keycard_reader.link", new Object[0]);
    private final Component noSmartModule = Utils.localize("gui.securitycraft:keycard_reader.noSmartModule", new Object[0]);
    private final Component smartModule = Utils.localize("gui.securitycraft:keycard_reader.smartModule", new Object[0]);
    private final Component levelMismatchInfo = Utils.localize("gui.securitycraft:keycard_reader.level_mismatch", new Object[0]);
    private final Component limitedInfo = Utils.localize("tooltip.securitycraft:keycard.limited_info", new Object[0]);
    private final KeycardReaderBlockEntity te;
    private final boolean isSmart;
    private final boolean isOwner;
    private boolean isExactLevel = true;
    private int previousSignature;
    private int signature;
    private boolean[] acceptedLevels;
    private TranslatableComponent signatureText;
    private int signatureTextLength;
    private int signatureTextStartX;
    private Button minusThree;
    private Button minusTwo;
    private Button minusOne;
    private Button reset;
    private Button plusOne;
    private Button plusTwo;
    private Button plusThree;
    private TogglePictureButton[] toggleButtons = new TogglePictureButton[5];
    private EditBox usesTextField;
    private TextHoverChecker usesHoverChecker;
    private Button setUsesButton;
    private Button linkButton;
    private boolean firstTick = true;

    public KeycardReaderScreen(KeycardReaderMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.te = container.te;
        this.signature = this.previousSignature = this.te.getSignature();
        this.acceptedLevels = this.te.getAcceptedLevels();
        this.isSmart = this.te.hasModule(ModuleType.SMART);
        this.isOwner = this.te.getOwner().isOwner(inv.f_35978_);
        this.f_97727_ = 249;
    }

    public void m_7856_() {
        super.m_7856_();
        int buttonHeight = 13;
        int buttonY = this.f_97736_ + 35;
        int activeButtons = 0;
        int firstActiveButton = -1;
        for (int i = 0; i < 5; ++i) {
            this.toggleButtons[i] = (TogglePictureButton)this.m_142416_((GuiEventListener)new TogglePictureButton(i, this.f_97735_ + 100, this.f_97736_ + 50 + (i + 1) * 17, 15, 15, BEACON_GUI, new int[]{110, 88}, new int[]{219, 219}, -1, 17, 17, 21, 22, 256, 256, 2, thisButton -> {
                if (!this.isSmart) {
                    for (int otherButtonId = 0; otherButtonId < 5; ++otherButtonId) {
                        boolean active = this.isExactLevel ? otherButtonId == thisButton.id : otherButtonId >= thisButton.id;
                        this.changeLevelState(otherButtonId, active);
                    }
                } else {
                    this.acceptedLevels[thisButton.id] = !this.acceptedLevels[thisButton.id];
                }
            }));
            this.toggleButtons[i].setCurrentIndex(this.acceptedLevels[i] ? 1 : 0);
            this.toggleButtons[i].f_93623_ = this.isOwner;
            if (this.isSmart || !this.acceptedLevels[i]) continue;
            if (firstActiveButton == -1) {
                firstActiveButton = i;
            }
            ++activeButtons;
        }
        this.minusThree = (Button)this.m_142416_((GuiEventListener)new FixedExtendedButton(this.f_97735_ + 22, buttonY, 24, buttonHeight, (Component)new TextComponent("---"), b -> this.changeSignature(this.signature - 100)));
        this.minusTwo = (Button)this.m_142416_((GuiEventListener)new FixedExtendedButton(this.f_97735_ + 48, buttonY, 18, buttonHeight, (Component)new TextComponent("--"), b -> this.changeSignature(this.signature - 10)));
        this.minusOne = (Button)this.m_142416_((GuiEventListener)new FixedExtendedButton(this.f_97735_ + 68, buttonY, 12, buttonHeight, (Component)new TextComponent("-"), b -> this.changeSignature(this.signature - 1)));
        this.reset = (Button)this.m_142416_((GuiEventListener)new PictureButton(-1, this.f_97735_ + 82, buttonY, 12, buttonHeight, RESET_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSignature(this.previousSignature)){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.f_93623_ ? RESET_TEXTURE : RESET_INACTIVE_TEXTURE;
            }
        });
        this.plusOne = (Button)this.m_142416_((GuiEventListener)new FixedExtendedButton(this.f_97735_ + 96, buttonY, 12, buttonHeight, (Component)new TextComponent("+"), b -> this.changeSignature(this.signature + 1)));
        this.plusTwo = (Button)this.m_142416_((GuiEventListener)new FixedExtendedButton(this.f_97735_ + 110, buttonY, 18, buttonHeight, (Component)new TextComponent("++"), b -> this.changeSignature(this.signature + 10)));
        this.plusThree = (Button)this.m_142416_((GuiEventListener)new FixedExtendedButton(this.f_97735_ + 130, buttonY, 24, buttonHeight, (Component)new TextComponent("+++"), b -> this.changeSignature(this.signature + 100)));
        this.changeSignature(this.signature);
        this.linkButton = (Button)this.m_142416_((GuiEventListener)new FixedExtendedButton(this.f_97735_ + 8, this.f_97736_ + 126, 70, 20, this.linkText, b -> {
            this.previousSignature = this.signature;
            this.changeSignature(this.signature);
            SecurityCraft.channel.sendToServer((Object)new SyncKeycardSettings(this.te.m_58899_(), this.acceptedLevels, this.signature, true));
            if (((KeycardReaderMenu)this.f_97732_).keycardSlot.m_7993_().m_41786_().getString().equalsIgnoreCase("Zelda")) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SCSounds.GET_ITEM.event, (float)1.0f, (float)1.25f));
            }
        }));
        this.linkButton.f_93623_ = false;
        this.setUsesButton = (Button)this.m_142416_((GuiEventListener)new PictureButton(-1, this.f_97735_ + 62, this.f_97736_ + 106, 16, 17, RETURN_TEXTURE, 14, 14, 2, 2, 14, 14, 14, 14, b -> SecurityCraft.channel.sendToServer((Object)new SetKeycardUses(this.te.m_58899_(), Integer.parseInt(this.usesTextField.m_94155_())))){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.f_93623_ ? RETURN_TEXTURE : RETURN_INACTIVE_TEXTURE;
            }
        });
        this.setUsesButton.f_93623_ = false;
        this.usesTextField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 28, this.f_97736_ + 107, 30, 15, TextComponent.f_131282_));
        this.usesTextField.m_94153_(s -> s.matches("[0-9]*"));
        this.usesTextField.m_94199_(3);
        this.usesHoverChecker = new TextHoverChecker(this.f_97736_ + 107, this.f_97736_ + 122, this.f_97735_ + 28, this.f_97735_ + 58, this.limitedInfo);
        if (!this.isSmart) {
            if (activeButtons == 1) {
                this.isExactLevel = true;
            } else if (activeButtons == 0) {
                this.isExactLevel = true;
                this.changeLevelState(0, true);
            } else {
                boolean active = false;
                this.isExactLevel = false;
                for (int i = 0; i < 5; ++i) {
                    if (i == firstActiveButton) {
                        active = true;
                    }
                    this.changeLevelState(i, active);
                }
            }
            ((FixedExtendedButton)this.m_142416_((GuiEventListener)new FixedExtendedButton((int)(this.f_97735_ + 135), (int)(this.f_97736_ + 67), (int)18, (int)18, (Component)(this.isExactLevel ? KeycardReaderScreen.EQUALS : KeycardReaderScreen.GREATER_THAN_EQUALS), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$11(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((KeycardReaderScreen)this)))).f_93623_ = this.isOwner;
        }
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrix, this.blockName, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.blockName) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrix, (Component)this.signatureText, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.signatureText) / 2), 23.0f, 0x404040);
        this.f_96547_.m_92889_(matrix, this.keycardLevelsText, (float)(170 - this.f_96547_.m_92852_((FormattedText)this.keycardLevelsText)), 56.0f, 0x404040);
        for (int i = 1; i <= 5; ++i) {
            this.f_96547_.m_92883_(matrix, "" + i, 91.0f, (float)(55 + 17 * i), 0x404040);
        }
        this.f_96547_.m_92889_(matrix, this.inventoryText, 8.0f, (float)(this.f_97727_ - 93), 0x404040);
    }

    public void m_181908_() {
        super.m_181908_();
        ItemStack stack = ((KeycardReaderMenu)this.f_97732_).keycardSlot.m_7993_();
        boolean isEmpty = stack.m_41619_();
        boolean wasActive = this.usesTextField.f_93623_;
        boolean hasTag = stack.m_41782_();
        boolean enabled = !isEmpty && hasTag && stack.m_41783_().m_128471_("limited");
        int cardSignature = stack.m_41782_() ? stack.m_41783_().m_128451_("signature") : -1;
        this.usesTextField.m_94186_(enabled);
        this.usesTextField.f_93623_ = enabled;
        if (!wasActive && enabled) {
            this.usesTextField.m_94144_("" + stack.m_41783_().m_128451_("uses"));
        } else if (wasActive && !enabled) {
            this.usesTextField.m_94144_("");
        }
        if (this.firstTick) {
            this.setUsesButton.f_93623_ = false;
            this.linkButton.f_93623_ = false;
            this.firstTick = false;
        } else {
            this.setUsesButton.f_93623_ = enabled && this.usesTextField.m_94155_() != null && !this.usesTextField.m_94155_().isEmpty() && !("" + stack.m_41783_().m_128451_("uses")).equals(this.usesTextField.m_94155_());
            this.linkButton.f_93623_ = !isEmpty && cardSignature != this.signature;
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        ItemStack stack = ((KeycardReaderMenu)this.f_97732_).keycardSlot.m_7993_();
        if (!stack.m_41619_() && !this.acceptedLevels[((KeycardItem)stack.m_41720_()).getLevel()]) {
            int left = this.f_97735_ + 40;
            int top = this.f_97736_ + 60;
            RenderSystem.m_157179_((int)0, (ResourceLocation)WORLD_SELECTION_ICONS);
            KeycardReaderScreen.m_93160_((PoseStack)matrix, (int)left, (int)top, (int)22, (int)22, (float)70.0f, (float)37.0f, (int)22, (int)22, (int)256, (int)256);
            if (mouseX >= left - 7 && mouseX < left + 13 && mouseY >= top && mouseY <= top + 22) {
                GuiUtils.drawHoveringText((PoseStack)matrix, Arrays.asList(this.levelMismatchInfo), (int)mouseX, (int)mouseY, (int)this.f_96543_, (int)this.f_96544_, (int)-1, (Font)this.f_96547_);
            }
        }
        if (!this.usesTextField.f_93623_ && !stack.m_41619_() && this.usesHoverChecker.checkHover(mouseX, mouseY)) {
            GuiUtils.drawHoveringText((PoseStack)matrix, this.usesHoverChecker.getLines(), (int)mouseX, (int)mouseY, (int)this.f_96543_, (int)this.f_96544_, (int)-1, (Font)this.f_96547_);
        }
        this.m_7025_(matrix, mouseX, mouseY);
        ClientUtils.renderModuleInfo(matrix, ModuleType.SMART, this.smartModule, this.noSmartModule, this.isSmart, this.f_97735_ + 5, this.f_97736_ + 5, this.f_96543_, this.f_96544_, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrix, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isOwner && mouseX >= (double)(this.f_97735_ + this.signatureTextStartX) && mouseY >= (double)(this.f_97736_ + 23) && mouseX <= (double)(this.f_97735_ + this.signatureTextStartX + this.signatureTextLength) && mouseY <= (double)(this.f_97736_ + 43)) {
            this.changeSignature(this.signature + (int)Math.signum(delta));
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.isOwner) {
            this.te.setAcceptedLevels(this.acceptedLevels);
            this.te.setSignature(this.signature);
            SecurityCraft.channel.sendToServer((Object)new SyncKeycardSettings(this.te.m_58899_(), this.acceptedLevels, this.signature, false));
        }
    }

    public void changeSignature(int newSignature) {
        boolean enableMinusButtons;
        if (this.isOwner) {
            this.signature = Math.max(0, Math.min(newSignature, Short.MAX_VALUE));
        }
        this.signatureText = new TranslatableComponent("gui.securitycraft:keycard_reader.signature", new Object[]{StringUtils.leftPad((String)("" + this.signature), (int)5, (String)"0")});
        this.signatureTextLength = this.f_96547_.m_92852_((FormattedText)this.signatureText);
        this.signatureTextStartX = this.f_97726_ / 2 - this.signatureTextLength / 2;
        boolean enablePlusButtons = this.isOwner && this.signature != Short.MAX_VALUE;
        this.minusThree.f_93623_ = enableMinusButtons = this.isOwner && this.signature != 0;
        this.minusTwo.f_93623_ = enableMinusButtons;
        this.minusOne.f_93623_ = enableMinusButtons;
        this.reset.f_93623_ = this.isOwner && this.signature != this.previousSignature;
        this.plusOne.f_93623_ = enablePlusButtons;
        this.plusTwo.f_93623_ = enablePlusButtons;
        this.plusThree.f_93623_ = enablePlusButtons;
    }

    public void changeLevelState(int i, boolean active) {
        if (this.isOwner) {
            this.toggleButtons[i].setCurrentIndex(active ? 1 : 0);
            this.acceptedLevels[i] = active;
        }
    }

    private /* synthetic */ void lambda$init$11(Button b) {
        boolean change = false;
        this.isExactLevel = !this.isExactLevel;
        for (int i = 0; i < 5; ++i) {
            if (change) {
                this.changeLevelState(i, !this.isExactLevel);
                continue;
            }
            change = this.acceptedLevels[i];
        }
        b.m_93666_(this.isExactLevel ? EQUALS : GREATER_THAN_EQUALS);
    }
}

