/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MineRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/mrat.png");
    private static final ResourceLocation INFO_BOOK_ICONS = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private final TranslatableComponent mratName = Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).m_5524_(), new Object[0]);
    private ItemStack mrat;
    private IdButton[][] guiButtons = new IdButton[6][4];
    private static final int DEFUSE = 0;
    private static final int ACTIVATE = 1;
    private static final int DETONATE = 2;
    private static final int UNBIND = 3;
    private int xSize = 256;
    private int ySize = 184;
    private List<TextHoverChecker> hoverCheckers = new ArrayList<TextHoverChecker>();

    public MineRemoteAccessToolScreen(ItemStack item) {
        super((Component)new TranslatableComponent(item.m_41778_()));
        this.mrat = item;
    }

    public void m_7856_() {
        int padding;
        super.m_7856_();
        int y = padding = 25;
        int[] coords = null;
        int id = 0;
        this.hoverCheckers.clear();
        for (int i = 0; i < 6; ++i) {
            y += 30;
            coords = this.getMineCoordinates(i);
            int startX = (this.f_96543_ - this.xSize) / 2;
            int startY = (this.f_96544_ - this.ySize) / 2;
            for (int j = 0; j < 4; ++j) {
                int btnX = startX + j * padding + 154;
                int btnY = startY + y - 48;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, this.f_96542_, new ItemStack((ItemLike)SCContent.WIRE_CUTTERS.get()), this::actionPerformed);
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, this.f_96542_, new ItemStack((ItemLike)Items.f_42409_), this::actionPerformed);
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, INFO_BOOK_ICONS, 54, 1, 0, 1, 18, 18, 256, 256, this::actionPerformed);
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    case 3: {
                        this.guiButtons[i][j] = new IdButton(id++, btnX, btnY, 20, 20, "X", this::actionPerformed);
                        this.guiButtons[i][j].f_93623_ = false;
                    }
                }
                this.m_142416_((GuiEventListener)this.guiButtons[i][j]);
            }
            BlockPos minePos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            this.guiButtons[i][3].f_93623_ = true;
            if (Minecraft.m_91087_().f_91074_.f_19853_.m_46749_(minePos)) {
                Block block = this.f_96541_.f_91073_.m_8055_(minePos).m_60734_();
                Block block2 = block;
                if (block2 instanceof IExplosive) {
                    IExplosive explosive = (IExplosive)block2;
                    boolean active = explosive.isActive((Level)this.f_96541_.f_91073_, minePos);
                    boolean defusable = explosive.isDefusable();
                    this.guiButtons[i][0].f_93623_ = active && defusable;
                    this.guiButtons[i][1].f_93623_ = !active && defusable;
                    this.guiButtons[i][2].f_93623_ = active;
                    this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][0], (Component)Utils.localize("gui.securitycraft:mrat.defuse", new Object[0])));
                    this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][1], (Component)Utils.localize("gui.securitycraft:mrat.activate", new Object[0])));
                    this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][2], (Component)Utils.localize("gui.securitycraft:mrat.detonate", new Object[0])));
                    this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][3], (Component)Utils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
                    continue;
                }
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int j = 0; j < 4; ++j) {
                    this.guiButtons[i][j].f_93623_ = false;
                }
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][j], (Component)Utils.localize("gui.securitycraft:mrat.outOfRange", new Object[0])));
            }
            this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][3], (Component)Utils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_93228_(matrix, startX, startY, 0, 0, this.xSize, this.ySize);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(matrix, (Component)this.mratName, (float)(startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.mratName)), (float)(startY + -25 + 13), 0xFF0000);
        for (int i = 0; i < 6; ++i) {
            int[] coords = this.getMineCoordinates(i);
            TranslatableComponent line = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? Utils.localize("gui.securitycraft:mrat.notBound", new Object[0]) : Utils.localize("gui.securitycraft:mrat.mineLocations", new BlockPos(coords[0], coords[1], coords[2]));
            this.f_96547_.m_92889_(matrix, (Component)line, (float)(startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)line) + 25), (float)(startY + i * 30 + 13), 0x404040);
        }
        for (TextHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY) || chc.getName() == null) continue;
            this.m_96597_(matrix, chc.getLines(), mouseX, mouseY);
        }
    }

    protected void actionPerformed(IdButton button) {
        int mine = button.id / 4;
        int action = button.id % 4;
        int[] coords = this.getMineCoordinates(mine);
        switch (action) {
            case 0: {
                ((IExplosive)Minecraft.m_91087_().f_91074_.f_19853_.m_8055_(new BlockPos(coords[0], coords[1], coords[2])).m_60734_()).defuseMine(Minecraft.m_91087_().f_91074_.f_19853_, new BlockPos(coords[0], coords[1], coords[2]));
                SecurityCraft.channel.sendToServer((Object)new RemoteControlMine(coords[0], coords[1], coords[2], "defuse"));
                this.guiButtons[mine][0].f_93623_ = false;
                this.guiButtons[mine][1].f_93623_ = true;
                this.guiButtons[mine][2].f_93623_ = false;
                break;
            }
            case 1: {
                ((IExplosive)Minecraft.m_91087_().f_91074_.f_19853_.m_8055_(new BlockPos(coords[0], coords[1], coords[2])).m_60734_()).activateMine(Minecraft.m_91087_().f_91074_.f_19853_, new BlockPos(coords[0], coords[1], coords[2]));
                SecurityCraft.channel.sendToServer((Object)new RemoteControlMine(coords[0], coords[1], coords[2], "activate"));
                this.guiButtons[mine][0].f_93623_ = true;
                this.guiButtons[mine][1].f_93623_ = false;
                this.guiButtons[mine][2].f_93623_ = true;
                break;
            }
            case 2: {
                SecurityCraft.channel.sendToServer((Object)new RemoteControlMine(coords[0], coords[1], coords[2], "detonate"));
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int i = 0; i < 4; ++i) {
                    this.guiButtons[mine][i].f_93623_ = false;
                }
                break;
            }
            case 3: {
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int i = 0; i < 4; ++i) {
                    this.guiButtons[mine][i].f_93623_ = false;
                }
                break;
            }
        }
    }

    private int[] getMineCoordinates(int mine) {
        if (this.mrat.m_41720_() != null && this.mrat.m_41720_() == SCContent.REMOTE_ACCESS_MINE.get() && this.mrat.m_41783_() != null && this.mrat.m_41783_().m_128465_("mine" + ++mine) != null && this.mrat.m_41783_().m_128465_("mine" + mine).length > 0) {
            return this.mrat.m_41783_().m_128465_("mine" + mine);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.m_41783_().m_128465_("mine" + i).length <= 0 || (coords = stack.m_41783_().m_128465_("mine" + i))[0] != x || coords[1] != y || coords[2] != z || coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            stack.m_41783_().m_128385_("mine" + i, new int[]{0, 0, 0});
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(stack));
            return;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.m_7861_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

