/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.gui.ScrollPanel;

public class TrophySystemScreen
extends AbstractContainerScreen<GenericTEMenu> {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/blank.png");
    private final TranslatableComponent projectiles = Utils.localize("gui.securitycraft:trophy_system.targetableProjectiles", new Object[0]);
    private final TranslatableComponent moduleRequired = Utils.localize("gui.securitycraft:trophy_system.moduleRequired", new Object[0]);
    private final TranslatableComponent toggle = Utils.localize("gui.securitycraft:trophy_system.toggle", new Object[0]);
    private final TranslatableComponent moddedProjectiles = Utils.localize("gui.securitycraft:trophy_system.moddedProjectiles", new Object[0]);
    private final boolean isSmart;
    private final List<EntityType<?>> orderedFilterList;
    private TrophySystemBlockEntity tileEntity;
    private ProjectileScrollList projectileList;

    public TrophySystemScreen(GenericTEMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tileEntity = (TrophySystemBlockEntity)container.te;
        this.isSmart = this.tileEntity.hasModule(ModuleType.SMART);
        this.orderedFilterList = new ArrayList(this.tileEntity.getFilters().keySet());
        this.orderedFilterList.sort((e1, e2) -> {
            if (e1 == EntityType.f_20510_) {
                return 1;
            }
            if (e2 == EntityType.f_20510_) {
                return -1;
            }
            return e1.m_20676_().getString().compareTo(e2.m_20676_().getString());
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        this.projectileList = new ProjectileScrollList(this.f_96541_, this.f_97726_ - 24, this.f_97727_ - 60, this.f_97736_ + 40, this.f_97735_ + 12);
        this.m_169394_((Widget)this.projectileList);
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrix, this.f_96539_, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(matrix, (Component)this.projectiles, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.projectiles) / 2), (float)(this.f_97729_ + 25), 0x404040);
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        ClientUtils.renderModuleInfo(matrix, ModuleType.SMART, (Component)this.toggle, (Component)this.moduleRequired, this.isSmart, this.f_97735_ + 5, this.f_97736_ + 5, this.f_96543_, this.f_96544_, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_7333_(matrix);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)GUI_TEXTURE);
        this.m_93228_(matrix, startX, startY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.projectileList != null) {
            this.projectileList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    class ProjectileScrollList
    extends ScrollPanel {
        private final int slotHeight = 12;
        private final int listLength;

        public ProjectileScrollList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.listLength = TrophySystemScreen.this.orderedFilterList.size();
        }

        protected int getContentHeight() {
            Objects.requireNonNull(TrophySystemScreen.this.f_96547_);
            int height = 50 + this.listLength * 9;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex = (int)(mouseY + 2.0) / 12;
            if (TrophySystemScreen.this.isSmart && slotIndex >= 0 && mouseY >= 0.0 && slotIndex < this.listLength) {
                TrophySystemScreen.this.tileEntity.toggleFilter(TrophySystemScreen.this.orderedFilterList.get(slotIndex));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            return false;
        }

        protected void drawPanel(PoseStack matrix, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            int baseY = this.top + 4 - (int)this.scrollDistance;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
            int slotIndex = mouseListY / 12;
            if (TrophySystemScreen.this.isSmart && mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                int min = this.left;
                int max = entryRight - 6;
                int slotTop = baseY + slotIndex * 12;
                BufferBuilder bufferBuilder = tess.m_85915_();
                RenderSystem.m_69478_();
                RenderSystem.m_69472_();
                RenderSystem.m_69453_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_85721_();
                BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
                RenderSystem.m_69493_();
                RenderSystem.m_69461_();
            }
            int i = 0;
            for (EntityType<?> projectileType : TrophySystemScreen.this.orderedFilterList) {
                Component projectileName = projectileType == EntityType.f_20510_ ? TrophySystemScreen.this.moddedProjectiles : projectileType.m_20676_();
                int yStart = relativeY + 12 * i;
                TrophySystemScreen.this.f_96547_.m_92889_(matrix, projectileName, (float)(this.left + this.width / 2 - TrophySystemScreen.this.f_96547_.m_92852_((FormattedText)projectileName) / 2), (float)yStart, 0xC6C6C6);
                RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
                ProjectileScrollList.m_93160_((PoseStack)matrix, (int)this.left, (int)(yStart - 3), (int)14, (int)14, (float)(TrophySystemScreen.this.tileEntity.getFilter(projectileType) ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)256, (int)256);
                ++i;
            }
        }
    }
}

