/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;

public abstract class ColorableScrollPanel
extends ScrollPanel {
    protected final int barWidth = 6;
    public final int barLeft;
    private Color backgroundTo;
    private Color backgroundFrom;
    private Color scrollbarBackground;
    private Color scrollbarBorder;
    private Color scrollbar;

    public ColorableScrollPanel(Minecraft client, int width, int height, int top, int left) {
        this(client, width, height, top, left, new Color(192, 16, 16, 16), new Color(208, 16, 16, 16), new Color(0, 0, 0, 255), new Color(128, 128, 128, 255), new Color(192, 192, 192, 255));
    }

    public ColorableScrollPanel(Minecraft client, int width, int height, int top, int left, Color backgroundFrom, Color backgroundTo, Color scrollbarBackground, Color scrollbarBorder, Color scrollbar) {
        super(client, width, height, top, left);
        this.barLeft = left + width - 6;
        this.backgroundFrom = backgroundFrom;
        this.backgroundTo = backgroundTo;
        this.scrollbarBackground = scrollbarBackground;
        this.scrollbarBorder = scrollbarBorder;
        this.scrollbar = scrollbar;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        Minecraft client = Minecraft.m_91087_();
        double scale = client.m_91268_().m_85449_();
        int baseY = this.top + 4 - (int)this.scrollDistance;
        int extraHeight = this.getContentHeight() + 4 - this.height;
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)client.m_91268_().m_85442_() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        this.drawGradientRect(matrix, this.left, this.top, this.right, this.bottom, this.backgroundFrom.combinedRGBA(), this.backgroundTo.combinedRGBA());
        this.drawPanel(matrix, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.m_69465_();
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_5483_((double)this.barLeft, (double)this.bottom, 0.0).m_6122_(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).m_5752_();
            buffer.m_5483_((double)(this.barLeft + 6), (double)this.bottom, 0.0).m_6122_(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).m_5752_();
            buffer.m_5483_((double)(this.barLeft + 6), (double)this.top, 0.0).m_6122_(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).m_5752_();
            buffer.m_5483_((double)this.barLeft, (double)this.top, 0.0).m_6122_(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).m_5752_();
            tess.m_85914_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_5483_((double)this.barLeft, (double)(barTop + barHeight), 0.0).m_6122_(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).m_5752_();
            buffer.m_5483_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).m_6122_(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).m_5752_();
            buffer.m_5483_((double)(this.barLeft + 6), (double)barTop, 0.0).m_6122_(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).m_5752_();
            buffer.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_6122_(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).m_5752_();
            tess.m_85914_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_5483_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).m_6122_(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).m_5752_();
            buffer.m_5483_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).m_6122_(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).m_5752_();
            buffer.m_5483_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).m_6122_(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).m_5752_();
            buffer.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_6122_(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).m_5752_();
            tess.m_85914_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        GL11.glDisable((int)3089);
    }

    public int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }

    public record Color(int r, int g, int b, int a) {
        public int combinedRGBA() {
            return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
        }
    }
}

