/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class BlockUtils {
    private static final LazyOptional<IItemHandler> EMPTY_INVENTORY = LazyOptional.of(() -> new EmptyHandler());

    public static boolean isSideSolid(LevelReader world, BlockPos pos, Direction side) {
        return world.m_8055_(pos).m_60783_((BlockGetter)world, pos, side);
    }

    public static void updateAndNotify(Level world, BlockPos pos, Block block, int delay, boolean shouldUpdate) {
        if (shouldUpdate) {
            world.m_6219_().m_5945_(pos, (Object)block, delay);
        }
        world.m_46672_(pos, block);
    }

    public static int[] posToIntArray(BlockPos pos) {
        return new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
    }

    public static Explosion.BlockInteraction getExplosionMode() {
        return (Boolean)ConfigHandler.SERVER.mineExplosionsBreakBlocks.get() != false ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
    }

    public static boolean hasActiveSCBlockNextTo(Level world, BlockPos pos) {
        return SecurityCraftAPI.getRegisteredDoorActivators().stream().anyMatch(activator -> BlockUtils.hasActiveSCBlockNextTo(world, pos, world.m_7702_(pos), activator));
    }

    private static boolean hasActiveSCBlockNextTo(Level world, BlockPos pos, BlockEntity te, IDoorActivator activator) {
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.m_142300_(dir);
            BlockState offsetState = world.m_8055_(offsetPos);
            if (activator.getBlocks().contains(offsetState.m_60734_())) {
                BlockEntity offsetTe = world.m_7702_(offsetPos);
                return activator.isPowering(world, offsetPos, offsetState, offsetTe) && (!(offsetTe instanceof IOwnable) || ((IOwnable)offsetTe).getOwner().owns((IOwnable)te));
            }
            if (world.m_46681_(offsetPos, dir) != 15 || offsetState.m_60803_()) continue;
            for (Direction dirOffset : Direction.values()) {
                IOwnable ownable;
                BlockEntity blockEntity;
                BlockEntity offsetTe;
                if (dirOffset.m_122424_() == dir) continue;
                BlockPos newOffsetPos = offsetPos.m_142300_(dirOffset);
                offsetState = world.m_8055_(newOffsetPos);
                if (!activator.getBlocks().contains(offsetState.m_60734_())) continue;
                if (offsetState.m_61138_((Property)BlockStateProperties.f_61376_) && offsetState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    Direction.Axis offsetAxis = dirOffset.m_122434_();
                    Direction offsetFacing = (Direction)offsetState.m_61143_((Property)BlockStateProperties.f_61374_);
                    AttachFace offsetAttachFace = (AttachFace)offsetState.m_61143_((Property)BlockStateProperties.f_61376_);
                    switch (offsetAxis) {
                        case X: 
                        case Z: {
                            if (offsetAttachFace == AttachFace.WALL && dirOffset == offsetFacing) break;
                            return false;
                        }
                        case Y: {
                            if ((dirOffset != Direction.UP || offsetAttachFace == AttachFace.FLOOR) && (dirOffset != Direction.DOWN || offsetAttachFace == AttachFace.CEILING)) break;
                            return false;
                        }
                    }
                }
                return activator.isPowering(world, newOffsetPos, offsetState, offsetTe = world.m_7702_(newOffsetPos)) && (!((blockEntity = offsetTe) instanceof IOwnable) || (ownable = (IOwnable)blockEntity).getOwner().owns((IOwnable)te));
            }
        }
        return false;
    }

    public static LazyOptional<?> getProtectedCapability(Direction side, BlockEntity te, Supplier<LazyOptional<?>> extractionPermittedHandler, Supplier<LazyOptional<?>> insertOnlyHandler) {
        if (side == null) {
            return EMPTY_INVENTORY;
        }
        BlockPos offsetPos = te.m_58899_().m_142300_(side);
        BlockState offsetState = te.m_58904_().m_8055_(offsetPos);
        for (IExtractionBlock extractionBlock : SecurityCraftAPI.getRegisteredExtractionBlocks()) {
            if (offsetState.m_60734_() != extractionBlock.getBlock()) continue;
            if (!extractionBlock.canExtract((IOwnable)te, te.m_58904_(), offsetPos, offsetState)) {
                return EMPTY_INVENTORY;
            }
            return extractionPermittedHandler.get();
        }
        return insertOnlyHandler.get();
    }
}

