/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class ModuleUtils {
    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.m_41720_() instanceof ModuleItem) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.m_41783_() == null || stack.m_41783_().m_128461_("Player" + i) == null || stack.m_41783_().m_128461_("Player" + i).isEmpty()) continue;
                list.add(stack.m_41783_().m_128461_("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean isAllowed(IModuleInventory inv, Entity entity) {
        return ModuleUtils.isAllowed(inv, entity.m_7755_().getString());
    }

    public static boolean isAllowed(IModuleInventory inv, String name) {
        return ModuleUtils.getPlayersFromModule(inv.getModule(ModuleType.ALLOWLIST)).contains(name.toLowerCase());
    }

    public static boolean isDenied(IModuleInventory inv, Entity entity) {
        return ModuleUtils.getPlayersFromModule(inv.getModule(ModuleType.DENYLIST)).contains(entity.m_7755_().getString().toLowerCase());
    }

    public static void createLinkedAction(LinkedAction action, ItemStack stack, CustomizableBlockEntity te) {
        if (action == LinkedAction.MODULE_INSERTED) {
            te.createLinkedBlockAction(action, new Object[]{stack, (ModuleItem)stack.m_41720_()}, te);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            te.createLinkedBlockAction(action, new Object[]{stack, ((ModuleItem)stack.m_41720_()).getModuleType()}, te);
        }
        if (te instanceof SecurityCameraBlockEntity) {
            te.m_58904_().m_46672_(te.m_58899_().m_5484_((Direction)te.m_58900_().m_61143_((Property)SecurityCameraBlock.FACING), -1), te.m_58900_().m_60734_());
        }
    }
}

