/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.additionalbanners.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.registry.BannerRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class WanderingTraderConfig {
    private final ForgeConfigSpec spec;
    public final ForgeConfigSpec.BooleanValue enableWanderingVillagerTrades;
    public final Map<BannerPattern, VillagerTradeData> wanderingTrades = new HashMap<BannerPattern, VillagerTradeData>();

    public WanderingTraderConfig(BannerRegistry registry) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Should pattern stencils be added to the wandering trader pool?");
        this.enableWanderingVillagerTrades = builder.define("enable_stencil_trades", true);
        for (BannerPattern pattern : registry.getPatterns()) {
            if (registry.getStencilItem(pattern) == null) continue;
            this.wanderingTrades.put(pattern, new VillagerTradeData(pattern, registry.getStencilItem(pattern), builder));
        }
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public void forceLoad() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("additionalbanners");
        File dir = path.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        path = path.resolve("wandering_trader.toml");
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        this.spec.setConfig((CommentedConfig)configData);
    }

    public static class VillagerTradeData {
        private final Item stencilItem;
        public final ForgeConfigSpec.BooleanValue addBasicTrade;
        public final ForgeConfigSpec.IntValue emeralds;
        public final ForgeConfigSpec.IntValue maxTrades;
        public final ForgeConfigSpec.IntValue xp;
        public final ForgeConfigSpec.DoubleValue priceMultiplier;

        public VillagerTradeData(BannerPattern pattern, Item stencil, ForgeConfigSpec.Builder builder) {
            String name = pattern.name().toLowerCase().replace("additionalbanners_", "");
            this.stencilItem = stencil;
            builder.comment("Wandering Trader trade for " + name + ".");
            builder.push(name);
            builder.comment("Should the stencil item for this pattern show up in wandering trader's trades?");
            this.addBasicTrade = builder.define("enabled", true);
            builder.comment("What is the base emerald cost for the stencil item?");
            this.emeralds = builder.defineInRange("emerald_cost", 12, 1, Integer.MAX_VALUE);
            builder.comment("How many trades can the player make before this trade becomes unavailable?");
            this.maxTrades = builder.defineInRange("max_trades", 1, 1, Integer.MAX_VALUE);
            builder.comment("How much XP should the player get from this trade?");
            this.xp = builder.defineInRange("reward_xp", 16, 0, Integer.MAX_VALUE);
            builder.comment("The price multiplier for the trade.");
            this.priceMultiplier = builder.defineInRange("price_multiplier", 1.0, 0.0, 1.0);
            builder.pop();
        }

        @Nullable
        public BasicTrade buildTrade() {
            return this.stencilItem == null || (Boolean)this.addBasicTrade.get() == false ? null : new BasicTrade(((Integer)this.emeralds.get()).intValue(), new ItemStack((IItemProvider)this.stencilItem), ((Integer)this.maxTrades.get()).intValue(), ((Integer)this.xp.get()).intValue(), ((Double)this.priceMultiplier.get()).floatValue());
        }
    }
}

