/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.additionalbanners;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BannerPatterns {
    public static final Map<String, PatternData> PATTERNS = new HashMap<String, PatternData>();
    private static final String MOD_ID = "additionalbanners";
    private static final String COMMON = "COMMON";
    private static final String UNCOMMON = "UNCOMMON";
    private static final String RARE = "RARE";
    private static final String EPIC = "EPIC";
    public static final PatternData ANCHOR = BannerPatterns.createPattern("anchor", "COMMON");
    public static final PatternData BALANCE = BannerPatterns.createPattern("balance", "COMMON");
    public static final PatternData GRASS = BannerPatterns.createPattern("grass", "COMMON");
    public static final PatternData KELP = BannerPatterns.createPattern("kelp", "COMMON");
    public static final PatternData MUSHROOM = BannerPatterns.createPattern("mushroom", "COMMON");
    public static final PatternData PUMPKIN = BannerPatterns.createPattern("pumpkin", "COMMON");
    public static final PatternData SNOWFLAKE = BannerPatterns.createPattern("snowflake", "COMMON");
    public static final PatternData SQUID = BannerPatterns.createPattern("squid", "UNCOMMON");
    public static final PatternData SHIELD = BannerPatterns.createPattern("shield", "UNCOMMON");
    public static final PatternData SWORD = BannerPatterns.createPattern("sword", "UNCOMMON");
    public static final PatternData FRAME = BannerPatterns.createPattern("frame", "UNCOMMON");
    public static final PatternData HEX = BannerPatterns.createPattern("hex", "UNCOMMON");
    public static final PatternData DRAGON = BannerPatterns.createPattern("dragon", "RARE");
    public static final PatternData PHANTOM = BannerPatterns.createPattern("phantom", "RARE");
    public static final PatternData TRIDENT = BannerPatterns.createPattern("trident", "RARE");
    public static final PatternData CLUBS = BannerPatterns.createPattern("clubs", "EPIC");
    public static final PatternData DIAMOND = BannerPatterns.createPattern("diamond", "EPIC");
    public static final PatternData HEART = BannerPatterns.createPattern("heart", "EPIC");
    public static final PatternData SPADES = BannerPatterns.createPattern("spades", "EPIC");
    public static final PatternData MOON = BannerPatterns.createPattern("moon", "EPIC");
    public static final PatternData SQUARES = BannerPatterns.createPattern("squares", "EPIC");

    private static PatternData createPattern(String name, String rarity) {
        PatternData pattern = new PatternData(name, rarity);
        PATTERNS.put(name, pattern);
        return pattern;
    }

    public static class PatternData {
        public final String name;
        public final String rarity;
        public final String enumName;
        public final String texture;

        public PatternData(String name, String rarity) {
            this.name = name;
            this.rarity = rarity;
            this.texture = "additionalbanners_" + this.name;
            this.enumName = this.texture.toUpperCase(Locale.ROOT);
        }
    }
}

