/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.additionalbanners;

import java.util.function.Supplier;
import net.darkhax.additionalbanners.config.TradeConfig;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.IRegistryObject;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;

public final class Content
extends RegistryDataProvider {
    public static void init() {
        Services.REGISTRIES.loadContent((RegistryDataProvider)new Content());
    }

    private Content() {
        super("additionalbanners");
        this.withItemTab(() -> new ItemStack((ItemLike)Items.f_42721_));
        this.createPattern("anchor", Rarity.COMMON);
        this.createPattern("balance", Rarity.COMMON);
        this.createPattern("grass", Rarity.COMMON);
        this.createPattern("kelp", Rarity.COMMON);
        this.createPattern("mushroom", Rarity.COMMON);
        this.createPattern("pumpkin", Rarity.COMMON);
        this.createPattern("snowflake", Rarity.COMMON);
        this.createPattern("steps", Rarity.COMMON);
        this.createPattern("squid", Rarity.UNCOMMON);
        this.createPattern("shield", Rarity.UNCOMMON);
        this.createPattern("sword", Rarity.UNCOMMON);
        this.createPattern("frame", Rarity.UNCOMMON);
        this.createPattern("hex", Rarity.UNCOMMON);
        this.createPattern("waterfall", Rarity.UNCOMMON);
        this.createPattern("starburst", Rarity.UNCOMMON);
        this.createPattern("prismarine", Rarity.UNCOMMON);
        this.createPattern("scales", Rarity.UNCOMMON, "up", "down", "left", "right");
        this.createPattern("chain", Rarity.UNCOMMON);
        this.createPattern("dragon", Rarity.RARE);
        this.createPattern("phantom", Rarity.RARE);
        this.createPattern("trident", Rarity.RARE);
        this.createPattern("cobweb", Rarity.RARE);
        this.createPattern("spider", Rarity.RARE);
        this.createPattern("clubs", Rarity.EPIC);
        this.createPattern("diamond", Rarity.EPIC);
        this.createPattern("heart", Rarity.EPIC);
        this.createPattern("spades", Rarity.EPIC);
        this.createPattern("moon", Rarity.EPIC);
        this.createPattern("squares", Rarity.EPIC);
    }

    private void createPattern(String name, Rarity rarity, String ... variants) {
        TagKey bannerTag = Services.TAGS.bannerPatternTag(new ResourceLocation("additionalbanners", "pattern_item/" + name));
        IRegistryObject stencilItem = this.items.add(() -> new BannerPatternItem(bannerTag, new Item.Properties().m_41487_(1).m_41497_(rarity)), name);
        this.addTradeEntries(name, (IRegistryObject<BannerPatternItem>)stencilItem, rarity);
        for (String variant : variants) {
            String subId = name + "_" + variant;
            this.bannerPatterns.add(() -> new BannerPattern(subId), subId);
        }
    }

    private void createPattern(String name, Rarity rarity) {
        TagKey bannerTag = Services.TAGS.bannerPatternTag(new ResourceLocation("additionalbanners", "pattern_item/" + name));
        IRegistryObject stencilItem = this.items.add(() -> new BannerPatternItem(bannerTag, new Item.Properties().m_41487_(1).m_41497_(rarity)), name);
        this.bannerPatterns.add(() -> new BannerPattern(name), name);
        this.addTradeEntries(name, (IRegistryObject<BannerPatternItem>)stencilItem, rarity);
    }

    private void addTradeEntries(String name, IRegistryObject<BannerPatternItem> stencilItem, Rarity rarity) {
        TradeConfig config = TradeConfig.load(name, rarity);
        if (config != null) {
            TradeConfig.VillagerOffer shepherdOffer;
            TradeConfig.WanderingOffer wanderingOffer = config.getWanderingOffer();
            if (wanderingOffer.isEnabled()) {
                if (wanderingOffer.isRareTrade()) {
                    this.trades.addRareWanderingTrade(wanderingOffer.createTrade((Supplier<? extends ItemLike>)stencilItem));
                } else {
                    this.trades.addCommonWanderingTrade(wanderingOffer.createTrade((Supplier<? extends ItemLike>)stencilItem));
                }
            }
            if ((shepherdOffer = config.getShepherdOffer()).isEnabled() && shepherdOffer.getTier() != null) {
                this.trades.addTrade(VillagerProfession.f_35597_, shepherdOffer.getTier(), shepherdOffer.createTrade((Supplier<? extends ItemLike>)stencilItem));
            }
        }
    }
}

