/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.additionalbanners.jei;

import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.util.Translator;
import net.darkhax.additionalbanners.handler.PatternHandler;
import net.darkhax.additionalbanners.jei.RecipeWrapperBanners;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBanner;
import net.minecraft.client.renderer.BannerTextures;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;

public class RecipeCategoryBanners
extends BlankRecipeCategory<RecipeWrapperBanners> {
    private final ModelBanner bannerModel = new ModelBanner();
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private BannerPattern pattern;
    private EnumDyeColor color = EnumDyeColor.WHITE;
    private int updateTicker = 0;
    private IDrawable slot;

    public RecipeCategoryBanners(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        ResourceLocation recipeBackgroundResource = new ResourceLocation("additionalbanners", "textures/gui/sprites.png");
        this.icon = guiHelper.createDrawable(recipeBackgroundResource, 240, 0, 16, 16);
        this.localizedName = Translator.translateToLocal((String)"gui.additionalbanners.jei.category.banners");
        this.slot = guiHelper.getSlotDrawable();
    }

    public void drawExtras(Minecraft minecraft) {
        this.slot.draw(minecraft, 0, 35);
        if (this.updateTicker == 60) {
            this.updateTicker = 0;
            this.color = this.next();
        }
        TileEntityBanner tile = new TileEntityBanner();
        tile.func_175112_a(PatternHandler.createBanner(this.color, PatternHandler.createPatternList(EnumDyeColor.BLACK, new PatternHandler.BannerLayer(this.pattern, EnumDyeColor.BLACK))), false);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)75.0f, (float)100.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.bannerModel.field_178688_b.field_78806_j = false;
        GlStateManager.func_179091_B();
        ResourceLocation resourcelocation = this.getBannerResourceLocation(tile);
        if (resourcelocation != null) {
            minecraft.func_110434_K().func_110577_a(resourcelocation);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)-20.0f, (float)-20.0f, (float)-20.0f);
            this.bannerModel.func_178687_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        ++this.updateTicker;
    }

    @Nullable
    private ResourceLocation getBannerResourceLocation(TileEntityBanner bannerObj) {
        return BannerTextures.field_178466_c.func_187478_a(bannerObj.func_175116_e(), bannerObj.func_175114_c(), bannerObj.func_175110_d());
    }

    public String getUid() {
        return "additionalbanners.banner";
    }

    public String getTitle() {
        return this.localizedName;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeWrapperBanners recipeWrapper, IIngredients ingredients) {
        this.pattern = recipeWrapper.getPattern();
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 35);
        itemStacks.set(ingredients);
    }

    public EnumDyeColor next() {
        return this.color == EnumDyeColor.BLACK ? EnumDyeColor.WHITE : EnumDyeColor.func_176764_b((int)(this.color.func_176765_a() + 1));
    }
}

