/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.init.Fuels;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.Generator;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class Commands {
    private static float reachDistance = 5.0f;

    public static void chunkStats(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        ChunkPollution pollution = WorldData.getChunkPollution((World)world, context.getBlockPos());
        BiomeId biome = BiomeId.from((IWorld)world, (BlockPos)context.getBlockPos());
        for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
            context.sendMessage(pollution.getOrCreateInfoFor(pollutant).toChatString(biome));
        }
    }

    public static void worldStats(ServerCommand.Context context) {
        StringBuilder builder = new StringBuilder();
        for (Pair<String, Integer> entry : WorldData.getData((World)context.getWorld()).getStats()) {
            builder.append(Commands.coloredValue((String)entry.getKey(), entry.getValue()));
            builder.append('\n');
        }
        context.sendMessage(builder.toString());
    }

    public static void testTag(ServerCommand.Context context) {
        String tag = (String)context.getArgument("tag", String.class);
        UnitId id = UnitId.from((String)tag);
        context.sendMessage("Items: " + ItemTags.func_199903_a().func_241834_b(id.toResLoc()).func_230236_b_().toString());
        context.sendMessage("Fluids: " + FluidTags.func_226157_a_().func_241834_b(id.toResLoc()).func_230236_b_().stream().map(fluid -> fluid.getRegistryName().toString()).collect(Collectors.toList()));
    }

    public static void loggingFuelConsumption(ServerCommand.Context context) {
        boolean newValue;
        WorldEvents.loggingFuelConsumption = newValue = !WorldEvents.loggingFuelConsumption;
        context.sendMessage("loggingFuelConsumption=" + Commands.coloredBoolean(newValue));
    }

    public static void listBreakables(ServerCommand.Context context) {
        Commands.logListOf("Breakables", AdPother.getInstance().breakables.getAll(), context);
    }

    public static void listEmitters(ServerCommand.Context context) {
        Commands.logListOf("Emitters", AdPother.getInstance().emitters.getAll(), context);
    }

    public static void listFuels(ServerCommand.Context context) {
        Commands.logListOf("Fuels", AdPother.getInstance().fuels.getAll(), context);
    }

    public static void listTorches(ServerCommand.Context context) {
        Commands.logListOf("Torches", AdPother.getInstance().torches.getAll(), context);
    }

    private static <O> void logListOf(String title, Collection<O> list, ServerCommand.Context context) {
        Logger logger = AdPother.getInstance().getLogger();
        logger.debug(title + "[" + list.size() + "]: {");
        list.forEach(arg_0 -> ((Logger)logger).info(arg_0));
        logger.debug("}");
        context.sendMessage("List of all " + title.toLowerCase() + " was written to .minecraft/logs/debug.log");
    }

    public static void generate(ServerCommand.Context context) {
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        if (pollutant == null) {
            return;
        }
        ServerWorld world = context.getWorld();
        ChunkPollution pollution = WorldData.getChunkPollution((World)world, context.getBlockPos());
        int amount = (Integer)context.getArgument("amount", Integer.TYPE);
        int count = Generator.generate((World)world, (WorldBounds)pollution.getLocation().getBounds(), pollutant, amount);
        context.sendMessage("Added " + count + " units of " + Commands.coloredPollutant(pollutant));
    }

    public static void cleanChunk(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        ChunkPos pos = new ChunkPos(context.getBlockPos());
        WorldData.getChunkPollution((World)world, ChunkLoc.from((World)world, (ChunkPos)pos)).clean((World)world);
        context.sendMessage("Chunk at " + pos + " cleaned of all pollution");
    }

    public static void cleanChunksAround(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        for (ChunkPos pos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            WorldData.getChunkPollution((World)world, ChunkLoc.from((World)world, (ChunkPos)pos)).clean((World)world);
        }
        context.sendMessage("Chunks around " + centerPos + " cleaned of all pollution");
    }

    public static void recalcPollutionAtChunk(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        ChunkPos pos = new ChunkPos(context.getBlockPos());
        WorldData.getChunkPollution((World)world, ChunkLoc.from((World)world, (ChunkPos)pos)).recalculate((World)world);
        context.sendMessage("Pollution at chunk " + pos + " recalculated");
    }

    public static void recalcPollutionAround(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        for (ChunkPos pos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            WorldData.getChunkPollution((World)world, ChunkLoc.from((World)world, (ChunkPos)pos)).recalculate((World)world);
        }
        context.sendMessage("Pollution around " + centerPos + " recalculated");
    }

    public static void testInfluence(ServerCommand.Context context) {
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        if (pollutant == null) {
            return;
        }
        ServerWorld world = context.getWorld();
        BlockRayTraceResult result = Commands.rayTraceBlockBeingLookedAt(context, true).orElse(null);
        if (result == null) {
            return;
        }
        BlockPos pos = result.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = pollutant.getBlockType((IBlockReader)world, pos, state);
        Optional<Direction> side = Optional.of(result.func_216354_b());
        context.sendMessage(Commands.coloredUnit("Target block", TextFormatting.GREEN, UnitId.from((BlockState)state)) + ", type: " + Commands.coloredText(type.toString(), TextFormatting.DARK_PURPLE));
        context.sendMessage(Commands.coloredPollutant(pollutant) + " influence(direct_contact: " + Commands.coloredBoolean(pollutant.canAffectBlock((IWorld)world, pos, side, true)) + ", global: " + Commands.coloredBoolean(pollutant.canAffectBlock((IWorld)world, pos, side, false)) + ")");
        context.sendMessage(Commands.coloredPollutant(pollutant) + " canPassThrough(from " + side.get() + " to " + side.get().func_176734_d() + "): " + Commands.coloredBoolean(pollutant.canPassThrough((IWorldReader)world, pos, side.get(), side.get().func_176734_d())));
        pollutant.affectBlockAt(world, pos, side, true, pollutant.func_176223_P());
    }

    public static void emitAt(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        BlockRayTraceResult result = Commands.rayTraceBlockBeingLookedAt(context, true).orElse(null);
        if (result == null) {
            return;
        }
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        if (pollutant == null) {
            return;
        }
        BlockPos pos = result.func_216350_a();
        TileEntity tile = world.func_175625_s(pos);
        BlockState state = world.func_180495_p(pos);
        int quantity = (Integer)context.getArgument("quantity", Integer.TYPE);
        if (tile != null) {
            Emitter emitter = (Emitter)AdPother.getInstance().emitters.findBy(state);
            Set<BlockState> relatedBlocks = Optional.ofNullable(emitter).map(e -> e.getRelatedBlocks()).orElse(Collections.emptySet());
            pollutant.emitFrom(tile, relatedBlocks, quantity);
        } else {
            pollutant.generateAt((World)world, pos, quantity, 1);
        }
    }

    public static void identifyEmitter(ServerCommand.Context context) {
        Entity entity;
        Emitter emitter;
        Optional<Pair<Entity, String>> info = Commands.getTargetEntityInfo(context, false);
        if (info.isPresent() && (emitter = (Emitter)AdPother.getInstance().emitters.findBy(entity = (Entity)info.get().getKey())) != null) {
            context.sendMessage(Commands.coloredEmitter((String)info.get().getValue(), emitter, emitter.isActive((INBTSerializable)entity)));
            return;
        }
        info = Commands.getTargetBlockInfo(context, false);
        if (info.isPresent()) {
            BlockPos pos;
            ServerWorld world = context.getWorld();
            Emitter emitter2 = (Emitter)AdPother.getInstance().emitters.findBy((IWorldReader)world, pos = (BlockPos)info.get().getKey());
            if (emitter2 != null) {
                context.sendMessage(Commands.coloredEmitter((String)info.get().getValue(), emitter2, emitter2.isActive((IWorldReader)world, pos)));
                return;
            }
            Torch torch = (Torch)AdPother.getInstance().torches.findBy((IWorldReader)world, pos);
            if (torch != null) {
                context.sendMessage(Commands.coloredEmitter((String)info.get().getValue(), torch, torch.isActive((IWorldReader)world, pos)));
                return;
            }
        }
        context.sendMessage(Commands.coloredError("No emitter found"));
    }

    private static String coloredEmitter(String name, IEmitter emitter, boolean active) {
        return name + " is " + (active ? Commands.coloredText("Active", TextFormatting.RED) : Commands.coloredText("Inactive", TextFormatting.GRAY)) + " " + Commands.coloredText(emitter.toString(), TextFormatting.DARK_AQUA);
    }

    private static String coloredFuel(String name, Fuel fuel) {
        return name + " is " + Commands.coloredText(fuel.toString(), TextFormatting.YELLOW);
    }

    private static String coloredError(String msg) {
        return Commands.coloredText(msg, TextFormatting.RED);
    }

    public static void identifyFuel(ServerCommand.Context context) {
        Item item;
        Fuel fuel;
        BlockState blockstate;
        BlockPos pos;
        FluidState fluidstate;
        Fuel fuel2;
        ServerWorld world = context.getWorld();
        Fuels fuels = AdPother.getInstance().fuels;
        Optional<Pair<BlockPos, String>> info = Commands.getTargetFluidInfo(context, false);
        if (info.isPresent() && (fuel2 = (Fuel)fuels.findBy((fluidstate = world.func_204610_c(pos = (BlockPos)info.get().getKey())).func_206886_c())) != null) {
            context.sendMessage(Commands.coloredFuel((String)info.get().getValue(), fuel2));
            return;
        }
        info = Commands.getTargetBlockInfo(context, false);
        if (info.isPresent() && (fuel2 = (Fuel)fuels.findBy(blockstate = world.func_180495_p(pos = (BlockPos)info.get().getKey()))) != null) {
            context.sendMessage(Commands.coloredFuel((String)info.get().getValue(), fuel2));
            return;
        }
        info = Commands.getHeldItemInfo(context, false);
        if (info.isPresent() && (fuel = (Fuel)fuels.findBy(item = (Item)info.get().getKey())) != null) {
            context.sendMessage(Commands.coloredFuel((String)info.get().getValue(), fuel));
            return;
        }
        context.sendMessage(Commands.coloredError("No fuel found"));
    }

    private static Optional<Pair<Item, String>> getHeldItemInfo(ServerCommand.Context context, boolean showErrorMessages) {
        Optional<ItemStack> stack = Commands.getHeldItem(context, Hand.MAIN_HAND);
        if (stack.isPresent()) {
            Item item = stack.get().func_77973_b();
            return Optional.of(Pair.of((Object)item, (Object)Commands.coloredUnit("Held item", TextFormatting.DARK_PURPLE, UnitId.from((Item)item))));
        }
        if (showErrorMessages) {
            context.sendMessage(Commands.coloredError("Main hand is empty"));
        }
        return Optional.empty();
    }

    private static Optional<Pair<BlockPos, String>> getTargetBlockInfo(ServerCommand.Context context, boolean showErrorMessages) {
        Optional<BlockRayTraceResult> result = Commands.rayTraceBlockBeingLookedAt(context, showErrorMessages);
        if (result.isPresent()) {
            BlockPos pos = result.get().func_216350_a();
            BlockState state = context.getWorld().func_180495_p(pos);
            return Optional.of(Pair.of((Object)pos, (Object)Commands.coloredUnit("Target block", TextFormatting.GREEN, UnitId.from((BlockState)state))));
        }
        return Optional.empty();
    }

    public static void identifyBlock(ServerCommand.Context context) {
        Commands.getTargetBlockInfo(context, true).ifPresent(info -> context.sendMessage((String)info.getValue()));
    }

    public static void identifyTile(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        Optional<Pair<BlockPos, String>> info = Commands.getTargetBlockInfo(context, true);
        if (info.isPresent()) {
            BlockPos pos = (BlockPos)info.get().getKey();
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                UnitId id = UnitId.from((ResourceLocation)tile.func_200662_C().getRegistryName());
                context.sendMessage(Commands.coloredUnit("Target tile", TextFormatting.BLUE, id) + " with " + Commands.coloredNbtTags((INBTSerializable<CompoundNBT>)tile));
            } else {
                context.sendMessage((String)info.get().getValue() + Commands.coloredError(" has no tile"));
            }
        }
    }

    public static void identifyEntity(ServerCommand.Context context) {
        Optional<Pair<Entity, String>> info = Commands.getTargetEntityInfo(context, true);
        if (info.isPresent()) {
            context.sendMessage((String)info.get().getValue());
        } else {
            context.sendMessage(Commands.coloredNoInSight("entity"));
        }
    }

    private static Optional<Pair<Entity, String>> getTargetEntityInfo(ServerCommand.Context context, boolean includeTags) {
        EntityRayTraceResult result = ForgeEntity.rayTraceEntityBeingLookedAt((Entity)context.getEntity(), (float)1.0f, (float)reachDistance).orElse(null);
        if (result != null) {
            Entity entity = result.func_216348_a();
            UnitId id = UnitId.from((ResourceLocation)entity.func_200600_R().getRegistryName());
            return Optional.of(Pair.of((Object)entity, (Object)(Commands.coloredUnit("Target entity", TextFormatting.YELLOW, id) + (includeTags ? " with " + Commands.coloredNbtTags((INBTSerializable<CompoundNBT>)entity) : ""))));
        }
        return Optional.empty();
    }

    private static Optional<Pair<BlockPos, String>> getTargetFluidInfo(ServerCommand.Context context, boolean showErrorMessages) {
        Optional<BlockRayTraceResult> result = Commands.rayTraceBlockBeingLookedAt(context, false);
        if (result.isPresent()) {
            BlockPos pos = result.get().func_216350_a();
            FluidState state = context.getWorld().func_204610_c(pos);
            if (!state.func_206888_e()) {
                return Optional.of(Pair.of((Object)pos, (Object)Commands.coloredUnit("Target fluid", TextFormatting.AQUA, UnitId.from((FluidState)state))));
            }
        }
        if (showErrorMessages) {
            context.sendMessage(Commands.coloredNoInSight("fluid"));
        }
        return Optional.empty();
    }

    private static String coloredNoInSight(String unit) {
        return Commands.coloredText("No " + unit + " in sight", TextFormatting.RED);
    }

    public static void identifyFluid(ServerCommand.Context context) {
        Commands.getTargetFluidInfo(context, true).ifPresent(info -> context.sendMessage((String)info.getValue()));
    }

    public static void identifyItem(ServerCommand.Context context) {
        Optional<Pair<Item, String>> info = Commands.getHeldItemInfo(context, true);
        if (info.isPresent()) {
            int burnTime = ForgeHooks.getBurnTime((ItemStack)new ItemStack((IItemProvider)info.get().getKey()));
            context.sendMessage(Args.join((Object[])new Object[]{info.get().getValue(), Commands.coloredText("burnTime: " + burnTime, TextFormatting.DARK_AQUA), Commands.coloredText((double)burnTime / 1600.0 + " of 1xcoal", TextFormatting.GRAY)}));
        }
    }

    public static void reloadBreakables(ServerCommand.Context context) {
        AdPother.getInstance().breakables.reloadConfigs();
        context.sendMessage("Configs for breakables reloaded");
    }

    public static void reloadEmitters(ServerCommand.Context context) {
        WorldData.getData((World)context.getWorld()).reloadEmitters();
        context.sendMessage("Configs for emitters reloaded");
    }

    public static void reloadFuels(ServerCommand.Context context) {
        AdPother.getInstance().fuels.reloadConfigs();
        context.sendMessage("Configs for fuels reloaded");
    }

    public static void reloadTorches(ServerCommand.Context context) {
        WorldData.getData((World)context.getWorld()).reloadTorches();
        context.sendMessage("Configs for torches reloaded");
    }

    public static void reloadMainConfig(ServerCommand.Context context) {
        AdPother.getInstance().mainConfigInit();
        context.sendMessage("Main config reloaded");
    }

    public static void tickBlock(ServerCommand.Context context) {
        Optional<Pair<BlockPos, String>> info = Commands.getTargetBlockInfo(context, true);
        if (info.isPresent()) {
            ServerWorld world = context.getWorld();
            BlockPos pos = (BlockPos)info.get().getKey();
            BlockState state = world.func_180495_p(pos);
            state.func_227034_b_(world, pos, world.field_73012_v);
            context.sendMessage((String)info.get().getValue() + " randomTick() at " + pos);
        }
    }

    public static void tickFluid(ServerCommand.Context context) {
        Optional<Pair<BlockPos, String>> info = Commands.getTargetFluidInfo(context, true);
        if (info.isPresent()) {
            ServerWorld world = context.getWorld();
            BlockPos pos = (BlockPos)info.get().getKey();
            FluidState state = world.func_204610_c(pos);
            state.func_206891_b((World)world, pos, world.field_73012_v);
            context.sendMessage((String)info.get().getValue() + " randomTick() at " + pos);
        }
    }

    private static Optional<ItemStack> getHeldItem(ServerCommand.Context context, Hand hand) {
        if (context.getEntity() instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)context.getEntity();
            return Optional.of(living.func_184586_b(hand));
        }
        return Optional.empty();
    }

    private static Optional<BlockRayTraceResult> rayTraceBlockBeingLookedAt(ServerCommand.Context context, boolean showErrorMessages) {
        Entity entity = context.getEntity();
        if (entity == null) {
            if (showErrorMessages) {
                context.sendMessage(Commands.coloredError("Sender entity is null"));
            }
            return Optional.empty();
        }
        ArrayList<BlockRayTraceResult> results = new ArrayList<BlockRayTraceResult>();
        for (RayTraceContext.BlockMode blockmod : RayTraceContext.BlockMode.values()) {
            Optional.ofNullable(ForgeEntity.rayTraceBlockBeingLookedAt((Entity)entity, (RayTraceContext.BlockMode)blockmod, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY, (float)1.0f, (float)reachDistance)).ifPresent(results::add);
        }
        results.removeIf(result -> result.func_216346_c() != RayTraceResult.Type.BLOCK);
        double minDistance = Double.MAX_VALUE;
        BlockRayTraceResult closestResult = null;
        for (BlockRayTraceResult result2 : results) {
            double distance = entity.func_174824_e(1.0f).func_72436_e(result2.func_216347_e());
            if (!(distance < minDistance)) continue;
            closestResult = result2;
            minDistance = distance;
        }
        if (closestResult != null) {
            return Optional.of(closestResult);
        }
        if (showErrorMessages) {
            context.sendMessage(Commands.coloredNoInSight("block"));
        }
        return Optional.empty();
    }

    private static Optional<Pollutant<?>> getPollutantByName(ServerCommand.Context context) {
        String name = (String)context.getArgument("pollutant", String.class);
        Optional<Pollutant<?>> pollutant = AdPother.getInstance().pollutants.findBy(name);
        if (!pollutant.isPresent()) {
            context.sendMessage(Commands.coloredError("Pollutant with specified name not found!"));
        }
        return pollutant;
    }

    private static String coloredText(String text, TextFormatting color) {
        return color + text + TextFormatting.RESET;
    }

    private static String coloredBoolean(boolean value) {
        return Commands.coloredText(String.valueOf(value), value ? TextFormatting.GREEN : TextFormatting.RED);
    }

    private static String coloredPollutant(Pollutant<?> pollutant) {
        return Commands.coloredText(pollutant.getRegistryName().func_110623_a(), pollutant.getTextColor());
    }

    private static String coloredUnit(String title, TextFormatting color, UnitId id) {
        return Commands.coloredText(title, color) + " -> " + Commands.coloredText(id.toString(), color);
    }

    private static String coloredValue(String name, Object value) {
        return Commands.coloredText(name, TextFormatting.DARK_AQUA) + ": " + Commands.coloredText(value.toString(), TextFormatting.YELLOW);
    }

    private static String coloredNbtTags(INBTSerializable<CompoundNBT> nbtSource) {
        CompoundNBT compound = (CompoundNBT)nbtSource.serializeNBT();
        Predicate name = IEmitter.COMMON_ACTIVE_TAG_NAME;
        ArrayList<String> tags = new ArrayList<String>();
        for (String key : compound.func_150296_c()) {
            ForgeNBT.Types type = ForgeNBT.getType((CompoundNBT)compound, (String)key);
            if (!name.test(key) || !type.isOrdinal() && type != ForgeNBT.Types.STRING) continue;
            tags.add(key);
        }
        return Commands.coloredText("NbtTags: " + ((Object)tags).toString(), TextFormatting.DARK_AQUA);
    }
}

