/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractGas
extends Pollutant<GasEntity> {
    public static GameTime spreadIntoWorldInterval = GameTime.seconds((int)3);
    private final MultiConfigProperty.IntProperty<BiomeId> absorbtionChance;
    private final MultiConfigProperty.IntProperty<BiomeId> cloudHeight;
    private final MultiConfigProperty.BoolProperty<BiomeId> affectedByWind;
    private final int lowerExplosiveLimit;

    public AbstractGas(ForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, props, GasEntity.class);
        String category = this.getUnitCategory();
        this.absorbtionChance = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"absorbtionChance", (int)props.absorbtionChance, (IntBounds)GameBounds.PERCENTAGE.getIntBounds(), (String)"Defines the chance (in percents) of this pollutant being absorbed by the affected block.");
        this.cloudHeight = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"cloudHeight", (int)props.cloudHeight, (IntBounds)GameBounds.HEIGHT.getIntBounds(), (String)"Only pollutant blocks within this height around concentration altitude will affect the level of pollution in the current chunk.\nRequired for pollutants capture and storage.");
        this.lowerExplosiveLimit = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"lowerExplosiveLimit", (int)props.lowerExplosiveLimit, (IntBounds)IntBounds.from((Integer)0, (Integer)512), (String)"The lowest number of adjacent gas blocks capable of producing an explosion in the presence of an ignition source.\nSet to zero to disable explosions.");
        this.affectedByWind = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"affectedByWind", (boolean)props.affectedByWind, (String)"Defines whether wind affects this pollutant or not.");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.absorbtionChance, this.cloudHeight, this.affectedByWind});
        this.negativeEffects.addDirect(Effects.field_76440_q);
    }

    public static boolean isGasBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof AbstractGas;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f - (float)this.getCarriedPollutionAmount(state) * 0.1f;
    }

    protected BlockState affectUnderlyingBlock(ServerWorld world, BlockPos sourcePos, BlockState sourceState) {
        if (this.isUnderRainOrStorm((IWorld)world, sourcePos)) {
            BlockPos targetPos = this.getFirstUnderlyingBlock((IWorldReader)world, sourcePos);
            boolean directContact = Math.abs(targetPos.func_177956_o() - sourcePos.func_177956_o()) <= 1;
            return this.affectBlockAt(world, targetPos, Optional.of(Direction.UP), directContact, sourceState);
        }
        return sourceState;
    }

    public boolean affectsPollutionLevel(IWorld world, BlockPos pos, BlockState state) {
        return this.getCloudVertBounds(world, pos).encloses(Integer.valueOf(pos.func_177956_o()));
    }

    public IntBounds getCloudVertBounds(IWorld world, BlockPos pos) {
        BiomeId biome = BiomeId.from((IWorld)world, (BlockPos)pos);
        return IntBounds.from((Integer)this.getConcentrationAltitudeIn(biome)).extend(Integer.valueOf(this.getCloudHeightIn(biome)));
    }

    public boolean addHitEffects(BlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    protected int pumpThroughVents(World world, List<BlockPos> vents, int amount) {
        int count = 0;
        if ((count += WorldSearch.VentPipe.pump((IWorld)world, vents, (int)(amount - count), (WorldSearch.BlockChain.BlockFunc)WorldSearch.VentPipe.VALID_CHIMNEY_BLOCK, (w, pos, max) -> this.pumpEntitiesAt((IWorld)world, pos, max))) >= amount) {
            return count;
        }
        if ((count += WorldSearch.VentPipe.pump((IWorld)world, vents, (int)(amount - count), GameWorld::isAirBlock, (w, pos, max) -> this.pump((IWorld)world, pos, 1))) >= amount) {
            return count;
        }
        if ((count += WorldSearch.VentPipe.pump((IWorld)world, vents, (int)(amount - count), (w, pos) -> true, (w, pos, max) -> this.pump((IWorld)world, pos, max))) >= amount) {
            return count;
        }
        count += WorldSearch.VentPipe.pump((IWorld)world, vents, (int)(amount - count), (w, pos) -> this.canPassThrough((IWorldReader)world, pos, Direction.DOWN, Direction.UP), (w, pos, max) -> this.pumpEntitiesAt((IWorld)world, pos, max));
        return count;
    }

    @Override
    public int emitFrom(TileEntity tile, Set<BlockState> relatedBlocks, int amount) {
        Optional<Direction> motionFacing;
        boolean hasTileEntity;
        int count = 0;
        World world = tile.func_145831_w();
        if (count >= amount || !this.isServerSide((IWorldReader)world)) {
            return count;
        }
        BlockPos sourcePos = tile.func_174877_v();
        WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((TileEntity)tile, relatedBlocks);
        boolean bl = hasTileEntity = world.func_175625_s(sourcePos) != null;
        if (!hasTileEntity && (motionFacing = this.getMotionFacing(world, sourcePos)).isPresent() && this.canPassThrough((IWorldReader)world, sourcePos, motionFacing.get(), motionFacing.get())) {
            neighbors.getFound().add(sourcePos);
        }
        Collections.shuffle(neighbors.getAboveBlocks());
        Collections.shuffle(neighbors.getUnderBlocks());
        Collections.shuffle(neighbors.getFound());
        count += this.pumpThroughVents(world, neighbors.getActiveVents(), amount - count);
        if (count >= amount) {
            return count;
        }
        for (BlockPos pos : neighbors.getTopChimneys()) {
            if ((count += this.pumpEntitiesAt((IWorld)world, pos, amount - count)) < amount) continue;
            return count;
        }
        for (BlockPos pos : neighbors.getSideChimneys()) {
            if ((count += this.pumpEntitiesAt((IWorld)world, pos, amount - count)) < amount) continue;
            return count;
        }
        if ((count += this.pumpThroughVents(world, neighbors.getPassiveVents(), amount - count)) >= amount) {
            return count;
        }
        for (BlockPos pos : neighbors.getFound()) {
            if (!world.func_175623_d(pos) || neighbors.isMultiblockHollow(pos) || (count += this.pumpEntitiesAt((IWorld)world, pos, amount - count)) < amount) continue;
            return count;
        }
        for (BlockPos pos : neighbors.getFound()) {
            Optional<Direction> motionFacing2 = this.getMotionFacing(world, pos);
            if (!motionFacing2.isPresent() || !this.canPassThrough((IWorldReader)world, pos, motionFacing2.get(), motionFacing2.get()) || neighbors.isMultiblockHollow(pos) || (count += this.pumpEntitiesAt((IWorld)world, pos, amount - count)) < amount) continue;
            return count;
        }
        return count;
    }

    public boolean canPassThrough(IWorldReader world, BlockPos pos, Direction input, Direction output) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof AbstractGas || this.isSamePollutant(state)) {
            return false;
        }
        if (block == Blocks.field_150350_a || block == Blocks.field_150480_ab) {
            return true;
        }
        if (block instanceof FenceBlock || block instanceof FenceGateBlock) {
            return true;
        }
        if (block instanceof PaneBlock && state.func_185904_a() == Material.field_151573_f) {
            return true;
        }
        if (block instanceof ISmokeContainer && ((ISmokeContainer)block).is(ISmokeContainer.Type.VENT) && input.func_176740_k().func_176722_c() && output.func_176740_k().func_176722_c()) {
            return true;
        }
        Material material = state.func_185904_a();
        if (material == Material.field_151584_j || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i) {
            return true;
        }
        if (this.getPassableBlocks().contains(state)) {
            return true;
        }
        for (Direction direction : new Direction[]{input, output}) {
            if (!state.func_224755_d((IBlockReader)world, pos, direction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<ItemStack, IStorageItem> getProtectiveItems(LivingEntity living) {
        HashMap<ItemStack, IStorageItem> items = new HashMap<ItemStack, IStorageItem>();
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            IStorage.Content content;
            Respirators.Respirator respirator = (Respirators.Respirator)AdPother.getInstance().respirators.findBy(stack);
            if (respirator == null || !respirator.isFunctional(stack) || (content = respirator.getContent(stack)).getFreeSpaceFor(this) <= 0) continue;
            items.put(stack, respirator);
        }
        return items;
    }

    public boolean canBeReplacedByLeaves(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean canDropFromExplosion(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.func_203425_a((Block)this) || newState.func_196958_f() || newState.func_177230_c() instanceof FlowingFluidBlock)) {
            BlockPos movePos;
            int amount = this.getCarriedPollutionAmount(state);
            List movePositions = GameWorld.Positions.getAroundCube((BlockPos)pos);
            Collections.shuffle(movePositions);
            int count = 0;
            Iterator iterator = movePositions.iterator();
            while (iterator.hasNext() && (count += this.pump((IWorld)world, movePos = (BlockPos)iterator.next(), amount - count)) < amount) {
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Override
    public Spread createSpread(final ServerWorld world, final BlockPos pos, final BlockState state) {
        return new Spread((World)world, pos, state, this){

            @Override
            public Spread around(int minDensityDelta) {
                block1: {
                    Direction dir;
                    if (this.completed() || !AbstractGas.this.canSpreadAround() || this.getPollutant().getCarriedPollutionAmount(state) < minDensityDelta) break block1;
                    IWind wind = GameWorld.getWindAt((World)world, (BlockPos)pos);
                    List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
                    wind.sortDirections(directions);
                    Iterator iterator = directions.iterator();
                    while (iterator.hasNext() && !this.in(dir = (Direction)iterator.next(), minDensityDelta).completed()) {
                    }
                }
                return this;
            }
        };
    }

    public boolean pushedBy(ServerWorld world, BlockPos pos, PlayerEntity player, Direction face) {
        if (!GameWorld.isServerSide((IWorldReader)world)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        float probability = 0.2f;
        if (!CommonMath.Random.result((float)probability)) {
            return false;
        }
        AbstractGas pollutant = (AbstractGas)block;
        ArrayList<Direction> directions = new ArrayList<Direction>(){
            private static final long serialVersionUID = -3415775606148431593L;

            @Override
            public boolean add(Direction e) {
                if (this.contains(e)) {
                    return false;
                }
                return super.add(e);
            }
        };
        directions.add(face.func_176734_d());
        Direction sourceDir = Direction.func_196054_a((Entity)player)[0];
        Direction pushDir = sourceDir.func_176734_d();
        directions.add(pushDir);
        Optional<Direction> motionFacing = pollutant.getMotionFacing((World)world, pos);
        if (motionFacing.isPresent()) {
            directions.add(motionFacing.get());
        }
        for (Direction dir : GameWorld.Directions.of().all().shuffle().toArray()) {
            directions.add(dir);
        }
        if (motionFacing.isPresent()) {
            Direction opposite = motionFacing.get().func_176734_d();
            directions.remove(opposite);
            directions.add(opposite);
        }
        directions.remove(sourceDir);
        directions.add(sourceDir);
        for (Direction dir : directions) {
            if (!pollutant.push((IWorld)world, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected GasEntity createEntityPollutant(ServerWorld world, BlockPos pos, BlockState carriedState) {
        return new GasEntity((World)world, pos, carriedState);
    }

    @Override
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return true;
    }

    @Override
    protected boolean spread(ServerWorld world, BlockPos pos, BlockState state) {
        boolean spreaded = super.spread(world, pos, state);
        return spreaded;
    }

    protected BlockPos getFirstUnderlyingBlock(IWorldReader world, BlockPos startPos) {
        BlockPos.Mutable pos = new BlockPos.Mutable().func_189533_g((Vector3i)startPos.func_177977_b());
        int minY = WorldData.altitudeBounds.getMin();
        for (int y = pos.func_177956_o(); y >= minY; --y) {
            pos.func_185336_p(y);
            if (!GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) break;
        }
        return pos.func_185334_h();
    }

    public Percentage getPercentageAt(ServerWorld world, BlockPos pos) {
        BiomeId biome = BiomeId.from((IWorld)world, (BlockPos)pos);
        PollutionInfo info = WorldData.getChunkPollution((World)world, pos).getOrCreateInfoFor(this);
        return info.getPercentageIn(biome);
    }

    public void func_225542_b_(BlockState sourceState, ServerWorld world, BlockPos sourcePos, Random random) {
        if (!this.isServerSide((IWorldReader)world) || !this.inAllowableDimension((World)world)) {
            return;
        }
        BlockState newSourceState = this.affectUnderlyingBlock(world, sourcePos, sourceState);
        if (newSourceState != sourceState) {
            world.func_175656_a(sourcePos, newSourceState);
            return;
        }
        if (this.pushedByWind((World)world, sourcePos, sourceState)) {
            return;
        }
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        for (BlockPos checkpos : GameWorld.Positions.getAroundCube((BlockPos)pos)) {
            if (!WorldData.isIgnitionSource((World)world, checkpos)) continue;
            if (!GasExplosion.in((World)world).position(pos).tryExplode()) break;
            return;
        }
        super.func_225534_a_(state, world, pos, rand);
    }

    protected boolean pushedByWind(World world, BlockPos sourcePos, BlockState sourceState) {
        if (!this.isAffectedByWindIn(BiomeId.from((IWorld)world, (BlockPos)sourcePos))) {
            return false;
        }
        IWind wind = GameWorld.getWindAt((World)world, (BlockPos)sourcePos);
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        wind.sortDirections(directions);
        for (Direction direction : directions) {
            BlockPos pos;
            float strength = wind.getStrengthIn(direction);
            if (!(strength > 0.0f)) continue;
            float factor = Wind.STRENGTH_BOUNDS.approxFactor(Float.valueOf(strength));
            int maxDistance = CommonMath.Approx.up((float)factor, (IntBounds)IntBounds.from((Integer)0, (Integer)this.getPollutionCapacity()));
            BlockPos destPos = null;
            for (int offset = 1; offset <= maxDistance && GameWorld.isBlockLoaded((IWorldReader)world, (BlockPos)(pos = sourcePos.func_177967_a(direction, offset))) && GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos); ++offset) {
                destPos = pos;
            }
            if (destPos == null || !this.pump((IWorld)world, destPos)) continue;
            return this.spend((IWorld)world, sourcePos);
        }
        return false;
    }

    public IPollutant.Type getPollutantType() {
        return IPollutant.Type.AIR;
    }

    public int getCloudHeightIn(BiomeId biome) {
        return (Integer)this.cloudHeight.get((Object)biome);
    }

    public float getAbsorbtionChanceIn(BiomeId biome) {
        return ((Integer)this.absorbtionChance.get((Object)biome)).intValue();
    }

    public int getLowerExplosiveLimit() {
        return this.lowerExplosiveLimit;
    }

    public boolean isAbsorbedIn(BiomeId biome) {
        float probability = this.getAbsorbtionChanceIn(biome) / 100.0f;
        return CommonMath.Random.result((float)probability);
    }

    public boolean isAffectedByWindIn(BiomeId biome) {
        return (Boolean)this.affectedByWind.get((Object)biome);
    }

    protected boolean isFilteredAt(ServerWorld world, BlockPos pos, Optional<Direction> side) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IFilterFrame) {
            if (side.isPresent() && state.func_224755_d((IBlockReader)world, pos, side.get())) {
                return false;
            }
            IFilterFrame filter = (IFilterFrame)block;
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                return filter.fill(tile, this, 1) > 0;
            }
        }
        return false;
    }

    protected boolean isUnderRainOrStorm(IWorld world, BlockPos pos) {
        if (world.func_72912_H().func_76059_o() || world.func_72912_H().func_76061_m()) {
            BlockPos checkPos = pos.func_177984_a();
            return world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, checkPos).func_177956_o() <= checkPos.func_177956_o();
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends Pollutant.Properties<T> {
        public int absorbtionChance = 0;
        public int lowerExplosiveLimit = 0;
        public int cloudHeight = 16;
        public boolean affectedByWind = true;

        public static Properties<?> with(String name, MaterialColor color) {
            return new Properties<Properties>(Properties.class, name, Properties.coloredGas(color));
        }

        protected static Material coloredGas(MaterialColor color) {
            return new Material(color, false, false, false, false, false, true, PushReaction.PUSH_ONLY);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
        }

        public T absorbtionChance(int percentage) {
            this.absorbtionChance = percentage;
            return (T)((Object)((Properties)this.self));
        }

        public T lowerExplosiveLimit(int limit) {
            this.lowerExplosiveLimit = limit;
            return (T)((Object)((Properties)this.self));
        }

        public T cloudHeight(int height) {
            this.cloudHeight = height;
            return (T)((Object)((Properties)this.self));
        }

        @Override
        public T setBlockProps() {
            super.setBlockProps();
            this.blockProps.func_200942_a().func_200944_c().func_200948_a(-1.0f, 0.0f).func_235847_c_((s, w, p) -> false).func_235842_b_((s, w, p) -> true);
            return (T)((Object)((Properties)this.self));
        }

        public T ignoreWind() {
            this.affectedByWind = false;
            return (T)((Object)((Properties)this.self));
        }
    }
}

