/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.DynamicTrees;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class Carbon
extends AbstractGas {
    public Carbon(ForgeMod mod, UnitConfig config, String name) {
        super(mod, config, (AbstractGas.Properties)((Object)((Pollutant.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)AbstractGas.Properties.with(name, MaterialColor.field_151670_w).criticalAmount(512))).concentrationAltitude(127))).motionVelocity(0.2f))).absorbtionChance(20))).lowerExplosiveLimit(10))).textColor(TextFormatting.GRAY)));
        this.filterMaterials.addDefaultValues("#minecraft:leaves, 8, #forge:dusts/charcoal");
        this.negativeEffects.addGlobal(Effects.field_76419_f, Percentage.value((float)30.0f)).addGlobal(Effects.field_76438_s, Percentage.value((float)40.0f)).addGlobal(Effects.field_76437_t, Percentage.value((float)50.0f)).addGlobal(Effects.field_76421_d, Percentage.value((float)60.0f)).addGlobal(Effects.field_76436_u, Percentage.value((float)70.0f)).addGlobal(Effects.field_76431_k, Percentage.value((float)80.0f)).addGlobal(Effects.field_82731_v, Percentage.value((float)90.0f)).addHostile(Effects.field_76420_g, Percentage.value((float)40.0f)).addHostile(Effects.field_76428_l, Percentage.value((float)80.0f));
    }

    public boolean canAffectBlock(IWorld world, BlockPos pos, Optional<Direction> side, boolean directContact) {
        BlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
        switch (type) {
            case IMMUNE: 
            case UNKNOWN: {
                return false;
            }
            case FILTER: {
                return true;
            }
            case GRASS_BLOCK: 
            case TALLGRASS: {
                return this.canAffectGrassIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
            case LEAVES: {
                return this.canAffectLeavesIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
            case PLANT: {
                return this.canAffectPlantsIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
        }
        return false;
    }

    @Override
    public BlockState affectBlockAt(ServerWorld world, BlockPos pos, Optional<Direction> side, boolean directContact, BlockState sourceState) {
        BlockState state = world.func_180495_p(pos);
        if (this.isSamePollutant(sourceState) && this.canAffectBlock((IWorld)world, pos, side, directContact)) {
            Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
            switch (type) {
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case LEAVES: {
                    DynamicTrees.pulseGrow(world, pos, state);
                    if (!this.isAbsorbedIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                    return this.getSpreadedState(sourceState);
                }
                case GRASS_BLOCK: 
                case TALLGRASS: 
                case PLANT: {
                    if (!this.doBonemealEffect(world, pos, state)) break;
                    return this.getSpreadedState(sourceState);
                }
            }
        }
        return sourceState;
    }

    @Override
    protected BlockState affectUnderlyingBlock(ServerWorld world, BlockPos sourcePos, BlockState sourceState) {
        BlockPos targetPos = this.getFirstUnderlyingBlock((IWorldReader)world, sourcePos);
        return this.affectBlockAt(world, targetPos, Optional.of(Direction.UP), false, sourceState);
    }
}

