/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class Dust
extends AbstractGas {
    private MultiConfigProperty.BoolProperty<BiomeId> canAffectSoil;

    public Dust(ForgeMod mod, UnitConfig config, String name) {
        super(mod, config, (AbstractGas.Properties)((Object)((Pollutant.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)AbstractGas.Properties.with(name, MaterialColor.field_197656_x).criticalAmount(512))).concentrationAltitude(0))).motionVelocity(0.1f))).absorbtionChance(80))).lowerExplosiveLimit(20))).textColor(TextFormatting.WHITE)));
        this.canAffectSoil = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)this.getUnitCategory(), (String)"canAffectSoil", (boolean)true, (String)"Defines the ability to influence the soil.");
        this.filterMaterials.addDefaultValues("paper, 8, clay_ball");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.canAffectSoil});
    }

    public boolean canAffectSoilIn(BiomeId biome) {
        return (Boolean)this.canAffectSoil.get((Object)biome);
    }

    @Override
    public int emitFrom(TileEntity tile, Set<BlockState> relatedBlocks, int amount) {
        if (amount > 0) {
            WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((TileEntity)tile, relatedBlocks);
            Collections.shuffle(neighbors.getFound());
            int count = 0;
            for (BlockPos pos : neighbors.getFound()) {
                if (neighbors.isMultiblockHollow(pos) || (count += this.pump((IWorld)tile.func_145831_w(), pos, amount - count)) < amount) continue;
                return count;
            }
        }
        return amount;
    }

    @Override
    public boolean affectsPollutionLevel(IWorld world, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean canAffectBlock(IWorld world, BlockPos pos, Optional<Direction> side, boolean directContact) {
        BlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
        switch (type) {
            case IMMUNE: 
            case UNKNOWN: {
                return false;
            }
            case FILTER: {
                return true;
            }
            case GRASS_BLOCK: 
            case TALLGRASS: {
                return this.canAffectGrassIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
            case LEAVES: {
                return this.canAffectLeavesIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
            case PLANT: {
                return this.canAffectPlantsIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
            case SOIL: {
                return this.canAffectSoilIn(BiomeId.from((IWorld)world, (BlockPos)pos)) && this.isUnderRainOrStorm(world, pos);
            }
            case WATER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public BlockState affectBlockAt(ServerWorld world, BlockPos pos, Optional<Direction> side, boolean directContact, BlockState sourceState) {
        if (this.isSamePollutant(sourceState) && this.canAffectBlock((IWorld)world, pos, side, directContact)) {
            BlockState state = world.func_180495_p(pos);
            Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
            boolean replaced = false;
            switch (type) {
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case GRASS_BLOCK: {
                    replaced = world.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 3);
                    break;
                }
                case TALLGRASS: 
                case LEAVES: 
                case PLANT: 
                case WATER: {
                    replaced = world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    break;
                }
                case SOIL: {
                    if (state.func_203425_a(Blocks.field_196660_k)) {
                        replaced = world.func_180501_a(pos, Blocks.field_150351_n.func_176223_P(), 3);
                        break;
                    }
                    replaced = world.func_180501_a(pos, Blocks.field_196660_k.func_176223_P(), 3);
                    break;
                }
            }
            if (replaced && this.isAbsorbedIn(BiomeId.from((IWorld)world, (BlockPos)pos))) {
                return this.getSpreadedState(sourceState);
            }
        }
        return sourceState;
    }
}

