/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ForgeTiledBlock;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.tiles.ForgeTileWithInventory;
import com.endertech.minecraft.forge.tiles.TileInventory;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.entities.PurifiedAir;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import com.endertech.minecraft.mods.adpother.pollution.IPurifier;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class FilterFrame
extends ForgeTiledBlock<BlockTile>
implements IFilterFrame<BlockTile>,
ISmokeContainer,
IWaterLoggable {
    public static final EnumProperty<Condition> SATURATION = FilterFrame.createEnumProperty(Condition.class);
    public static final float WALL_THICKNESS = 0.125f;
    protected static final VoxelShape HOLE = FilterFrame.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape FILTER = FilterFrame.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_EMPTY = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)HOLE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    protected static final VoxelShape SHAPE_FILLED = VoxelShapes.func_197872_a((VoxelShape)SHAPE_EMPTY, (VoxelShape)FILTER);
    protected final int slotLimit;
    protected final ForgeEnergy.StorageProps energyProps;
    protected final AirPurifier airPurifier;
    protected final WaterPurifier waterPurifier;

    public FilterFrame(ForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, props, BlockTile.class);
        String category = this.getUnitCategory();
        this.slotLimit = props.slotLimit;
        this.energyProps = ForgeEnergy.StorageProps.create((UnitConfig)config, (String)category, (boolean)false, (int)(props.slotLimit * 100), (int)50);
        this.airPurifier = new AirPurifier(config, category, props.airPurifierEffectiveRadius, props.airPurifierMaxRadius);
        this.waterPurifier = new WaterPurifier(config, category, props.waterPurifierMaxRadius, props.waterPurifierEfficiency);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(SATURATION, (Comparable)((Object)Condition.CLEAN))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SATURATION, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)true);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return IWaterLoggable.getStateForPlacement((BlockItemUseContext)context, (BlockState)this.func_176223_P());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((IWorld)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.hasFilterMaterialInstalled(world, pos) ? SHAPE_FILLED : SHAPE_EMPTY;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return !this.hasFilterMaterialInstalled((IBlockReader)world, pos);
    }

    public boolean hasFilterMaterialInstalled(IBlockReader world, BlockPos pos) {
        return this.getTile(world, pos).map(tile -> !tile.getFilterMaterial().func_190926_b()).orElse(false);
    }

    public BlockTile createTile(IBlockReader world, BlockState state) {
        return new BlockTile();
    }

    @Override
    public int fill(BlockTile storage, Pollutant<?> pollutant, int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (!storage.isActive()) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        int fullnessOld = content.getFullnessWith(pollutant);
        int count = content.fillWith(pollutant, amount);
        int fullnessNew = content.getFullnessWith(pollutant);
        int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
        ForgeEnergy.Storage energyStorage = storage.energyStorage;
        int materialUsed = materialCapacity != 0 ? fullnessNew / materialCapacity - fullnessOld / materialCapacity : 0;
        int energyUsed = energyStorage.getConsumption() * count;
        energyStorage.extractEnergy(energyUsed, false);
        TileInventory inventory = storage.getTileInventory();
        inventory.extractItem(0, materialUsed, false);
        ItemStack byproduct = pollutant.getFilterMaterials().getByproductFor(filterMaterial, materialUsed);
        inventory.insertItem(1, byproduct, false);
        this._handleChanges(content, (Object)storage);
        return count;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Optional tile = this.getTile((IBlockReader)world, pos);
        if (GameWorld.isServerSide((IWorldReader)world) && tile.isPresent()) {
            ((BlockTile)((Object)tile.get())).energyStorage.set(this.energyProps);
            ((BlockTile)((Object)tile.get())).syncWithClients();
        }
    }

    public AirPurifier getAirPurifier() {
        return this.airPurifier;
    }

    public void func_220062_a(BlockState state, ServerWorld world, BlockPos pos, ItemStack stack) {
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            this.getTile((IBlockReader)world, pos).ifPresent(tile -> {
                FilterFrame.func_180635_a((World)world, (BlockPos)pos, (ItemStack)tile.getFilterMaterial());
                FilterFrame.func_180635_a((World)world, (BlockPos)pos, (ItemStack)tile.getByproduct());
                world.func_175666_e(pos, state.func_177230_c());
            });
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public IStorage.Content getContent(BlockTile tile) {
        return tile.content;
    }

    @Override
    public void onContentChanged(IStorage.Content content, BlockTile tile) {
        World world = tile.func_145831_w();
        if (this.isServerSide((IWorldReader)world)) {
            world.func_205220_G_().func_205360_a(tile.func_174877_v(), (Object)this, 1);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        BlockTile storage = this.getTile((IBlockReader)world, pos).orElse(null);
        if (storage == null) {
            return;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        List<Pollutant<?>> targetPollutants = storage.getTargetPollutants();
        for (Pollutant<?> pollutant2 : targetPollutants) {
            ItemStack byproduct;
            int capacity = this.getInitialCapacity(storage);
            int materialCapacity = pollutant2.getFilterMaterials().getCapacityFor(filterMaterial);
            int fullness = Math.max(storage.partialFullness, content.getFullnessWith(pollutant2));
            if (materialCapacity != 0) {
                storage.partialFullness = fullness %= materialCapacity;
            }
            if ((byproduct = storage.getByproduct()).func_77969_a(pollutant2.getFilterMaterials().getByproductFor(filterMaterial, 1))) {
                fullness += materialCapacity * byproduct.func_190916_E();
            } else if (!byproduct.func_190926_b()) {
                fullness = capacity;
            }
            content.installFiltersFor(capacity, pollutant2);
            content.setFullnessWith(pollutant2, fullness);
        }
        AdPother.getInstance().pollutants.getAll().forEach(pollutant -> {
            if (!targetPollutants.contains(pollutant)) {
                content.removeFiltersFor((Pollutant<?>)((Object)pollutant));
            }
        });
        storage.getTileInventory().setStackInSlot(2, new ItemStack((IItemProvider)CommonCollect.getRandomElementFrom(targetPollutants)));
        this.dropByProductToBottomHopper(storage.getTileInventory());
        this.updateBlockState((World)world, pos, state, content.getHighestFullnessPercentage());
        GameWorld.Positions.getAroundCube((BlockPos)pos.func_177977_b()).forEach(p -> world.func_195593_d(p, (Block)this));
        storage.renderMaterial = storage.getFilterMaterial();
        storage.isActive();
        content.changed = false;
        storage.syncWithClients();
    }

    protected boolean dropByProductToBottomHopper(TileInventory tileInventory) {
        ItemStack extractItem;
        World world = tileInventory.getTile().func_145831_w();
        IHopper hopper = this.getBottomHopper(world, tileInventory.getTile().func_174877_v()).orElse(null);
        if (hopper != null && !(extractItem = tileInventory.extractItem(1, 1, true)).func_190926_b()) {
            for (int j = 0; j < hopper.func_70302_i_(); ++j) {
                ItemStack destStack = hopper.func_70301_a(j);
                if (!hopper.func_94041_b(j, extractItem) || !destStack.func_190926_b() && (destStack.func_190916_E() >= destStack.func_77976_d() || destStack.func_190916_E() >= hopper.func_70297_j_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = tileInventory.extractItem(1, 1, false);
                if (destStack.func_190926_b()) {
                    hopper.func_70299_a(j, extractItem);
                } else {
                    destStack.func_190917_f(1);
                    hopper.func_70299_a(j, destStack);
                }
                hopper.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean isChimneyOrPump(IWorldReader world, BlockPos pos) {
        return GameWorld.SmokeContainers.isChimney((IWorldReader)world, (BlockPos)pos) || GameWorld.SmokeContainers.isPump((IWorldReader)world, (BlockPos)pos);
    }

    protected Optional<IHopper> getBottomHopper(World world, BlockPos startPos) {
        BlockPos pos = GameWorld.Positions.getLastInLine((IWorldReader)world, (BlockPos)startPos, this::isChimneyOrPump, (Direction)Direction.DOWN).func_177977_b();
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof IHopper ? Optional.of((IHopper)tile) : Optional.empty();
    }

    protected void updateBlockState(World world, BlockPos pos, BlockState state, Percentage fullness) {
        BlockState newState = this.func_176223_P();
        if (fullness.getGrade() == Percentage.Grade.HIGH) {
            newState = (BlockState)this.func_176223_P().func_206870_a(SATURATION, (Comparable)((Object)Condition.DIRTY));
        }
        if (state != newState) {
            world.func_175656_a(pos, newState);
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        BlockTile tile = this.getTile(blockAccess, pos).orElse(null);
        if (tile != null && !tile.getFilterMaterial().func_190926_b()) {
            Percentage percentage = this.getContent(tile).getHighestFullnessPercentage();
            float factor = percentage.toFraction();
            int power = GameBounds.REDSTONE_POWER.getIntBounds().approxDown(factor);
            return power;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Override
    public int getInitialCapacity(BlockTile storage) {
        int capacity = 0;
        ItemStack filterMaterial = storage.getFilterMaterial();
        for (Pollutant<?> pollutant : storage.getTargetPollutants()) {
            int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
            capacity = Math.max(capacity, materialCapacity * storage.getTileInventory().getSlotLimit(0));
        }
        return capacity;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            this.getTile((IBlockReader)world, pos).ifPresent(tile -> tile.openGuiScreenFor((ServerPlayerEntity)player));
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    public ColorARGB getColor() {
        return ColorARGB.DEFAULT;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.CHIMNEY;
    }

    public boolean isActive(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (IWaterLoggable.isWaterlogged((BlockState)state)) {
            return false;
        }
        return this.getTile(world, pos).map(tile -> tile.isActive()).orElse(false);
    }

    static class PollutantSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 2;

        public PollutantSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 2, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity player) {
            return false;
        }
    }

    static class ByproductSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 1;

        public ByproductSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 1, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }

    static class MaterialSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 0;

        public MaterialSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 0, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return MaterialSlot.isItemValid(this.tileInventory, stack);
        }

        public static boolean isItemValid(TileInventory tileInventory, ItemStack stack) {
            if (tileInventory.getTile() instanceof BlockTile) {
                return ((BlockTile)tileInventory.getTile()).isValidFilterMaterial(stack);
            }
            return false;
        }
    }

    public static class WaterPurifier
    implements IPurifier {
        public static final CommonTime.Interval DEFAULT_UPDATE_INTERVAL = CommonTime.Interval.seconds((double)10.0);
        public static final int MAX_RADIUS = 16;
        public final int maximumRadius;
        public final Percentage efficiency;
        public CommonTime.Interval updateInterval;

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency) {
            this(config, headCategory, maximumRadius, efficiency, DEFAULT_UPDATE_INTERVAL);
        }

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency, CommonTime.Interval updateInterval) {
            String category = Names.dotted().join(new String[]{headCategory, "WaterPurifier"});
            this.maximumRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.from((Integer)0, (Integer)16), (String)"Defines the maximum cleaning radius of the purifier (in blocks).");
            this.efficiency = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"efficiency", (Percentage)efficiency, (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Defines the efficiency of the purifier (in percent).\nThe lower the efficiency, the more filter material will be used up and the longer the cleaning process will take.");
            this.updateInterval = CommonTime.Interval.seconds((double)UnitConfig.getInt((UnitConfig)config, (String)category, (String)"updateInterval", (int)((int)updateInterval.inSeconds()), (IntBounds)IntBounds.from((Integer)1, (Integer)120), (String)"Defines the update interval (in seconds).\nThe smaller the interval, the higher the cleaning speed."));
        }

        @Override
        public BlockPos getOutputPos(IWorldReader world, BlockPos filterPos) {
            return filterPos.func_177984_a();
        }

        @Override
        public BlockPos getPumpPos(IWorldReader world, BlockPos filterPos) {
            return filterPos.func_177977_b();
        }

        @Override
        public boolean hasProperInput(IWorldReader world, BlockPos pumpPos) {
            return GameWorld.Positions.getAroundHoriz((BlockPos)pumpPos, (boolean)false, (BlockPos[])new BlockPos[0]).stream().anyMatch(pos -> world.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a));
        }

        @Override
        public boolean hasProperOutput(IWorldReader world, BlockPos outputPos) {
            return GameWorld.isAirBlock((IWorldReader)world, (BlockPos)outputPos);
        }

        public Optional<BlockPos> findPollutedWater(IWorld world, BlockPos filterPos, final List<Pollutant<?>> targetPollutants) {
            Fluids.WaterChain chain = new Fluids.WaterChain(world, this.getPumpPos((IWorldReader)world, filterPos), this.maximumRadius){

                protected boolean onValidFound(BlockPos pos) {
                    return false;
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.isWithinMaxRadius(pos) && PollutedWater.isSource((IBlockReader)this.world, pos) && PollutedWater.findPollutant((IBlockReader)this.world, pos, targetPollutants).isPresent();
                }
            };
            chain.build();
            return chain.getFound().stream().findFirst();
        }
    }

    public static class AirPurifier
    implements IPurifier {
        public static final int MAX_RADIUS = 32;
        public final int effectiveRadius;
        public final int maximumRadius;

        public AirPurifier(UnitConfig config, String headCategory, int effectiveRadius, int maximumRadius) {
            String category = Names.dotted().join(new String[]{headCategory, "AirPurifier"});
            this.effectiveRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"effectiveRadius", (int)effectiveRadius, (IntBounds)IntBounds.from((Integer)0, (Integer)32), (String)"Defines the radius of the area in which the purified air created by this purifier has the maximum effect");
            this.maximumRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.from((Integer)0, (Integer)32), (String)"Defines the maximum radius of the purified air effect.\nThe effect will fade between effectiveRadius and maximumRadius");
        }

        @Override
        public BlockPos getOutputPos(IWorldReader world, BlockPos filterPos) {
            while (GameWorld.SmokeContainers.isChimney((IWorldReader)world, (BlockPos)(filterPos = filterPos.func_177984_a()))) {
            }
            return filterPos;
        }

        @Override
        public BlockPos getPumpPos(IWorldReader world, BlockPos filterPos) {
            BlockPos pumpPos = filterPos;
            while (GameWorld.SmokeContainers.isChimney((IWorldReader)world, (BlockPos)(pumpPos = pumpPos.func_177977_b()))) {
            }
            return pumpPos;
        }

        @Override
        public boolean hasProperInput(IWorldReader world, BlockPos pumpPos) {
            return !this.isBlockedFromAllSides(world, pumpPos, GameWorld.Directions.CLOCKWISE_HORIZONTALS);
        }

        protected boolean isBlockedFromAllSides(IWorldReader world, BlockPos centerPos, Direction ... sides) {
            for (Direction side : sides) {
                if (this.isSideBlocked(world, centerPos, side)) continue;
                return false;
            }
            return true;
        }

        protected boolean isSideBlocked(IWorldReader world, BlockPos pos, Direction side) {
            if (world.func_180495_p(pos).func_224755_d((IBlockReader)world, pos, side)) {
                return true;
            }
            BlockPos nextpos = pos.func_177972_a(side);
            if (world.func_180495_p(nextpos).func_224755_d((IBlockReader)world, nextpos, side.func_176734_d())) {
                return true;
            }
            float height = world.func_204610_c(nextpos).func_215679_a((IBlockReader)world, nextpos);
            return (double)height >= 0.7;
        }

        @Override
        public boolean hasProperOutput(IWorldReader world, BlockPos outputPos) {
            while (WorldData.altitudeBounds.encloses(Integer.valueOf(outputPos.func_177956_o()))) {
                BlockState state = world.func_180495_p(outputPos);
                if (state.func_196958_f()) {
                    return true;
                }
                if (state.func_224755_d((IBlockReader)world, outputPos, Direction.DOWN)) {
                    return false;
                }
                if (this.isBlockedFromAllSides(world, outputPos, GameWorld.Directions.of().horizontals().up().toArray())) {
                    return false;
                }
                outputPos = outputPos.func_177984_a();
            }
            return false;
        }
    }

    public static class Container
    extends TileInventory.AbstractContainer {
        public Container(int id, PlayerInventory playerInventory, TileInventory tileInventory) {
            super(AdPother.getInstance().containers.filterFrame, id, playerInventory, tileInventory);
            this.addPlayerSlots(8, 84);
            this.func_75146_a((Slot)new MaterialSlot(tileInventory, 56, 17));
            this.func_75146_a((Slot)new ByproductSlot(tileInventory, 116, 35));
            this.func_75146_a((Slot)new PollutantSlot(tileInventory, 56, 53));
        }

        public static class Factory
        implements IContainerFactory<Container> {
            public Container create(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
                BlockPos pos;
                World world = playerInventory.field_70458_d.func_130014_f_();
                TileEntity te = world.func_175625_s(pos = data.func_179259_c());
                if (te instanceof BlockTile) {
                    return new Container(windowId, playerInventory, ((BlockTile)te).getTileInventory());
                }
                return null;
            }
        }
    }

    public static class BlockItem
    extends ForgeBlockItem
    implements IStorageItem {
        public BlockItem(ForgeBlock block, Item.Properties props) {
            super((Block)block, props);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
            IStorageItem.super.addInformation(stack, world, lines, flag);
            super.func_77624_a(stack, world, lines, flag);
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return 0;
        }
    }

    public static class BlockTile
    extends ForgeTileWithInventory
    implements ITickableTileEntity {
        protected ItemStack renderMaterial = ItemStack.field_190927_a;
        protected boolean active = false;
        protected boolean purifyingAir = false;
        protected boolean purifyingWater = false;
        protected int partialFullness = 0;
        protected final IStorage.Content content = new IStorage.Content(0);
        protected final TileInventory inventory = new Inventory((TileEntity)this, 3);
        protected final ForgeEnergy.Storage energyStorage = ForgeEnergy.Storage.empty();
        protected final LazyOptional<ForgeEnergy.Storage> energyStorageHolder = LazyOptional.of(() -> this.energyStorage);
        protected final Supplier<GameTime> airPurifierUpdateInterval = () -> GameTime.second();
        protected final Supplier<GameTime> waterPurifierUpdateInterval = () -> GameTime.time((CommonTime.Interval)this.getFilter().map(filter -> filter.waterPurifier.updateInterval).orElse(WaterPurifier.DEFAULT_UPDATE_INTERVAL));

        public BlockTile() {
            super(AdPother.getInstance().tiles.filterFrame);
        }

        public void func_73660_a() {
            Optional.ofNullable(this.func_145831_w()).ifPresent(world -> {
                if (GameWorld.isServerSide((IWorldReader)world)) {
                    this.serverTick();
                } else {
                    this.clientTick();
                }
            });
        }

        public TileInventory getTileInventory() {
            return this.inventory;
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.adpother.filter_frame");
        }

        protected RangedWrapper createInput(final TileInventory inventory) {
            return new RangedWrapper((IItemHandlerModifiable)inventory, 0, 1){

                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (MaterialSlot.isItemValid(inventory, stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }
            };
        }

        protected RangedWrapper createOutput(TileInventory inventory) {
            return new RangedWrapper((IItemHandlerModifiable)inventory, 1, 2);
        }

        protected net.minecraft.inventory.container.Container createContainer(int id, PlayerEntity player, PlayerInventory playerInventory, TileInventory tileInventory) {
            return new Container(id, playerInventory, tileInventory);
        }

        protected void serverTick() {
            IPurifier purifier;
            boolean needSync = false;
            if (this.airPurifierUpdateInterval.get().pastIn(this.field_145850_b)) {
                purifier = this.getAirPurifier().orElse(null);
                if (purifier != null && purifier.isActive((IWorldReader)this.func_145831_w(), this.func_174877_v())) {
                    if (!this.purifyingAir) {
                        this.purifyingAir = true;
                        needSync = true;
                    }
                    BlockPos outputPos = ((AirPurifier)purifier).getOutputPos((IWorldReader)this.func_145831_w(), this.func_174877_v());
                    List<PurifiedAir> entities = PurifiedAir.getAllAt(this.field_145850_b, outputPos);
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        boolean exists = false;
                        for (PurifiedAir entity : entities) {
                            if (!entity.getPollutant().filter(p -> p == pollutant).isPresent()) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                        this.field_145850_b.func_217376_c((Entity)new PurifiedAir(this.field_145850_b, outputPos, pollutant, this.func_174877_v()));
                    }
                } else if (this.purifyingAir) {
                    this.purifyingAir = false;
                    needSync = true;
                }
            }
            if (this.waterPurifierUpdateInterval.get().pastIn(this.field_145850_b)) {
                purifier = this.getWaterPurifier().orElse(null);
                if (purifier != null && purifier.isActive((IWorldReader)this.func_145831_w(), this.func_174877_v())) {
                    Optional<BlockPos> waterPos;
                    boolean filled;
                    if (!this.purifyingWater) {
                        this.purifyingWater = true;
                        needSync = true;
                    }
                    FilterFrame filter = this.getFilter().orElse(null);
                    List<Pollutant<?>> targetPollutants = this.getTargetPollutants();
                    if (filter != null && !targetPollutants.isEmpty() && (filled = (waterPos = ((WaterPurifier)purifier).findPollutedWater((IWorld)this.field_145850_b, this.func_174877_v(), targetPollutants)).flatMap(pos -> PollutedWater.findPollutant((IBlockReader)this.field_145850_b, pos, targetPollutants)).map(waterPollutant -> filter.fill(this, (Pollutant<?>)((Object)waterPollutant), 1) > 0).orElse(false).booleanValue()) && ((WaterPurifier)purifier).efficiency.takeChance()) {
                        this.field_145850_b.func_175656_a(waterPos.get(), Blocks.field_150355_j.func_176223_P());
                    }
                } else if (this.purifyingWater) {
                    this.purifyingWater = false;
                    needSync = true;
                }
            }
            if (needSync) {
                this.syncWithClients();
            }
        }

        protected void clientTick() {
            if (this.purifyingAir && GameTime.seconds((int)3).pastIn(this.field_145850_b)) {
                this.getAirPurifier().ifPresent(purifier -> purifier.spawnParticle(this.field_145850_b, this.func_174877_v(), ParticleTypes.field_197613_f));
            }
            if (this.purifyingWater && GameTime.seconds((float)0.5f).pastIn(this.field_145850_b)) {
                this.getWaterPurifier().ifPresent(purifier -> purifier.spawnParticle(this.field_145850_b, this.func_174877_v(), ParticleTypes.field_218425_n));
            }
        }

        public ItemStack getFilterMaterial() {
            return this.getTileInventory().getStackInSlot(0);
        }

        public ItemStack getRenderMaterial() {
            return this.renderMaterial;
        }

        public ItemStack getByproduct() {
            return this.getTileInventory().getStackInSlot(1);
        }

        public boolean isValidFilterMaterial(ItemStack stack) {
            for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
                if (!pollutant.getFilterMaterials().contains(stack)) continue;
                return true;
            }
            return false;
        }

        public boolean isActive() {
            if (GameWorld.isServerSide((IWorldReader)this.func_145831_w())) {
                boolean newValue = false;
                if (this.content.hasFunctionalFilters() && (!this.energyStorage.isEnabled() || this.energyStorage.hasEnoughEnergy())) {
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        if (this.content.getFreeSpaceFor(pollutant) <= 0) continue;
                        newValue = true;
                    }
                }
                if (this.active != newValue) {
                    this.active = newValue;
                }
            }
            return this.active;
        }

        public List<Pollutant<?>> getTargetPollutants() {
            ItemStack material = this.getFilterMaterial();
            if (material.func_190926_b()) {
                return Collections.emptyList();
            }
            return AdPother.getInstance().pollutants.getAll().stream().filter(pollutant -> pollutant.getFilterMaterials().contains(material)).collect(Collectors.toList());
        }

        protected Optional<AirPurifier> getAirPurifier() {
            return this.getFilter().map(filter -> filter.airPurifier);
        }

        protected Optional<WaterPurifier> getWaterPurifier() {
            return this.getFilter().map(filter -> filter.waterPurifier);
        }

        protected Optional<FilterFrame> getFilter() {
            Block block = this.func_195044_w().func_177230_c();
            return block instanceof FilterFrame ? Optional.of((FilterFrame)block) : Optional.empty();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return side == Direction.DOWN ? this.outputHolder.cast() : this.inputHolder.cast();
            }
            if (cap == CapabilityEnergy.ENERGY && this.energyStorage.isEnabled()) {
                return this.energyStorageHolder.cast();
            }
            return super.getCapability(cap, side);
        }

        public void readSharedData(CompoundNBT compound) {
            this.active = compound.func_74767_n("active");
            this.purifyingAir = compound.func_74767_n("purifyingAir");
            this.purifyingWater = compound.func_74767_n("purifyingWater");
            this.content.readFromNBT(compound);
            this.renderMaterial = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("RenderMaterial"));
            this.energyStorage.readFrom(compound);
        }

        public CompoundNBT writeSharedData(CompoundNBT compound) {
            compound.func_74757_a("active", this.active);
            compound.func_74757_a("purifyingAir", this.purifyingAir);
            compound.func_74757_a("purifyingWater", this.purifyingWater);
            this.content.writeToNBT(compound);
            compound.func_218657_a("RenderMaterial", (INBT)this.renderMaterial.serializeNBT());
            this.energyStorage.writeTo(compound);
            return compound;
        }
    }

    public static class Inventory
    extends TileInventory {
        public Inventory(TileEntity tile, int size) {
            super(tile, size);
        }

        public int getSlotLimit(int slot) {
            Block block = this.tile.func_195044_w().func_177230_c();
            return block instanceof FilterFrame ? ((FilterFrame)block).slotLimit : 0;
        }

        protected void onContentsChanged(int slot) {
            if (slot != 2) {
                this.tile.func_145831_w().func_205220_G_().func_205360_a(this.tile.func_174877_v(), (Object)this.tile.func_195044_w().func_177230_c(), 1);
            }
            super.onContentsChanged(slot);
        }
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        public int airPurifierEffectiveRadius = 1;
        public int airPurifierMaxRadius = 1;
        public int waterPurifierMaxRadius = 1;
        public Percentage waterPurifierEfficiency = Percentage.value((float)12.0f);
        public int slotLimit = 16;

        public static Properties<?> with(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
        }

        public T setBlockProps() {
            super.setBlockProps();
            this.blockProps.func_200948_a(1.5f, 30.0f).func_200944_c();
            return (T)((Object)((Properties)this.self));
        }

        public T airPurifier(int effectiveRadius, int maxRadius) {
            this.airPurifierEffectiveRadius = effectiveRadius;
            this.airPurifierMaxRadius = maxRadius;
            return (T)((Object)((Properties)this.self));
        }

        public T waterPurifier(int maxRadius, Percentage efficiency) {
            this.waterPurifierMaxRadius = maxRadius;
            this.waterPurifierEfficiency = efficiency;
            return (T)((Object)((Properties)this.self));
        }

        public T slotLimit(int slotLimit) {
            this.slotLimit = slotLimit;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static enum Condition implements IForgeEnum
    {
        CLEAN,
        DIRTY;

    }
}

