/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.DimensionId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.config.BlockStates;
import com.endertech.minecraft.mods.adpother.config.FilterMaterials;
import com.endertech.minecraft.mods.adpother.config.ImmuneEntities;
import com.endertech.minecraft.mods.adpother.config.NegativeEffects;
import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public abstract class Pollutant<E extends AbstractCarrier>
extends ForgeBlock
implements IPollutant,
IPostInit {
    public static ImmuneEntities globalImmuneEntities;
    public static final EnumProperty<Density> DENSITY;
    public static final IntBounds INITIAL_AMOUNT_BOUNDS;
    protected static final int MIN_HORIZ_SPREAD_DENSITY_DELTA = 2;
    private final List<MultiConfigProperty.BaseProperty<BiomeId, ?>> biomeProperties = new ArrayList();
    protected final Class<E> entityClass;
    protected final NegativeEffects negativeEffects;
    protected final FilterMaterials filterMaterials;
    private final MultiConfigProperty.IntProperty<BiomeId> criticalAmount;
    private final MultiConfigProperty.IntProperty<BiomeId> concentrationAltitude;
    private final MultiConfigProperty.FloatProperty<BiomeId> motionVelocity;
    private final MultiConfigProperty.FloatProperty<BiomeId> emissionRate;
    private final MultiConfigProperty.BoolProperty<BiomeId> canAffectGrass;
    private final MultiConfigProperty.BoolProperty<BiomeId> canAffectLeaves;
    private final MultiConfigProperty.BoolProperty<BiomeId> canAffectPlants;
    private final boolean canSpreadAround = true;
    private final boolean canSpreadOverLedge = true;
    private final ColorARGB color;
    private final TextFormatting textColor;
    private final CommonCollect.BlackWhiteList<DimensionId> dimensions;
    protected final BlockStates passableBlocks;
    protected final BlockStates immuneBlocks;
    protected final ImmuneEntities immuneEntities;

    public Pollutant(ForgeMod mod, UnitConfig config, Properties<?> props, Class<E> entityClass) {
        super(mod, config, props);
        this.entityClass = entityClass;
        String category = this.getUnitCategory();
        this.filterMaterials = new FilterMaterials(config, category);
        this.negativeEffects = new NegativeEffects(config, category);
        this.criticalAmount = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"criticalAmount", (int)props.criticalAmount, (IntBounds)GameBounds.POLLUTION.getIntBounds(), (String)"Defines the amount of pollution at which all negative effects will be maximized.");
        this.concentrationAltitude = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"concentrationAltitude", (int)props.concentrationAltitude, (IntBounds)WorldData.altitudeBounds.extend(Integer.valueOf(1)), (String)"Defines the altitude which pollutant blocks will concentrate at.");
        this.motionVelocity = MultiConfigProperty.FloatProperty.from((UnitConfig)config, (String)category, (String)"motionVelocity", (float)props.motionVelocity, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Defines motion velocity of the pollutant.");
        this.emissionRate = MultiConfigProperty.FloatProperty.from((UnitConfig)config, (String)category, (String)"emissionRate", (float)1.0f, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Defines emission rate for this pollutant.");
        this.canAffectGrass = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"canAffectGrass", (boolean)true, (String)"Defines the ability to influence grass.");
        this.canAffectLeaves = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"canAffectLeaves", (boolean)true, (String)"Defines the ability to influence leaves.");
        this.canAffectPlants = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"canAffectPlants", (boolean)true, (String)"Defines the ability to influence plants.");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.criticalAmount, this.concentrationAltitude, this.motionVelocity, this.emissionRate, this.canAffectPlants, this.canAffectGrass, this.canAffectLeaves});
        ColorARGB colorARGB = ColorARGB.from((int)props.material.func_151565_r().field_76291_p).maxOpaque();
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)category, (String)"color", (ColorARGB)colorARGB, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)\n Affects smog and sky colors.");
        this.textColor = Optional.ofNullable(TextFormatting.func_96300_b((String)UnitConfig.getStr((UnitConfig)config, (String)category, (String)"textColor", (String)props.textColor.func_96297_d(), (String)"Defines the text color for the name of this pollutant."))).orElse(TextFormatting.WHITE);
        List black = Dimensions.readFrom((UnitConfig)config, (String)category, (String)"dimensionBlackList", (String)"Defines a list of dimensions in which this pollutant will not be generated.", (String[])new String[0]);
        List white = Dimensions.readFrom((UnitConfig)config, (String)category, (String)"dimensionWhiteList", (String)"If this list is set, the pollutant will be generated ONLY in listed dimensions, others will be ignored.", (String[])new String[0]);
        this.dimensions = new CommonCollect.BlackWhiteList(black, white);
        this.immuneEntities = new ImmuneEntities(config, category, "List of entities immune to this pollutant.");
        this.passableBlocks = new BlockStates(config, category, "passableBlocks", new String[]{"#minecraft:carpets", "#minecraft:trapdoors"}, "List of blocks which this pollutant can pass through.");
        this.immuneBlocks = new BlockStates(config, category, "immuneBlocks", new String[]{"ic2:te:*"}, "List of blocks completely immune to this pollutant.");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(DENSITY, (Comparable)((Object)Density.LIGHT)));
    }

    public String getClassRegName() {
        return "";
    }

    public void onPostInit() {
        this.passableBlocks.loadData();
        this.immuneBlocks.loadData();
        this.immuneEntities.loadData();
        this.filterMaterials.loadData();
        this.negativeEffects.loadData();
        this.saveConfig();
    }

    public boolean inAllowableDimension(World world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)DimensionId.from((World)world));
    }

    public Optional<Direction> getMotionFacing(World world, BlockPos pos) {
        int altitude = this.getConcentrationAltitudeIn(BiomeId.from((IWorld)world, (BlockPos)pos));
        if (pos.func_177956_o() == altitude) {
            return Optional.empty();
        }
        return Optional.of(pos.func_177956_o() < altitude ? Direction.UP : Direction.DOWN);
    }

    public IntBounds getAltitudeBounds() {
        return WorldData.altitudeBounds;
    }

    public NegativeEffects getNegativeEffects() {
        return this.negativeEffects;
    }

    public Set<BlockState> getPassableBlocks() {
        return this.passableBlocks.getValues();
    }

    public boolean push(IWorld world, BlockPos pos, Direction facing) {
        return this.pump(world, pos.func_177972_a(facing)) && this.spend(world, pos);
    }

    public boolean pump(IWorld world, BlockPos pos) {
        return this.pump(world, pos, 1) == 1;
    }

    public int pump(IWorld world, BlockPos pos, int amount) {
        int count;
        BlockState state = world.func_180495_p(pos);
        for (count = 0; count < amount && this.canStateBePumped(state); ++count) {
            state = this.getPumpedState(state);
        }
        if (count > 0) {
            world.func_180501_a(pos, state, 3);
        }
        return count;
    }

    public int spend(IWorld world, BlockPos pos, int amount) {
        int count;
        BlockState state = world.func_180495_p(pos);
        for (count = 0; count < amount && this.canStateBeSpreaded(state); ++count) {
            state = this.getSpreadedState(state);
        }
        if (count > 0) {
            world.func_180501_a(pos, state, 3);
        }
        return count;
    }

    public boolean spend(IWorld world, BlockPos pos) {
        return this.spend(world, pos, 1) == 1;
    }

    public int pumpEntitiesAt(IWorld world, BlockPos pos, int amount) {
        AbstractCarrier entity;
        int count = 0;
        if (count >= amount || !this.isServerSide((IWorldReader)world)) {
            return count;
        }
        List<AbstractCarrier> foundCarriers = this.getPollutantCarriersAt((IEntityReader)world, pos);
        if (foundCarriers.isEmpty() && (entity = (AbstractCarrier)this.spawnEntity(world, pos).orElse(null)) != null && entity.func_70089_S()) {
            if (++count >= amount) {
                return count;
            }
            foundCarriers.add(entity);
        }
        for (AbstractCarrier carrier : foundCarriers) {
            if (!carrier.carriesSameBlock(Optional.of(this))) continue;
            while (carrier.pump()) {
                if (++count < amount) continue;
                return count;
            }
        }
        return count;
    }

    public void scheduleUpdate(World world, BlockPos pos) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, this.getTickDelay(world, pos));
    }

    public void explodeBlock(World world, BlockPos pos, float explosionSize) {
        if (world instanceof ServerWorld) {
            BlockState state = world.func_180495_p(pos);
            boolean dropAsItem = !state.func_200015_d((IBlockReader)world, pos);
            GameWorld.scheduleBlockExplosion((ServerWorld)((ServerWorld)world), (BlockPos)pos, (CommonTime.Interval)CommonTime.Interval.ZERO, (float)explosionSize, (boolean)true, (Explosion.Mode)Explosion.Mode.BREAK, (boolean)dropAsItem, null);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (this.getCarriedPollutionAmount(state) <= 0) {
            return;
        }
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        boolean spreaded = false;
        Optional<Direction> motionFacing = this.getMotionFacing((World)world, pos);
        if (motionFacing.isPresent()) {
            Direction output;
            BlockPos nextPos = pos.func_177972_a(motionFacing.get());
            BlockPos nextPos2 = pos.func_177967_a(motionFacing.get(), 2);
            Direction input = motionFacing.get().func_176734_d();
            if (this.canPassThrough((IWorldReader)world, nextPos, input, output = motionFacing.get()) && this.canPassThrough((IWorldReader)world, nextPos2, input, output)) {
                if (WorldData.getData((World)world).getPollutantCarrierLimiter().canSpawnAt((World)world, nextPos)) {
                    int count = this.pumpEntitiesAt((IWorld)world, nextPos, this.getCarriedPollutionAmount(state));
                    spreaded = count > 0 && this.spend((IWorld)world, pos, count) == count;
                } else {
                    this.scheduleUpdate((World)world, pos);
                    return;
                }
            }
        }
        if (!spreaded) {
            world.func_217381_Z().func_76320_a("pollutantSpreading");
            spreaded = this.spread(world, pos, state);
            world.func_217381_Z().func_76319_b();
        }
        if (!spreaded) {
            for (Direction direction : GameWorld.Directions.of().all().shuffle().toArray()) {
                BlockState newState = this.affectBlockAt(world, pos.func_177972_a(direction), Optional.of(direction.func_176734_d()), true, state);
                if (newState == state) continue;
                world.func_175656_a(pos, newState);
                state = newState;
                if (!GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) {
                    this.scheduleUpdate((World)world, pos);
                }
                return;
            }
        }
    }

    protected boolean spread(ServerWorld world, BlockPos pos, BlockState state) {
        Spread spread = this.createSpread(world, pos, state);
        spread.inMotionFacing().overLedge().around(2).apply();
        return spread.completed();
    }

    public Spread createSpread(ServerWorld world, BlockPos pos, BlockState state) {
        return Spread.from((World)world, pos, state, this);
    }

    public boolean canStateBePumped(BlockState state) {
        return state.func_196958_f() || this.isSamePollutant(state) && ((Density)((Object)state.func_177229_b(DENSITY))).canAbsorb();
    }

    public boolean canStateBeSpreaded(BlockState state) {
        return this.getCarriedPollutionAmount(state) > 0;
    }

    public BlockState getPumpedState(BlockState state) {
        if (state.func_196958_f()) {
            return this.func_176223_P();
        }
        Density density = (Density)((Object)state.func_177229_b(DENSITY));
        return (BlockState)state.func_206870_a(DENSITY, (Comparable)((Object)density.getPumped()));
    }

    public BlockState getSpreadedState(BlockState state) {
        Density density = (Density)((Object)state.func_177229_b(DENSITY));
        return density.canSpread() ? (BlockState)state.func_206870_a(DENSITY, (Comparable)((Object)density.getSpreaded())) : Blocks.field_150350_a.func_176223_P();
    }

    public abstract int emitFrom(TileEntity var1, Set<BlockState> var2, int var3);

    public int generateAt(World world, BlockPos startPos, int amount, int maximumRadius) {
        int count = 0;
        int capacity = this.getPollutionCapacity();
        for (int maxRadius = 0; maxRadius <= maximumRadius && count < amount; ++maxRadius) {
            for (int vertOffset = 0; vertOffset <= maxRadius; ++vertOffset) {
                for (BlockPos planePos : new BlockPos[]{startPos.func_177981_b(vertOffset), startPos.func_177979_c(vertOffset)}) {
                    int rmax = maxRadius - vertOffset;
                    int rmin = rmax - capacity + 1;
                    if (rmin < 0) {
                        rmin = 0;
                    }
                    if (rmax < 0 || !this.getAltitudeBounds().encloses(Integer.valueOf(planePos.func_177956_o()))) continue;
                    for (int radius = rmin; radius <= rmax; ++radius) {
                        List posList = GameWorld.Positions.getAroundHoriz((BlockPos)planePos, (int)radius, (boolean)false);
                        Collections.shuffle(posList);
                        for (BlockPos pos : posList) {
                            if (world.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
                                pos = pos.func_177984_a();
                            }
                            count += this.pump((IWorld)world, pos, amount - count);
                        }
                        if (count < amount) continue;
                        return count;
                    }
                }
            }
        }
        return count;
    }

    protected boolean setPollutantBlock(World world, BlockPos pos) {
        return world.func_175656_a(pos, this.func_176223_P());
    }

    protected abstract E createEntityPollutant(ServerWorld var1, BlockPos var2, BlockState var3);

    protected Optional<E> spawnEntity(IWorld world, BlockPos pos) {
        return this.spawnEntity(world, pos, this.func_176223_P());
    }

    protected Optional<E> spawnEntity(IWorld world, BlockPos pos, BlockState carriedState) {
        if (world instanceof ServerWorld) {
            E entity = this.createEntityPollutant((ServerWorld)world, pos, carriedState);
            if (world.func_217376_c(entity)) {
                return Optional.of(entity);
            }
            entity.func_70106_y();
        } else {
            AdPother.getInstance().getLogger().error("Attempt to spawn pollutant on client!");
        }
        return Optional.empty();
    }

    public boolean isSamePollutant(BlockState state) {
        return state.func_177230_c() == this;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DENSITY});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return this.isSamePollutant(adjacentBlockState) && this.getCarriedPollutionAmount(state) == this.getCarriedPollutionAmount(adjacentBlockState);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world instanceof ServerWorld) {
            WorldData.getChunkPollution(world, pos).increaseBy((ServerWorld)world, pos, state, 1);
            this.scheduleUpdate(world, pos);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (world instanceof ServerWorld) {
            WorldData.getChunkPollution(world, pos).increaseBy((ServerWorld)world, pos, state, -1);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.scheduleUpdate(world, pos);
    }

    public int getTickDelay(World world, BlockPos pos) {
        return CommonMath.Random.between((int)20, (int)120);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return state.func_177229_b(DENSITY) != Density.HEAVY;
    }

    public int getCarriedPollutionAmount(BlockState state) {
        if (this.isSamePollutant(state)) {
            Density density = (Density)((Object)state.func_177229_b(DENSITY));
            return density.ordinal() + 1;
        }
        return 0;
    }

    public int getPollutionCapacity() {
        return Density.values().length;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public boolean canAffectEntity(Entity entity, boolean directContact) {
        if (globalImmuneEntities.contain(entity)) {
            return !globalImmuneEntities.isImmune(entity);
        }
        if (this.immuneEntities.contain(entity)) {
            return !this.immuneEntities.isImmune(entity);
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            return !player.func_175149_v() && !player.func_184812_l_();
        }
        return entity instanceof LivingEntity;
    }

    public abstract BlockState affectBlockAt(ServerWorld var1, BlockPos var2, Optional<Direction> var3, boolean var4, BlockState var5);

    public List<E> getPollutantCarriersAt(IEntityReader reader, BlockPos pos) {
        return reader.func_217357_a(this.entityClass, FULL_BLOCK_AABB.func_186670_a(pos));
    }

    public Map<ItemStack, IStorageItem> getProtectiveItems(LivingEntity living) {
        return Collections.emptyMap();
    }

    public TextFormatting getTextColor() {
        return this.textColor;
    }

    public int getCriticalAmountIn(BiomeId biome) {
        return (Integer)this.criticalAmount.get((Object)biome);
    }

    public int getConcentrationAltitudeIn(BiomeId biome) {
        return (Integer)this.concentrationAltitude.get((Object)biome);
    }

    public float getMotionVelocityIn(BiomeId biome) {
        return ((Float)this.motionVelocity.get((Object)biome)).floatValue();
    }

    public List<MultiConfigProperty.BaseProperty<BiomeId, ?>> getBiomeProperties() {
        return Collections.unmodifiableList(this.biomeProperties);
    }

    public float getEmissionRateIn(BiomeId biome) {
        return ((Float)this.emissionRate.get((Object)biome)).floatValue();
    }

    public FilterMaterials getFilterMaterials() {
        return this.filterMaterials;
    }

    public boolean canAffectGrassIn(BiomeId biome) {
        return (Boolean)this.canAffectGrass.get((Object)biome);
    }

    public boolean canAffectLeavesIn(BiomeId biome) {
        return (Boolean)this.canAffectLeaves.get((Object)biome);
    }

    public boolean canAffectPlantsIn(BiomeId biome) {
        return (Boolean)this.canAffectPlants.get((Object)biome);
    }

    public boolean canSpreadOverLedge() {
        return true;
    }

    public boolean canSpreadAround() {
        return true;
    }

    @SafeVarargs
    protected final void addBiomeIdProperties(MultiConfigProperty.BaseProperty<BiomeId, ?> ... properties) {
        for (MultiConfigProperty.BaseProperty<BiomeId, ?> prop : properties) {
            this.biomeProperties.add(prop);
        }
    }

    public BlockType getBlockType(IBlockReader world, BlockPos pos, BlockState state) {
        if (this.immuneBlocks.getValues().contains(state)) {
            return BlockType.IMMUNE;
        }
        Block block = state.func_177230_c();
        if (block instanceof FilterFrame) {
            return BlockType.FILTER;
        }
        if (block instanceof GrassBlock) {
            return BlockType.GRASS_BLOCK;
        }
        if (block.func_235332_a_(Blocks.field_196804_gh)) {
            return BlockType.TALLGRASS;
        }
        if (block instanceof LeavesBlock) {
            return BlockType.LEAVES;
        }
        if (state.func_185904_a() == Material.field_151578_c) {
            return BlockType.SOIL;
        }
        if (state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            return BlockType.WATER;
        }
        if (block instanceof IGrowable || block instanceof IPlantable) {
            return BlockType.PLANT;
        }
        return BlockType.UNKNOWN;
    }

    protected boolean doBonemealEffect(ServerWorld worldIn, BlockPos pos, BlockState state) {
        IGrowable growable;
        Block block;
        ServerWorld world;
        if (worldIn instanceof ServerWorld && ForgeHooks.onCropsGrowPre((World)(world = worldIn), (BlockPos)pos, (BlockState)state, (boolean)true) && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof IGrowable && (growable = (IGrowable)block).func_176473_a((IBlockReader)world, pos, state, world.field_72995_K)) {
            growable.func_225535_a_(world, world.field_73012_v, pos, state);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
            return true;
        }
        return false;
    }

    static {
        DENSITY = Pollutant.createEnumProperty(Density.class);
        INITIAL_AMOUNT_BOUNDS = new IntBounds(Integer.valueOf(0), Integer.valueOf(256));
    }

    public static enum BlockType {
        CUSTOM,
        FILTER,
        GRASS_BLOCK,
        IMMUNE,
        LEAVES,
        PLANT,
        SOIL,
        TALLGRASS,
        WATER,
        UNKNOWN;

    }

    public static enum Density implements IForgeEnum
    {
        LIGHT,
        MEDIUM,
        HEAVY;


        public boolean canSpread() {
            return this.ordinal() > 0;
        }

        public boolean canAbsorb() {
            return this.ordinal() < Density.values().length - 1;
        }

        public Density getSpreaded() {
            return Density.values()[this.ordinal() - 1];
        }

        public Density getPumped() {
            return Density.values()[this.ordinal() + 1];
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        public TextFormatting textColor = TextFormatting.WHITE;
        public int criticalAmount = 0;
        public int concentrationAltitude = 0;
        public float motionVelocity = 0.0f;

        public static Properties<?> with(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
        }

        public T setBlockProps() {
            super.setBlockProps();
            this.blockProps.func_200944_c();
            return (T)((Object)((Properties)this.self));
        }

        public T textColor(TextFormatting color) {
            this.textColor = color;
            return (T)((Object)((Properties)this.self));
        }

        public T criticalAmount(int amount) {
            this.criticalAmount = amount;
            return (T)((Object)((Properties)this.self));
        }

        public T concentrationAltitude(int altitude) {
            this.concentrationAltitude = altitude;
            return (T)((Object)((Properties)this.self));
        }

        public T motionVelocity(float velocity) {
            this.motionVelocity = velocity;
            return (T)((Object)((Properties)this.self));
        }
    }
}

