/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PollutedWater
extends FlowingFluidBlock {
    public PollutedWater() {
        super(() -> AdPother.getInstance().fluids.pollutedWaterStill, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e());
    }

    public static boolean isPollutedWith(Pollutant<?> pollutant, IBlockReader world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof PollutedWater && ((PollutedWater)block).isPollutedWith(pollutant, state);
    }

    public static boolean isSource(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof PollutedWater && state.func_204520_s().func_206889_d();
    }

    public static Optional<Pollutant<?>> findPollutant(IBlockReader world, BlockPos pos, Collection<Pollutant<?>> pollutants) {
        BlockState state = world.func_180495_p(pos);
        for (Pollutant<?> pollutant : pollutants) {
            if (!PollutedWater.isPollutedWith(pollutant, world, pos, state)) continue;
            return Optional.of(pollutant);
        }
        return Optional.empty();
    }

    public boolean isPollutedWith(Pollutant<?> pollutant, BlockState state) {
        return pollutant == Pollutants.BuiltIn.SULFUR.get();
    }

    public boolean spreadFrom(IWorld world, BlockPos startPos) {
        BlockState blockstate = world.func_180495_p(startPos);
        FluidState fluidstate = blockstate.func_204520_s();
        if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && fluidstate.func_206889_d() && !(blockstate.func_177230_c() instanceof PollutedWater) && blockstate.func_177230_c() instanceof FlowingFluidBlock) {
            Integer level = (Integer)blockstate.func_177229_b((Property)field_176367_b);
            return world.func_180501_a(startPos, (BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176367_b, (Comparable)level), 3);
        }
        return false;
    }

    public static class FlowingFluid
    extends BaseFluid {
        public FlowingFluid(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.func_207183_f((FluidState)((FluidState)this.func_207182_e().func_177621_b()).func_206870_a((Property)field_207210_b, (Comparable)Integer.valueOf(7)));
            this.setRegistryName("polluted_water_flowing");
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState state) {
            return (Integer)state.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }

    public static class StillFluid
    extends BaseFluid {
        public StillFluid(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.setRegistryName("polluted_water_still");
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }

        public int func_207192_d(FluidState state) {
            return 8;
        }
    }

    public static abstract class BaseFluid
    extends ForgeFlowingFluid {
        protected BaseFluid(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean func_215665_a(FluidState state, IBlockReader world, BlockPos pos, Fluid fluid, Direction direction) {
            return super.func_215665_a(state, world, pos, fluid, direction);
        }

        protected void func_205574_a(IWorld worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
            super.func_205574_a(worldIn, pos, blockStateIn, direction, fluidStateIn);
        }

        protected boolean func_205570_b(IBlockReader worldIn, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluidIn) {
            return super.func_205570_b(worldIn, fromPos, fromBlockState, direction, toPos, toBlockState, toFluidState, fluidIn);
        }
    }
}

