/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.DynamicTrees;
import com.endertech.minecraft.mods.adpother.config.CustomReplacements;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class Sulfur
extends AbstractGas {
    protected final CustomReplacements customReplacements;
    private final MultiConfigProperty.FloatProperty<BiomeId> acidRainThreshold;

    public Sulfur(ForgeMod mod, UnitConfig config, String name) {
        super(mod, config, (AbstractGas.Properties)((Object)((Pollutant.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)AbstractGas.Properties.with(name, MaterialColor.field_151673_t).criticalAmount(512))).concentrationAltitude(127))).motionVelocity(0.15f))).absorbtionChance(40))).lowerExplosiveLimit(16))).textColor(TextFormatting.YELLOW)));
        String category = this.getUnitCategory();
        this.acidRainThreshold = MultiConfigProperty.FloatProperty.from((UnitConfig)config, (String)category, (String)"acidRainThreshold", (float)5.0f, (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Defines the minimum percentage of sulfur in a chunk to cause acid rain that affects soil and water.");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.acidRainThreshold});
        this.customReplacements = new CustomReplacements(config, category);
        this.customReplacements.addDefaultValues("minecraft:grass_block -> minecraft:podzol", "5% -> minecraft:stone -> minecraft:cobblestone");
        this.filterMaterials.addDefaultValues("#minecraft:wool, 8, #forge:dusts/sulfur");
        this.negativeEffects.addDirect(Effects.field_76436_u);
        this.negativeEffects.addGlobal(Effects.field_76436_u, Percentage.value((float)30.0f)).addGlobal(Effects.field_76440_q, Percentage.value((float)50.0f)).addGlobal(Effects.field_82731_v, Percentage.value((float)80.0f)).addHostile(Effects.field_76429_m, Percentage.value((float)30.0f)).addHostile(Effects.field_76424_c, Percentage.value((float)60.0f));
    }

    @Override
    public boolean canAffectEntity(Entity entity, boolean directContact) {
        if (directContact || this.isUnderRainOrStorm((IWorld)entity.field_70170_p, ForgeEntity.getPositionTop((Entity)entity))) {
            return super.canAffectEntity(entity, directContact);
        }
        return false;
    }

    @Override
    public Pollutant.BlockType getBlockType(IBlockReader world, BlockPos pos, BlockState state) {
        if (this.customReplacements.getReplacementFor(state).isPresent()) {
            return Pollutant.BlockType.CUSTOM;
        }
        return super.getBlockType(world, pos, state);
    }

    public boolean canAffectBlock(IWorld world, BlockPos pos, Optional<Direction> side, boolean directContact) {
        BlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
        switch (type) {
            case IMMUNE: 
            case UNKNOWN: {
                return false;
            }
            case GRASS_BLOCK: 
            case TALLGRASS: {
                if (this.canAffectGrassIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                return false;
            }
        }
        switch (type) {
            case TALLGRASS: 
            case FILTER: {
                return true;
            }
            case LEAVES: {
                return this.canAffectLeavesIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
            case PLANT: {
                return this.canAffectPlantsIn(BiomeId.from((IWorld)world, (BlockPos)pos));
            }
            case GRASS_BLOCK: 
            case WATER: 
            case CUSTOM: {
                if (directContact) {
                    return true;
                }
                if (!(world instanceof ServerWorld) || !this.shouldRainBeAcidAt((ServerWorld)world, pos)) break;
                Percentage percent = this.getPercentageAt((ServerWorld)world, pos);
                return percent.getValue() >= this.customReplacements.getThresholdFor(state).getValue();
            }
        }
        return false;
    }

    public boolean shouldRainBeAcidAt(ServerWorld world, BlockPos pos) {
        Percentage percent = this.getPercentageAt(world, pos);
        float threshold = this.getAcidRainThresholdIn(BiomeId.from((IWorld)world, (BlockPos)pos));
        return percent.getValue() >= threshold;
    }

    @Override
    public BlockState affectBlockAt(ServerWorld world, BlockPos pos, Optional<Direction> side, boolean directContact, BlockState sourceState) {
        if (this.isSamePollutant(sourceState) && this.canAffectBlock((IWorld)world, pos, side, directContact)) {
            BlockState state = world.func_180495_p(pos);
            Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
            switch (type) {
                case CUSTOM: {
                    Optional<BlockState> replacement = this.customReplacements.getReplacementFor(state);
                    if (!replacement.isPresent() || !world.func_175656_a(pos, replacement.get()) || !this.isAbsorbedIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                    return this.getSpreadedState(sourceState);
                }
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case LEAVES: {
                    BlockPos targetPos = DynamicTrees.findBranchUnderLeaves(world, pos).orElse(pos);
                    world.func_217377_a(targetPos, false);
                    break;
                }
                case TALLGRASS: 
                case PLANT: {
                    world.func_217377_a(pos, false);
                    break;
                }
                case WATER: {
                    if (!AdPother.getInstance().blocks.pollutedWater.spreadFrom((IWorld)world, pos)) break;
                    return this.getSpreadedState(sourceState);
                }
            }
        }
        return sourceState;
    }

    public float getAcidRainThresholdIn(BiomeId biome) {
        return ((Float)this.acidRainThreshold.get((Object)biome)).floatValue();
    }

    @Override
    public void onPostInit() {
        this.customReplacements.loadData();
        super.onPostInit();
    }
}

