/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.DynamicTrees;
import com.endertech.minecraft.mods.adpother.config.CustomReplacements;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class UserGas
extends AbstractGas {
    protected final CustomReplacements customReplacements;
    protected final MultiConfigProperty.BoolProperty<BiomeId> doesBonemealEffect;

    public UserGas(ForgeMod mod, UnitConfig config, AbstractGas.Properties<?> props) {
        super(mod, config, props);
        String category = this.getUnitCategory();
        this.customReplacements = new CustomReplacements(config, category);
        this.doesBonemealEffect = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"doesBonemealEffect", (boolean)false, (String)"Defines the ability to do the bone meal effect on plants and crops.");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.doesBonemealEffect});
    }

    @Override
    public Pollutant.BlockType getBlockType(IBlockReader world, BlockPos pos, BlockState state) {
        if (this.customReplacements.getReplacementFor(state).isPresent()) {
            return Pollutant.BlockType.CUSTOM;
        }
        return super.getBlockType(world, pos, state);
    }

    public boolean canAffectBlock(IWorld world, BlockPos pos, Optional<Direction> side, boolean directContact) {
        BlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
        switch (type) {
            case IMMUNE: 
            case UNKNOWN: {
                return false;
            }
            case GRASS_BLOCK: 
            case TALLGRASS: {
                if (this.canAffectGrassIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                return false;
            }
            case LEAVES: {
                if (this.canAffectLeavesIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                return false;
            }
            case PLANT: {
                if (this.canAffectPlantsIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                return false;
            }
        }
        switch (type) {
            case FILTER: {
                return true;
            }
            case GRASS_BLOCK: 
            case TALLGRASS: 
            case LEAVES: 
            case PLANT: {
                if (directContact) {
                    return true;
                }
                if (this.doesBonemealEffectIn(BiomeId.from((IWorld)world, (BlockPos)pos))) {
                    return true;
                }
                if (this.isUnderRainOrStorm(world, pos)) {
                    return true;
                }
            }
            case CUSTOM: {
                if (directContact) {
                    return true;
                }
                if (!(world instanceof ServerWorld) || !this.isUnderRainOrStorm(world, pos)) break;
                Percentage percent = this.getPercentageAt((ServerWorld)world, pos);
                return percent.getValue() >= this.customReplacements.getThresholdFor(state).getValue();
            }
        }
        return false;
    }

    @Override
    public BlockState affectBlockAt(ServerWorld world, BlockPos pos, Optional<Direction> side, boolean directContact, BlockState sourceState) {
        if (this.isSamePollutant(sourceState) && this.canAffectBlock((IWorld)world, pos, side, directContact)) {
            BlockState state = world.func_180495_p(pos);
            Pollutant.BlockType type = this.getBlockType((IBlockReader)world, pos, state);
            switch (type) {
                case CUSTOM: {
                    Optional<BlockState> replacement = this.customReplacements.getReplacementFor(state);
                    if (!replacement.isPresent() || !world.func_175656_a(pos, replacement.get()) || !this.isAbsorbedIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                    return this.getSpreadedState(sourceState);
                }
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case LEAVES: {
                    if (this.doesBonemealEffectIn(BiomeId.from((IWorld)world, (BlockPos)pos))) {
                        DynamicTrees.pulseGrow(world, pos, state);
                        if (!this.isAbsorbedIn(BiomeId.from((IWorld)world, (BlockPos)pos))) break;
                        return this.getSpreadedState(sourceState);
                    }
                    BlockPos targetPos = DynamicTrees.findBranchUnderLeaves(world, pos).orElse(pos);
                    world.func_217377_a(targetPos, false);
                    break;
                }
                case GRASS_BLOCK: {
                    if (!this.doesBonemealEffectIn(BiomeId.from((IWorld)world, (BlockPos)pos)) || !this.doBonemealEffect(world, pos, state)) break;
                    return this.getSpreadedState(sourceState);
                }
                case TALLGRASS: 
                case PLANT: {
                    if (this.doesBonemealEffectIn(BiomeId.from((IWorld)world, (BlockPos)pos))) {
                        if (!this.doBonemealEffect(world, pos, state)) break;
                        return this.getSpreadedState(sourceState);
                    }
                    world.func_217377_a(pos, false);
                    break;
                }
            }
        }
        return sourceState;
    }

    @Override
    protected BlockState affectUnderlyingBlock(ServerWorld world, BlockPos sourcePos, BlockState sourceState) {
        if (this.doesBonemealEffectIn(BiomeId.from((IWorld)world, (BlockPos)sourcePos))) {
            BlockPos targetPos = this.getFirstUnderlyingBlock((IWorldReader)world, sourcePos);
            return this.affectBlockAt(world, targetPos, Optional.of(Direction.UP), false, sourceState);
        }
        return super.affectUnderlyingBlock(world, sourcePos, sourceState);
    }

    public boolean doesBonemealEffectIn(BiomeId biome) {
        return (Boolean)this.doesBonemealEffect.get((Object)biome);
    }

    @Override
    public void onPostInit() {
        this.customReplacements.loadData();
        super.onPostInit();
    }
}

