/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class Minecraft {

    public static class Campfire
    extends Emitter {
        public static float rate = 1.0f;

        public Campfire(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        public void emitAt(World world, BlockPos pos) {
            this.emitAt(world, pos, rate);
        }
    }

    public static class Fire
    extends Emitter {
        private final boolean infiniteSourceOnly;

        public Fire(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
            this.infiniteSourceOnly = UnitConfig.getBool((UnitConfig)config, (String)this.getClassCategory(), (String)"infiniteSourceOnly", (boolean)false, (String)"Produce emissions only from a burning infinite source such as netherrack, magma block, etc.");
            this.saveConfig();
        }

        public boolean infiniteSourceOnly() {
            return this.infiniteSourceOnly;
        }

        public boolean isActive(IWorldReader world, BlockPos pos) {
            BlockPos sourcePos;
            BlockState state;
            Block block;
            boolean infiniteSource;
            if (this.infiniteSourceOnly() && !(infiniteSource = (block = (state = world.func_180495_p(sourcePos = pos.func_177977_b())).func_177230_c()).isFireSource(state, world, sourcePos, Direction.UP))) {
                return false;
            }
            return super.isActive(world, pos);
        }
    }
}

