/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;

public class CustomReplacements
extends AbstractParsableList {
    protected final BlockStatesMap<Replacement> replacements = new BlockStatesMap();

    public CustomReplacements(UnitConfig config, String category) {
        super(config, category, "customReplacements", new String[0]);
    }

    @Override
    protected String getComment() {
        return "List of blocks which this pollutant can replace.\nFormat: pollutionThreshold% -> targetID -> replacementID\nExample: 10% -> minecraft:sand -> minecraft:gravel";
    }

    @Override
    protected void parseConfigValues() {
        this.replacements.clear();
        for (String string : this.configValues) {
            boolean error;
            List<String> split = this.split(string, "->");
            if (split.size() == 2) {
                split.add(0, "0%");
            }
            boolean bl = error = split.size() < 3;
            if (!error) {
                UnitId source = UnitId.from((String)split.get(1));
                UnitId dest = UnitId.from((String)split.get(2));
                boolean bl2 = error = source.isEmpty() || dest.isEmpty();
                if (!error) {
                    Percentage threshold = null;
                    BlockState replacement = null;
                    try {
                        threshold = Percentage.parse((String)split.get(0));
                        replacement = dest.getFirstMatchedState();
                    }
                    catch (Exception e) {
                        error = true;
                    }
                    if (!error && replacement != null) {
                        this.replacements.put(source, (Object)new Replacement(replacement, threshold));
                    }
                }
            }
            if (!error) continue;
            this.logParsingError(string);
        }
    }

    public Optional<BlockState> getReplacementFor(BlockState state) {
        return Optional.ofNullable((Replacement)this.replacements.get((Object)state)).map(rep -> rep.blockstate);
    }

    public Percentage getThresholdFor(BlockState state) {
        return Optional.ofNullable((Replacement)this.replacements.get((Object)state)).map(rep -> rep.threshold).orElse(Percentage.ZERO);
    }

    protected class Replacement {
        public final BlockState blockstate;
        public final Percentage threshold;

        public Replacement(BlockState blockstate, Percentage threshold) {
            this.blockstate = blockstate;
            this.threshold = threshold;
        }
    }
}

