/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class ImmuneEntities
extends AbstractParsableList {
    public static final String FORMAT_DESCRIPTION = "Format: entityId [, immunityPercentage%]\nExample: minecraft:zombie_pigman, 99%\nGives complete immunity if the percentage omitted.";
    protected final Map<EntityType<?>, Percentage> entities = new HashMap();
    protected final String comment;

    public ImmuneEntities(UnitConfig config, String category, String comment) {
        super(config, category, "immuneEntities", new String[0]);
        this.comment = comment;
    }

    @Override
    protected String getComment() {
        return this.comment + "\n" + FORMAT_DESCRIPTION;
    }

    @Override
    protected void parseConfigValues() {
        this.entities.clear();
        for (String string : this.configValues) {
            List<String> split = this.splitArgs(string);
            UnitId id = UnitId.from((String)split.get(0));
            Percentage immunity = Percentage.HUNDRED;
            boolean error = id.isEmpty();
            if (split.size() > 1) {
                try {
                    immunity = Percentage.parse((String)split.get(1));
                }
                catch (Exception e) {
                    error = true;
                }
            }
            if (!error) {
                EntityType type;
                if (!ForgeMod.isLoaded((String)id.getModId()) || (type = (EntityType)ForgeRegistries.ENTITIES.getValue(id.toResLoc())) == null) continue;
                this.entities.put(type, immunity);
                continue;
            }
            this.logParsingError(string);
        }
    }

    public boolean contain(Entity entity) {
        return this.entities.containsKey(entity.func_200600_R());
    }

    public Percentage getImmunityFor(Entity entity) {
        return this.entities.getOrDefault(entity.func_200600_R(), Percentage.ZERO);
    }

    public boolean isImmune(Entity entity) {
        return this.getImmunityFor(entity).takeChance();
    }

    public ImmuneEntities loadEntities() {
        this.loadData();
        return this;
    }
}

