/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.common.Args;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import com.endertech.minecraft.mods.adpother.config.IReloadableData;
import com.endertech.minecraft.mods.adpother.events.EntityEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class NegativeEffects
implements IReloadableData {
    protected int duration = (int)GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.seconds((double)5.0));
    protected final Direct direct;
    protected final Global global;
    protected final Hostile hostile;

    public NegativeEffects(UnitConfig config, String category) {
        category = IHaveConfig.expandClassCategory(this.getClass(), (String)category);
        this.direct = new Direct(config, category, "direct");
        this.global = new Global(config, category, "global");
        this.hostile = new Hostile(config, category, "hostile");
    }

    public NegativeEffects addDirect(Effect effect) {
        this.direct.addDefaultValues(effect.getRegistryName().toString());
        return this;
    }

    public NegativeEffects addGlobal(Effect effect, Percentage threshold) {
        this.global.addDefaultValues(Args.join((Object[])new Object[]{effect.getRegistryName().toString(), threshold.toString()}));
        return this;
    }

    public NegativeEffects addHostile(Effect effect, Percentage threshold) {
        this.hostile.addDefaultValues(Args.join((Object[])new Object[]{effect.getRegistryName().toString(), threshold.toString()}));
        return this;
    }

    public void updateDirectOn(LivingEntity living, int amplifier) {
        if (!ForgeEntity.isServerSide((Entity)living)) {
            return;
        }
        if (this.isHostileMob(living)) {
            return;
        }
        for (Effect effect : this.direct.effects) {
            living.func_195064_c(new EffectInstance(effect, this.duration, amplifier));
        }
    }

    public void updateGlobalOn(LivingEntity living, Percentage pollution) {
        if (!ForgeEntity.isServerSide((Entity)living)) {
            return;
        }
        Map<Effect, Percentage> effects = this.isHostileMob(living) ? this.hostile.effects : this.global.effects;
        for (Map.Entry<Effect, Percentage> entry : effects.entrySet()) {
            Effect effect = entry.getKey();
            Percentage threshold = entry.getValue();
            this.addEffectOn(living, effect, this.duration, pollution, threshold);
        }
    }

    public void addEffectOn(LivingEntity living, Effect effect, int duration, Percentage pollution, Percentage threshold) {
        if (threshold.getValue() > 0.0f && pollution.getValue() >= threshold.getValue()) {
            int amplifier = 0;
            amplifier = MathHelper.func_76141_d((float)(pollution.getValue() / threshold.getValue())) - 1;
            if (amplifier < 0) {
                amplifier = 0;
            }
            living.func_195064_c(new EffectInstance(effect, duration, amplifier));
        }
    }

    protected boolean isHostileMob(LivingEntity living) {
        return EntityEvents.isHostileMob(living);
    }

    @Override
    public void loadData() {
        this.direct.loadData();
        this.global.loadData();
        this.hostile.loadData();
    }

    protected class Hostile
    extends Global {
        public Hostile(UnitConfig config, String category, String key) {
            super(config, category, key);
        }

        @Override
        protected String getComment() {
            return "Effects on hostile mobs.\nFormat: potionID, pollutionThreshold%\n";
        }
    }

    protected class Global
    extends AbstractParsableList {
        protected final Map<Effect, Percentage> effects;

        public Global(UnitConfig config, String category, String key) {
            super(config, category, key, new String[0]);
            this.effects = new HashMap<Effect, Percentage>();
        }

        @Override
        protected String getComment() {
            return "Global effects (within the surrounding chunks).\nFormat: potionID, pollutionThreshold%\nPollution threshold is the minimum percentage of pollution to cause this effect.";
        }

        @Override
        protected void parseConfigValues() {
            this.effects.clear();
            for (String string : this.configValues) {
                List<String> split = this.splitArgs(string);
                UnitId id = UnitId.from((String)split.get(0));
                Percentage threshold = Percentage.HUNDRED;
                boolean error = id.isEmpty();
                if (split.size() > 1) {
                    try {
                        threshold = Percentage.parse((String)split.get(1));
                    }
                    catch (Exception e) {
                        error = true;
                    }
                }
                if (!error) {
                    Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(id.toResLoc());
                    if (effect == null) continue;
                    this.effects.put(effect, threshold);
                    continue;
                }
                this.logParsingError(string);
            }
        }
    }

    protected class Direct
    extends AbstractParsableList {
        protected final List<Effect> effects;

        public Direct(UnitConfig config, String category, String key) {
            super(config, category, key, new String[0]);
            this.effects = new ArrayList<Effect>();
        }

        @Override
        protected String getComment() {
            return "Direct contact effects.";
        }

        @Override
        protected void parseConfigValues() {
            this.effects.clear();
            for (String string : this.configValues) {
                UnitId id = UnitId.from((String)string);
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(id.toResLoc());
                if (effect == null) continue;
                this.effects.add(effect);
            }
        }
    }
}

