/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DelayedTileEmission
extends AbstractEntityEmission<TileEntity, Emitter> {
    protected final Map<Pollutant<?>, Integer> amounts = new HashMap();
    protected int fails = 0;
    protected int emits = 0;

    protected DelayedTileEmission(TileEntity tile, Emitter emitter, GameTime updateInterval) {
        super(tile, emitter, updateInterval);
    }

    public static DelayedTileEmission of(TileEntity tile, Emitter emitter, Pollutant<?> pollutant, int amount) {
        return new DelayedTileEmission(tile, emitter, GameTime.seconds((int)3)).add(pollutant, amount);
    }

    public DelayedTileEmission add(Pollutant<?> pollutant, int amount) {
        Integer old = this.getAmountOf(pollutant);
        this.amounts.put(pollutant, old + amount);
        this.checkAmountOf(pollutant);
        return this;
    }

    protected void checkAmountOf(Pollutant<?> pollutant) {
        if (this.getAmountOf(pollutant) <= 0) {
            this.amounts.remove(pollutant);
        }
    }

    public int getAmountOf(Pollutant<?> pollutant) {
        Integer amount = this.amounts.get(pollutant);
        return amount != null ? amount : 0;
    }

    public int emit(Pollutant<?> pollutant, int amount) {
        BlockPos pos = ((TileEntity)this.getEntity()).func_174877_v();
        TileEntity tile = this.getWorld().func_175625_s(pos);
        if (!((TileEntity)this.getEntity()).equals(tile) || !this.getWorld().isAreaLoaded(pos, 1)) {
            this.kill();
            return 0;
        }
        return pollutant.emitFrom((TileEntity)this.getEntity(), ((Emitter)((Object)this.getEmitter())).getRelatedBlocks(), amount);
    }

    public int getPollutantsNumber() {
        return this.amounts.keySet().size();
    }

    @Nullable
    public Pollutant<?> pickPollutant() {
        int chosen = CommonMath.Random.between((int)0, (int)(this.getPollutantsNumber() - 1));
        int i = 0;
        for (Pollutant<?> pollutant : this.amounts.keySet()) {
            if (i < chosen) {
                ++i;
                continue;
            }
            if (i != chosen) break;
            return pollutant;
        }
        return null;
    }

    public void onUpdate() {
        if (this.getPollutantsNumber() <= 0) {
            this.kill();
            return;
        }
        if (this.fails < 0) {
            this.fails = 0;
        }
        World world = this.getWorld();
        Pollutant<?> pollutant = this.pickPollutant();
        if (world == null || pollutant == null) {
            this.kill();
            return;
        }
        this.checkAmountOf(pollutant);
        int maxPressure = pollutant.getPollutionCapacity();
        int amount = Math.min(this.getAmountOf(pollutant), maxPressure);
        if (amount <= 0) {
            this.kill();
            return;
        }
        if (this.fails > maxPressure) {
            pollutant.explodeBlock(world, ((TileEntity)this.getEntity()).func_174877_v(), amount);
            this.kill();
            return;
        }
        int count = this.emit(pollutant, amount);
        if (count > 0) {
            this.add(pollutant, -count);
            this.fails = 0;
        } else {
            ++this.fails;
        }
    }

    @Nullable
    public World getWorld() {
        return ((TileEntity)this.getEntity()).func_145831_w();
    }
}

