/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.minecraft.forge.entities.BlockStateCarrier;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractCarrier
extends BlockStateCarrier {
    public AbstractCarrier(EntityType<?> type, World world, BlockPos pos, BlockState carriedState) {
        super(type, world, pos, carriedState);
        if (world instanceof ServerWorld) {
            ((ServerWorld)world).func_82742_i();
        }
    }

    public AbstractCarrier(EntityType<?> type, World world) {
        super(type, world);
    }

    public Optional<Pollutant<?>> getPollutant() {
        return this.getCarriedBlockState().map(state -> state.func_177230_c()).filter(block -> block instanceof Pollutant).map(block -> (Pollutant)((Object)block));
    }

    public boolean func_70067_L() {
        return false;
    }

    public int getPollutionAmount() {
        return this.getCarriedBlockState().flatMap(state -> this.getPollutant().map(pollutant -> pollutant.getCarriedPollutionAmount((BlockState)state))).orElse(0);
    }

    public int getPollutionCapacity() {
        return this.getPollutant().map(pollutant -> pollutant.getPollutionCapacity()).orElse(0);
    }

    public boolean pump() {
        Pollutant pollutant;
        BlockState state;
        if (this.isServerSide() && this.func_70089_S() && (state = (BlockState)this.getCarriedBlockState().orElse(null)) != null && (pollutant = (Pollutant)this.getPollutant().orElse(null)) != null && pollutant.canStateBePumped(state)) {
            this.setCarriedBlockState(Optional.of(pollutant.getPumpedState(state)));
            return true;
        }
        return false;
    }

    public boolean spend() {
        Pollutant pollutant;
        BlockState state;
        if (this.isServerSide() && this.func_70089_S() && (state = (BlockState)this.getCarriedBlockState().orElse(null)) != null && (pollutant = (Pollutant)this.getPollutant().orElse(null)) != null && pollutant.canStateBeSpreaded(state)) {
            this.setCarriedBlockState(Optional.of(pollutant.getSpreadedState(state)));
            return true;
        }
        return false;
    }

    protected boolean spreadTo(GasEntity targetEntity, int minPollutionDelta) {
        if (targetEntity.func_70089_S() && targetEntity.carriesSameBlock(this.getPollutant())) {
            int pollutionDelta = Math.abs(this.getPollutionAmount() - targetEntity.getPollutionAmount());
            return pollutionDelta >= minPollutionDelta && targetEntity.pump();
        }
        return false;
    }

    protected void setCarriedBlockState(Optional<BlockState> newState) {
        super.setCarriedBlockState(newState);
        if (newState.isPresent() && newState.get().func_196958_f() && this.isServerSide()) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        this.field_70170_p.func_217381_Z().func_76320_a("pollutant_carrier.tick");
        super.func_70071_h_();
        this.field_70170_p.func_217381_Z().func_76319_b();
    }
}

