/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import com.endertech.minecraft.mods.adpother.pollution.CarrierSpawnLimiter;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GasEntity
extends AbstractCarrier {
    static final long maxExistence = GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.minutes((double)10.0));
    protected final GameTime stuckUpdateInterval = GameTime.seconds((int)3);
    protected static final DataParameter<Boolean> STUCK = EntityDataManager.func_187226_a(GasEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public GasEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public GasEntity(World world, BlockPos pos, BlockState carriedState) {
        super(AdPother.getInstance().entities.gas, world, pos, carriedState);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(STUCK, (Object)false);
        super.func_70088_a();
    }

    public boolean isStuck() {
        return (Boolean)this.func_184212_Q().func_187225_a(STUCK);
    }

    public void setStuck(boolean value) {
        boolean old;
        if (this.isServerSide() && this.func_70089_S() && value != (old = this.isStuck())) {
            CarrierSpawnLimiter limiter = WorldData.getData(this.field_70170_p).getPollutantCarrierLimiter();
            if (value) {
                limiter.onEntityRemoved((Entity)this);
            } else {
                limiter.onEntityAdded((Entity)this);
            }
        }
        this.func_184212_Q().func_187227_b(STUCK, (Object)value);
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70030_z() {
        BlockPos pos;
        Spread spread;
        boolean alignedToBlock;
        BlockState newState;
        if (!this.func_70089_S()) {
            return;
        }
        boolean isStuck = this.isStuck();
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_82742_i();
        }
        if (isStuck && this.isServerSide() && !this.stuckUpdateInterval.pastIn(this.field_70170_p)) {
            return;
        }
        if (isStuck && this.isClientSide()) {
            return;
        }
        if (isStuck && this.isServerSide() && (long)this.field_70173_aa > maxExistence && !GameWorld.SmokeContainers.isChimney((IWorldReader)this.field_70170_p, (BlockPos)this.func_233580_cy_())) {
            this.func_70106_y();
            return;
        }
        BlockState carriedState = this.getCarriedBlockState().orElse(null);
        Pollutant pollutant = this.getPollutant().orElse(null);
        if (carriedState == null || pollutant == null || pollutant == Blocks.field_150350_a || pollutant.getCarriedPollutionAmount(carriedState) <= 0 || !pollutant.getAltitudeBounds().encloses(Integer.valueOf(this.func_233580_cy_().func_177956_o()))) {
            if (this.isServerSide()) {
                this.func_70106_y();
            }
            return;
        }
        if (this.field_70170_p instanceof ServerWorld && (newState = pollutant.affectBlockAt((ServerWorld)this.field_70170_p, this.func_233580_cy_(), Optional.empty(), true, carriedState)) != carriedState) {
            this.setCarriedBlockState(Optional.of(newState));
            return;
        }
        Optional<Direction> motionFacing = pollutant.getMotionFacing(this.field_70170_p, this.func_233580_cy_());
        double motionY = 0.0;
        if (motionFacing.isPresent()) {
            float velocity = pollutant.getMotionVelocityIn(BiomeId.from((IWorld)this.field_70170_p, (BlockPos)this.func_233580_cy_()));
            motionY = motionFacing.get() != Direction.DOWN ? (double)velocity : (double)(-velocity);
        }
        this.func_213293_j(0.0, motionY, 0.0);
        AxisAlignedBB nextBB = this.getBB(this.getNextPosition());
        BlockPos movePos = new BlockPos(this.func_226277_ct_(), this.func_213322_ci().func_82617_b() < 0.0 ? nextBB.field_72338_b : nextBB.field_72337_e, this.func_226281_cx_());
        boolean canPassThrough = motionFacing.isPresent() && pollutant.canPassThrough((IWorldReader)this.field_70170_p, movePos, motionFacing.get().func_176734_d(), motionFacing.get());
        boolean entityCollided = false;
        if (canPassThrough) {
            this.setStuck(false);
            boolean blockSize = true;
            double motionSign = Math.signum(this.func_213322_ci().func_82617_b());
            List collidedEntities = this.getCollidedEntitiesIfMove(GasEntity.getMotion((Entity)this));
            for (Entity entity : collidedEntities) {
                if (!(entity instanceof GasEntity)) continue;
                if (this.isServerSide() && this.spreadTo((GasEntity)entity, 0) && this.spend()) {
                    return;
                }
                if (this.isServerSide() && this.func_213322_ci().func_82617_b() > entity.func_213322_ci().func_82617_b()) {
                    this.swapPositionWith(entity);
                    return;
                }
                double alignedY = entity.func_226278_cu_() - motionSign * 1.0;
                this.field_70167_r = this.func_226278_cu_();
                this.func_70107_b(this.func_226277_ct_(), alignedY, this.func_226281_cx_());
                canPassThrough = false;
                entityCollided = true;
                this.field_70122_E = true;
                break;
            }
        }
        if (canPassThrough) {
            this.field_70122_E = false;
            this.move();
            return;
        }
        this.field_70122_E = true;
        long alignedY = Math.round(this.func_226278_cu_());
        if (!entityCollided) {
            this.func_70107_b(this.func_226277_ct_(), alignedY, this.func_226281_cx_());
        }
        boolean bl = alignedToBlock = this.func_226278_cu_() == (double)alignedY;
        if (alignedToBlock) {
            this.setStuck(true);
        }
        if (this.field_70170_p instanceof ServerWorld && alignedToBlock && (spread = pollutant.createSpread((ServerWorld)this.field_70170_p, pos = this.func_233580_cy_(), carriedState).to(pos, Integer.MIN_VALUE).overLedge().around(Integer.MIN_VALUE)).completed()) {
            spread.applyTarget();
            this.setCarriedBlockState(Optional.of(spread.getSourceState()));
            return;
        }
    }
}

