/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.items.RepairMatcher;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AnvilEvents {
    public static int filterReplacingExpGain = 0;

    @SubscribeEvent
    public static void onVacuumBagPlaced(AnvilUpdateEvent event) {
        Item item = event.getLeft().func_77973_b();
        if (item instanceof VacuumBag) {
            AnvilEvents.cleanAndPrepare((VacuumBag)item, 2, event);
        }
    }

    @SubscribeEvent
    public static void onRespiratorPlaced(AnvilUpdateEvent event) {
        ItemStack stack = event.getLeft();
        Respirators.Respirator respirator = (Respirators.Respirator)AdPother.getInstance().respirators.findBy(stack);
        if (respirator != null) {
            AnvilEvents.cleanAndPrepare(respirator, 1, event);
        }
    }

    @SubscribeEvent
    public static void onRepair(AnvilRepairEvent event) {
        ItemStack stack = event.getItemInput();
        Item item = stack.func_77973_b();
        if (item instanceof VacuumBag || Block.func_149634_a((Item)item) instanceof FilterFrame || AdPother.getInstance().respirators.findBy(stack) != null) {
            event.setBreakChance(0.0f);
            event.getPlayer().func_82242_a(filterReplacingExpGain + 1);
        }
    }

    private static boolean cleanAndPrepare(IStorageItem storage, int materialCost, AnvilUpdateEvent event) {
        RepairMatcher matcher = RepairMatcher.from((AnvilUpdateEvent)event);
        Pollutants pollutants = AdPother.getInstance().pollutants;
        if (matcher.material.func_190916_E() < materialCost) {
            return false;
        }
        ItemStack output = event.getLeft().func_77946_l();
        boolean result = false;
        for (Pollutant pollutant : pollutants.getAll()) {
            if (!pollutant.getFilterMaterials().contains(matcher.material)) continue;
            storage.installFiltersFor(output, pollutant);
            event.setCost(1);
            event.setMaterialCost(materialCost);
            event.setOutput(output);
            result = true;
        }
        return result;
    }
}

