/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ChunkEvents {
    @SubscribeEvent
    public static void onChunkDataLoaded(ChunkDataEvent.Load event) {
        if (event.getChunk() instanceof Chunk) {
            Chunk chunk = (Chunk)event.getChunk();
            ChunkLoc location = ChunkLoc.from((Chunk)chunk);
            ChunkPollution pollution = WorldData.getChunkPollution(chunk.func_177412_p(), location);
            pollution.readFrom(ChunkEvents.getLevelData((ChunkDataEvent)event));
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaved(ChunkDataEvent.Save event) {
        if (event.getChunk() instanceof Chunk) {
            Chunk chunk = (Chunk)event.getChunk();
            ChunkLoc location = ChunkLoc.from((Chunk)chunk);
            ChunkPollution pollution = WorldData.getChunkPollution(chunk.func_177412_p(), location);
            if (!pollution.isEmpty()) {
                pollution.writeTo(ChunkEvents.getLevelData((ChunkDataEvent)event));
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoaded(ChunkEvent.Load event) {
        Chunk chunk;
        World world;
        if (event.getChunk() instanceof Chunk && (world = (chunk = (Chunk)event.getChunk()).func_177412_p()) instanceof ServerWorld) {
            WorldData data = WorldData.getData(world);
            for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                TileEntity tile = (TileEntity)entry.getValue();
                BlockState state = chunk.func_180495_p(pos);
                data.addIfEmitter((ServerWorld)world, pos, state, tile);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        if (event.getChunk() instanceof Chunk) {
            Chunk chunk = (Chunk)event.getChunk();
            World world = chunk.func_177412_p();
            ChunkLoc location = ChunkLoc.from((Chunk)chunk);
            WorldData data = WorldData.getData(world);
            ChunkPollution pollution = WorldData.getChunkPollution(world, location);
            if (GameWorld.isClientSide((IWorldReader)world) || pollution.isEmpty()) {
                data.removePollutionInfoAt(location);
            }
        }
    }

    private static CompoundNBT getLevelData(ChunkDataEvent event) {
        return event.getData().func_74775_l("Level");
    }
}

