/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityEvents {
    static final GameTime UPDATE_INTERVAL = GameTime.second();

    @SubscribeEvent
    public static void canEntityUpdate(EntityEvent.CanUpdate event) {
        if (event.getEntity() instanceof GasEntity && !event.getCanUpdate()) {
            event.setCanUpdate(true);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        World world = living.func_130014_f_();
        if (!GameWorld.isServerSide((IWorldReader)world)) {
            return;
        }
        if (!UPDATE_INTERVAL.pastIn(world)) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)living);
        int combinedDamage = pollution.getInfos().map(info -> info.getPollutant()).mapToInt(pollutant -> {
            boolean directContact = pollution.isDirectContactWith((Pollutant<?>)((Object)pollutant));
            if (!pollutant.canAffectEntity((Entity)living, directContact)) {
                return 0;
            }
            int damage = pollution.getDamageFrom((Pollutant<?>)((Object)pollutant));
            Map<ItemStack, IStorageItem> protectItems = pollutant.getProtectiveItems(living);
            if (protectItems.isEmpty()) {
                if (!EntityEvents.killWeakLiving(living, damage)) {
                    if (directContact) {
                        int amplifier = pollutant.getCarriedPollutionAmount(pollution.getState()) - 1;
                        pollutant.getNegativeEffects().updateDirectOn(living, amplifier);
                    }
                    Percentage influence = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant));
                    pollutant.getNegativeEffects().updateGlobalOn(living, influence);
                }
            } else {
                protectItems.entrySet().forEach(entry -> {
                    ItemStack stack = (ItemStack)entry.getKey();
                    IStorageItem item = (IStorageItem)entry.getValue();
                    item.fill(stack, (Pollutant<?>)((Object)pollutant), damage);
                });
            }
            return damage;
        }).sum();
        AdPother.getInstance().respirators.updateEffectFor(living, combinedDamage);
    }

    static boolean killWeakLiving(LivingEntity living, int damage) {
        if (EntityEvents.isHostileMob(living)) {
            return false;
        }
        float health = living.func_110143_aJ();
        if (ForgeEntity.isServerSide((Entity)living) && health <= (float)damage && !(living instanceof PlayerEntity)) {
            living.func_70097_a(DamageSource.field_82727_n, (float)damage);
            return true;
        }
        return false;
    }

    public static void onCreatureJoinWorld(EntityJoinWorldEvent event) {
        CreatureEntity creature = EntityEvents.getServerEntityOf(CreatureEntity.class, (EntityEvent)event).orElse(null);
        if (creature == null) {
            return;
        }
        if (EntityEvents.isHostileMob((LivingEntity)creature)) {
            return;
        }
        if (creature instanceof AgeableEntity) {
            EntityPollution pollution = WorldData.getEntityPollution((Entity)creature);
            pollution.getDominantPollutant(pollutant -> pollutant.canAffectEntity((Entity)creature, true)).ifPresent(pollutant -> {
                float factor = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toFraction();
                double baseHealth = creature.func_110148_a(Attributes.field_233818_a_).func_111125_b();
                int newHealth = IntBounds.from((Integer)1, (Integer)((int)baseHealth)).approxDown(factor);
                creature.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)newHealth);
            });
        }
    }

    static <T extends Entity> Optional<T> getServerEntityOf(Class<T> clazz, EntityEvent event) {
        Entity entity = event.getEntity();
        if (clazz.isInstance(entity) && EntityEvents.isServerSide(event)) {
            return Optional.of((Entity)clazz.cast(entity));
        }
        return Optional.empty();
    }

    public static boolean isHostileMob(LivingEntity living) {
        return living instanceof IMob;
    }

    static boolean isServerSide(EntityEvent event) {
        return !event.isCanceled() && ForgeEntity.isServerSide((Entity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHeal(LivingHealEvent event) {
        EntityEvents.getServerEntityOf(AnimalEntity.class, (EntityEvent)event).ifPresent(animal -> {
            float health = animal.func_110143_aJ();
            if (health < animal.func_110138_aP() && health + event.getAmount() >= animal.func_110138_aP()) {
                AdPother.getInstance().sources.animalFeeding.emitFrom(animal, 1.0f);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityEvents.getServerEntityOf(AnimalEntity.class, (EntityEvent)event).ifPresent(animal -> AdPother.getInstance().sources.animalDeath.emitFrom(animal, 1.0f));
    }
}

