/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerEvents {
    private static final GameTime PLAYER_UPDATE_INTERVAL = GameTime.quaterSecond();
    private static final GameTime IGNITION_FROM_TORCH_CHECK_INTERVAL = GameTime.second();

    static Optional<PlayerEntity> getServerPlayer(LivingEvent event) {
        Entity entity = event.getEntity();
        if (!event.isCanceled() && entity instanceof PlayerEntity && ForgeEntity.isServerSide((Entity)entity)) {
            return Optional.of((PlayerEntity)entity);
        }
        return Optional.empty();
    }

    @Deprecated
    public static void OnLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Block block;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        if (player.func_184812_l_() || !AbstractGas.isGasBlock(world, pos)) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b() && world instanceof ServerWorld && (block = world.func_180495_p(pos).func_177230_c()) instanceof AbstractGas) {
            ((AbstractGas)block).pushedBy((ServerWorld)world, pos, player, event.getFace());
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (block == Blocks.field_150414_aQ) {
            ItemStack respirator = AdPother.getInstance().respirators.findOn(event.getEntityLiving(), false);
            if (!respirator.func_190926_b()) {
                event.setUseBlock(Event.Result.DENY);
            } else {
                PlayerEntity player = PlayerEvents.getServerPlayer((LivingEvent)event).orElse(null);
                if (player != null && player.func_71043_e(false)) {
                    AdPother.getInstance().sources.playerEating.emitFrom(player, 2.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack;
        LivingEntity living = event.getEntityLiving();
        ItemStack respirator = AdPother.getInstance().respirators.findOn(living, false);
        if (!(respirator.func_190926_b() || (stack = event.getItemStack()).func_77975_n() != UseAction.DRINK && stack.func_77975_n() != UseAction.EAT)) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.FAIL);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (stack.func_77975_n() == UseAction.EAT) {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> AdPother.getInstance().sources.playerEating.emitFrom((PlayerEntity)player, stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> AdPother.getInstance().sources.playerDeath.emitFrom(player, 1.0f));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        Respirators.Respirator respirator = (Respirators.Respirator)AdPother.getInstance().respirators.findBy(stack);
        if (respirator != null) {
            respirator.addInformation(stack, player.func_130014_f_(), event.getToolTip(), event.getFlags());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerBreaksBlock(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        World world = player.func_130014_f_();
        if (!GameWorld.isServerSide((IWorldReader)world)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        WorldEvents.onBlockBroken(world, pos, state);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.side.isServer()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        PlayerEntity player = event.player;
        World world = player.func_130014_f_();
        if (IGNITION_FROM_TORCH_CHECK_INTERVAL.pastIn(world)) {
            GasExplosion.fromHeldTorch(player).tryExplode();
        }
        if (!PLAYER_UPDATE_INTERVAL.pastIn(world)) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        pollution.update();
        boolean explosionRisk = GasExplosion.in(world).positions(GasExplosion.getIgnitablePositionsAround(player, EnumSet.allOf(Hand.class))).tryTrigger();
        pollution.setExplosionRisk(explosionRisk);
        if (world instanceof IServerWorld) {
            new EntityPollution.NetMsg(pollution).sendToAllAround((IServerWorld)world, player.func_233580_cy_(), 64);
        }
    }
}

