/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.events.RandomTickEvent;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.BreakableBlock;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorldEvents {
    public static boolean loggingFuelConsumption = false;
    public static boolean furnaceEmissions = true;
    public static boolean burntBlockEmissions = true;

    @SubscribeEvent
    public static void onWorldLoaded(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        WorldData.removeDataFor(event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        World world = event.world;
        if (GameWorld.isServerSide((IWorldReader)world)) {
            WorldData data = WorldData.getData(world);
            data.tick();
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            Entity entity = event.getEntity();
            WorldData data = WorldData.getData((World)world);
            data.getPollutantCarrierLimiter().onEntityAdded(entity);
            data.addIfDroppedTorch(world, entity);
            data.addIfEmitter(world, entity);
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveWorldEvent event) {
        Entity entity = event.getEntity();
        World world = event.getWorld();
        WorldData data = WorldData.getData(world);
        data.removePollutionInfoFor(entity);
        if (GameWorld.isServerSide((IWorldReader)world)) {
            data.getPollutantCarrierLimiter().onEntityRemoved(entity);
            data.removePeriodicEmissionFor(entity);
            data.removeIfDroppedTorch(entity);
        }
    }

    @SubscribeEvent
    public static void onBlockChange(BlockEvent.NeighborNotifyEvent event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockPos pos = event.getPos();
            TileEntity tile = world.func_175625_s(pos);
            BlockState state = event.getState();
            if (tile != null) {
                WorldData.getData((World)world).addIfEmitter(world, pos, state, tile);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRandomTick(RandomTickEvent.Block event) {
        Emitter emitter;
        Torch torch;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = (BlockState)event.getState();
        if (Torch.rate > 0.0f && (torch = (Torch)AdPother.getInstance().torches.findBy(state)) != null) {
            torch.emitAt(world, pos);
        }
        if ((emitter = (Emitter)AdPother.getInstance().emitters.findBy((IWorldReader)world, pos)) != null && emitter.getType().isBlock() && emitter.isActive((IWorldReader)world, pos)) {
            emitter.emitAt(world, pos);
        }
    }

    public static void onBlockBroken(World world, BlockPos pos, BlockState state) {
        BreakableBlock breakable = (BreakableBlock)AdPother.getInstance().breakables.findBy(state);
        if (breakable != null) {
            breakable.emitAt(world, pos);
        }
    }

    @SubscribeEvent
    public static void onFluidRandomTick(RandomTickEvent.Fluid event) {
        Fluids.ToxicFluids.findBy((FluidState)event.getState()).ifPresent(fluid -> fluid.affectSoilFrom(event.getWorld(), event.getPos()));
    }

    public static final void onFoodConsumed(ItemStack food, AnimalEntity animal) {
        AdPother.getInstance().sources.animalFeeding.emitFrom(animal, food);
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, TileEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), tile);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, TileEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, tile);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, TileEntity tile) {
        if (fluid != null) {
            Optional<Fuel> fuel = WorldEvents.asFuel(fluid);
            WorldEvents.logConsumedFuel(UnitId.from((Fluid)fluid, (String)""), fuel, amount, tile);
            if (fuel.isPresent()) {
                WorldEvents.onFuelBurned(fuel.get(), amount, tile);
            }
        }
    }

    private static Optional<Fuel> asFuel(@Nullable Fluid fluid) {
        if (fluid != null) {
            return Optional.ofNullable((Fuel)AdPother.getInstance().fuels.findBy(fluid));
        }
        return Optional.empty();
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, Entity entity) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), entity);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, Entity entity) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, entity);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, Entity entity) {
        WorldEvents.asFuel(fluid).ifPresent(fuel -> WorldEvents.onFuelBurned(fuel, amount, entity));
    }

    private static Optional<Fuel> asFuel(ItemStack stack) {
        return Optional.ofNullable(AdPother.getInstance().fuels.findBy(stack));
    }

    public static final void onFuelBurned(ItemStack stack, int amount, TileEntity tile) {
        Optional<Fuel> fuel = WorldEvents.asFuel(stack);
        WorldEvents.logConsumedFuel(UnitId.from((Item)stack.func_77973_b()), fuel, amount, tile);
        if (fuel.isPresent()) {
            WorldEvents.onFuelBurned(fuel.get(), amount, tile);
        }
    }

    private static void logConsumedFuel(UnitId id, Optional<Fuel> fuel, int amount, TileEntity tile) {
        if (loggingFuelConsumption) {
            AdPother.getInstance().getLogger().debug(tile.func_200662_C().getRegistryName().func_110623_a() + " consumed " + amount + "x " + id + " (" + fuel.map(f -> f.getRelatedId().toString()).orElse("no fuel") + ")");
        }
    }

    public static final void onFuelBurned(ItemStack stack, int amount, Entity entity) {
        WorldEvents.asFuel(stack).ifPresent(fuel -> WorldEvents.onFuelBurned(fuel, amount, entity));
    }

    public static final void onFuelBurned(Fuel fuel, int amount, TileEntity tile) {
        World world = tile.func_145831_w();
        if (world instanceof ServerWorld) {
            BlockPos pos = tile.func_174877_v();
            ChunkPollution pollution = WorldData.getChunkPollution(world, pos);
            Emitter emitter = (Emitter)AdPother.getInstance().emitters.findBy((IWorldReader)world, pos);
            if (emitter != null) {
                pollution.increaseBy(emitter, fuel, tile);
            }
        }
    }

    public static final void onFuelBurned(Fuel fuel, int amount, Entity entity) {
        fuel.emitAt(entity.func_130014_f_(), entity.func_233580_cy_(), amount);
    }

    @SubscribeEvent
    public static void onLavaTouchedWater(BlockEvent.FluidPlaceBlockEvent event) {
        BlockPos blockpos;
        Predicate<BlockPos> isWaterOrLava;
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld && (isWaterOrLava = pos -> {
            FluidState state = world.func_204610_c(pos);
            return state.func_206884_a((ITag)FluidTags.field_206959_a) || state.func_206884_a((ITag)FluidTags.field_206960_b);
        }).test(blockpos = event.getPos()) && isWaterOrLava.test(event.getLiquidPos())) {
            AdPother.getInstance().sources.lavaTouchingWater.emitAt((World)((ServerWorld)world), blockpos);
        }
    }

    public static final void onBlockExploded(World world, BlockPos pos, BlockState state, Explosion explosion) {
        if (!GameWorld.isServerSide((IWorldReader)world)) {
            return;
        }
        AdPother.getInstance().sources.explosion.emitAt(world, pos);
        WorldEvents.onBlockBroken(world, pos, state);
        if (state.isFlammable((IBlockReader)world, pos, Direction.UP)) {
            WorldEvents.onBlockBurned(world, pos, state);
        }
    }

    public static final void onFurnaceFuelBurned(TileEntity tile, ItemStack stack) {
        if (furnaceEmissions) {
            WorldEvents.onFuelBurned(stack, 1, tile);
        }
    }

    public static final void onBlockBurned(World world, BlockPos pos, BlockState state) {
        Fuel fuel;
        if (burntBlockEmissions && GameWorld.isServerSide((IWorldReader)world) && (fuel = (Fuel)AdPother.getInstance().fuels.findBy(state)) != null) {
            fuel.emitAt(world, pos);
        }
    }
}

