/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.RegistryEntriesInit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class Fluids
extends RegistryEntriesInit<Fluid> {
    public final PollutedWater.StillFluid pollutedWaterStill;
    public final PollutedWater.FlowingFluid pollutedWaterFlowing;

    public Fluids(ForgeMod mod) {
        super(mod, Fluid.class);
        ForgeFlowingFluid.Properties props = new ForgeFlowingFluid.Properties(() -> AdPother.getInstance().fluids.pollutedWaterStill, () -> AdPother.getInstance().fluids.pollutedWaterFlowing, FluidAttributes.builder((ResourceLocation)new ResourceLocation("block/water_still"), (ResourceLocation)new ResourceLocation("block/water_flow")).overlay(new ResourceLocation("block/water_overlay")).color(-1710797).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> AdPother.getInstance().blocks.pollutedWater).bucket(() -> AdPother.getInstance().items.pollutedWaterBucket).canMultiply().explosionResistance(100.0f).levelDecreasePerBlock(1).slopeFindDistance(4).tickRate(5);
        this.pollutedWaterStill = (PollutedWater.StillFluid)((Object)this.addNew((Object)new PollutedWater.StillFluid(props)));
        this.pollutedWaterFlowing = (PollutedWater.FlowingFluid)((Object)this.addNew((Object)new PollutedWater.FlowingFluid(props)));
    }

    public static abstract class WaterChain
    extends WorldSearch.BlockChain {
        protected final int maxRadius;

        protected WaterChain(IWorld world, BlockPos startPos, int maxRadius) {
            super(world, startPos, Math.round((float)Math.PI * (float)maxRadius * (float)maxRadius));
            this.maxRadius = maxRadius;
        }

        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().horizontals().shuffle().toList();
        }

        protected boolean isWithinMaxRadius(BlockPos pos) {
            return this.startPos.func_177951_i((Vector3i)pos) <= (double)(this.maxRadius * this.maxRadius);
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            if (!this.isWithinMaxRadius(pos)) {
                return false;
            }
            BlockState state = this.world.func_180495_p(pos);
            Material material = state.func_185904_a();
            return material == Material.field_151586_h;
        }
    }

    static class SoilChain
    extends WorldSearch.BlockChain {
        private boolean affected = false;
        private final BlockPos top;

        public static SoilChain from(World world, BlockPos startPos, int maxLength, BlockPos topPos) {
            SoilChain chain = new SoilChain(world, startPos, maxLength, topPos);
            chain.build();
            return chain;
        }

        protected SoilChain(World world, BlockPos startPos, int maxLength, BlockPos topPos) {
            super((IWorld)world, startPos, maxLength);
            this.top = topPos;
        }

        public boolean isAffected() {
            return this.affected;
        }

        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().all().shuffle().toList();
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            if (pos.func_177956_o() > this.top.func_177956_o()) {
                return false;
            }
            BlockState state = this.world.func_180495_p(pos);
            Material material = state.func_185904_a();
            if (material == Material.field_151595_p) {
                return true;
            }
            return this.isValidBlock(pos);
        }

        protected boolean isValidBlock(BlockPos pos) {
            if (pos.func_177956_o() > this.top.func_177956_o()) {
                return false;
            }
            BlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Material material = state.func_185904_a();
            if (material == Material.field_151578_c || material == Material.field_151577_b) {
                return true;
            }
            return block instanceof IPlantable || block instanceof IGrowable;
        }

        protected boolean onValidFound(BlockPos pos) {
            BlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof GrassBlock || block instanceof FarmlandBlock) {
                this.affected = this.world.func_180501_a(pos, Blocks.field_196661_l.func_176223_P(), 3);
            } else if (state.func_203425_a(Blocks.field_150346_d)) {
                this.affected = this.world.func_180501_a(pos, Blocks.field_196660_k.func_176223_P(), 3);
            } else if (block instanceof IPlantable || block instanceof IGrowable) {
                this.affected = this.world.func_217377_a(pos, false);
            }
            return !this.affected;
        }
    }

    public static enum ToxicFluids {
        canola,
        coal,
        creosote,
        creotheum,
        crude,
        diesel,
        ender,
        ethanol,
        fire_water,
        fuel,
        gasoline,
        glycerin,
        hootch,
        kerosene,
        lubricant,
        methanol,
        napalm,
        naphtha,
        oil,
        petrol,
        petrotheum,
        plantoil,
        polluted_water,
        pyrotheum,
        redstone,
        resin;

        private static final Map<Fluid, Optional<ToxicFluids>> CACHED_FLUIDS;

        private static Optional<ToxicFluids> findBy(String name) {
            for (ToxicFluids fluid : ToxicFluids.values()) {
                if (!name.contains(fluid.name())) continue;
                return Optional.of(fluid);
            }
            return Optional.empty();
        }

        public static Optional<ToxicFluids> findBy(FluidState state) {
            if (state.func_206888_e()) {
                return Optional.empty();
            }
            return CACHED_FLUIDS.computeIfAbsent(state.func_206886_c(), fluid -> ToxicFluids.findBy(fluid.getRegistryName().func_110623_a()));
        }

        public boolean affectSoilFrom(World world, BlockPos startPos) {
            WorldSearch.Column column = WorldSearch.Column.from((IWorld)world, (BlockPos)startPos);
            boolean affected = false;
            for (BlockPos pos : column.getChain()) {
                int pressure;
                int length;
                SoilChain chain;
                if (pos.func_177956_o() > startPos.func_177956_o() || !(chain = SoilChain.from(world, pos, length = (pressure = column.getTop().func_177956_o() - pos.func_177956_o()) + 2 + 1, column.getTop())).isAffected()) continue;
                affected = true;
            }
            return affected;
        }

        static {
            CACHED_FLUIDS = new ConcurrentHashMap<Fluid, Optional<ToxicFluids>>();
        }
    }
}

