/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;

public class Fuels
extends RelatedUnitsInit<Fuel, BuiltInFuels> {
    public Fuels(ForgeMod mod) {
        super(mod, BuiltInFuels.class);
    }

    public Fuel createCustomUnitFrom(UnitConfig config, String name) {
        return new Fuel(config, SourceBase.Properties.with());
    }

    public Fuel createDefaultUnitFrom(UnitConfig config, BuiltInFuels e) {
        return new Fuel(config, e.props);
    }

    public static Optional<Emissions> defaultEmissionsFor(ItemStack stack) {
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack);
        if (burnTime > 0) {
            double carbon = (double)burnTime / 1600.0;
            double sulfur = carbon / 10.0;
            Emissions emissions = Emissions.of().carbon((float)carbon).sulfur((float)sulfur);
            return Optional.of(emissions);
        }
        return Optional.empty();
    }

    @Nullable
    public Fuel findBy(ItemStack stack) {
        Optional<Emissions> emissions;
        Fuel fuel = (Fuel)super.findBy(stack);
        if (fuel == null && (emissions = Fuels.defaultEmissionsFor(stack)).isPresent()) {
            fuel = new Fuel(null, (SourceBase.Properties<?>)((Object)Emitter.Properties.with().emissions(emissions.get())));
        }
        return fuel;
    }

    static enum BuiltInFuels implements IForgeEnum
    {
        group$arrows("#minecraft:arrows", 0.0625),
        group$banners("#minecraft:banners", 0.1875),
        group$bio_fuels("#forge:fuels/bio", 0.0625),
        group$blaze_rods("#forge:rods/blaze", 1.2, 0.6),
        group$beds("#minecraft:beds", 0.75),
        group$boats("#minecraft:boats", 0.75),
        group$bookshelves("#forge:bookshelves", 0.1875),
        group$carpets("#minecraft:carpets", 0.335),
        group$carrots("#forge:crops/carrot", 0.0625),
        group$charcoal("#forge:charcoal", 1.0),
        group$charcoal_dust("#forge:dusts/charcoal", 0.8),
        group$charcoal_blocks("#forge:storage_blocks/charcoal", 9.0),
        group$coal_blocks("#forge:storage_blocks/coal", 9.0),
        group$coal_coke("#forge:coal_coke", 1.0),
        group$coal_coke_blocks("#forge:storage_blocks/coal_coke", 18.0),
        group$gunpowder("#forge:gunpowder", 0.8, 0.4),
        group$feathers("#forge:feathers", 0.0625),
        group$fishes("#minecraft:fishes", 0.125),
        group$leaves("#minecraft:leaves", 0.1875),
        group$logs("#minecraft:logs", 0.1875),
        group$mushrooms("#forge:mushrooms", 0.0625),
        group$nether_stars("#forge:nether_stars", 50.0, 25.0),
        group$rails("#minecraft:rails", 0.0625),
        group$saplings("#minecraft:saplings", 0.0625),
        group$seeds("#forge:seeds", 0.0625),
        group$signs("#minecraft:signs", 0.35),
        group$small_flowers("#minecraft:small_flowers", 0.0625),
        group$tall_flowers("#minecraft:tall_flowers", 0.125),
        group$lectern_books("#minecraft:lectern_books", 0.55),
        group$planks("#minecraft:planks", 0.1875),
        group$sulfur_dust("#forge:dusts/sulfur", 0.08, 0.8),
        group$wheat_crops("#forge:crops/wheat", 0.0625),
        group$wooden_fences("#forge:fences/wooden", 0.1875),
        group$wooden_fence_gates("#forge:fence_gates/wooden", 0.1875),
        group$wooden_slabs("#minecraft:wooden_slabs", 0.075),
        group$wooden_buttons("#minecraft:wooden_buttons", 0.0625),
        group$wooden_chests("#forge:chests/wooden", 0.1875),
        group$wooden_doors("#minecraft:wooden_doors", 0.1875),
        group$wooden_pressure_plates("#minecraft:wooden_pressure_plates", 0.1875),
        group$wooden_rods("#forge:rods/wooden", 0.0625),
        group$wooden_trapdoors("#minecraft:wooden_trapdoors", 0.1875),
        group$wooden_stairs("#minecraft:wooden_stairs", 0.1875),
        group$wool("#minecraft:wool", 0.0625),
        fluid$biodiesel("#forge:biodiesel", BuiltInFuels.perBucket(18.0), BuiltInFuels.perBucket(1.0)),
        fluid$diesel("#forge:diesel", BuiltInFuels.perBucket(22.0), BuiltInFuels.perBucket(1.0)),
        fluid$bioethanol("#forge:bioethanol", BuiltInFuels.perBucket(10.0), BuiltInFuels.perBucket(0.1)),
        fluid$ethanol("#forge:ethanol", BuiltInFuels.perBucket(13.0), BuiltInFuels.perBucket(0.1)),
        fluid$gasoline("#forge:gasoline", BuiltInFuels.perBucket(20.0), BuiltInFuels.perBucket(1.0)),
        fluid$lava("#minecraft:lava", BuiltInFuels.perBucket(20.0), BuiltInFuels.perBucket(10.0)),
        minecraft$apple(0.0625),
        minecraft$golden_apple(0.125),
        minecraft$armor_stand(0.3),
        minecraft$beef(0.125),
        minecraft$blaze_powder(0.6, 0.3),
        minecraft$book(0.5),
        minecraft$bow(0.1875),
        minecraft$bowl(0.0625),
        minecraft$cactus(0.1875),
        minecraft$carrot_on_a_stick(0.1875),
        minecraft$chicken(0.125),
        minecraft$cobweb(0.125),
        minecraft$chorus_plant(0.3),
        minecraft$chorus_flower(0.3),
        minecraft$coal(1.0),
        minecraft$crafting_table(0.1875),
        minecraft$crossbow(0.1875),
        minecraft$daylight_detector(0.1875),
        minecraft$deadbush(0.125),
        minecraft$dragon_breath(1.05, 0.525),
        minecraft$fire_charge(0.75, 0.325),
        minecraft$firework_rocket(2.55),
        minecraft$firework_star(1.2, 0.6),
        minecraft$fishing_rod(0.125),
        minecraft$ghast_tear(1.0, 0.5),
        minecraft$grass(0.125),
        minecraft$hay_block(0.45),
        minecraft$item_frame(0.45),
        minecraft$jukebox(0.1875),
        minecraft$ladder(0.1875),
        minecraft$lava_bucket(10.0, 10.0),
        minecraft$lever(0.0625),
        minecraft$lily_pad(0.0625),
        minecraft$magma_cream(1.0, 0.5),
        minecraft$map(1.25),
        minecraft$mutton(0.125),
        minecraft$note_block(0.1875),
        minecraft$painting(0.5),
        minecraft$paper(0.1875),
        minecraft$piston(0.5),
        minecraft$poisonous_potato(0.0625),
        minecraft$porkchop(0.125),
        minecraft$rabbit(0.125),
        minecraft$redstone_torch(0.0625),
        minecraft$rotten_flesh(0.125, 0.3),
        minecraft$seagrass(0.125),
        minecraft$shield(0.9),
        minecraft$spider_eye(0.0625),
        minecraft$sticky_piston(0.5),
        minecraft$sugar_cane(0.0625),
        minecraft$tall_grass(0.125),
        minecraft$tnt(4.05, 2.025),
        minecraft$tnt_minecart(4.1, 2.05),
        minecraft$torch(0.0625),
        minecraft$soul_torch(0.0625, 0.125),
        minecraft$tripwire_hook(0.125),
        minecraft$vine(0.0625),
        minecraft$wooden_axe(0.125),
        minecraft$wooden_hoe(0.125),
        minecraft$wooden_pickaxe(0.125),
        minecraft$wooden_shovel(0.125),
        minecraft$wooden_sword(0.125);

        final SourceBase.Properties<?> props;

        private BuiltInFuels(double carbon) {
            this("", carbon);
        }

        private BuiltInFuels(double carbon, double sulfur) {
            this("", carbon, sulfur);
        }

        private BuiltInFuels(String id, double carbon) {
            this(id, carbon, carbon / 10.0);
        }

        private BuiltInFuels(String id, double carbon, double sulfur) {
            this(id, Emissions.of().carbon((float)carbon).sulfur((float)sulfur));
        }

        private BuiltInFuels(String id, Emissions emissions) {
            this.props = ((SourceBase.Properties)((SourceBase.Properties)SourceBase.Properties.with().id(id)).emptyToEnumId(this, true)).emissions(emissions);
        }

        private static double perBucket(double emission) {
            return emission / 1000.0;
        }
    }
}

