/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.ForgeBucketItem;
import com.endertech.minecraft.forge.units.RegistryEntriesInit;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.items.GasBlockItem;
import com.endertech.minecraft.mods.adpother.items.Respirator;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.items.VacuumTube;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;

public class Items
extends RegistryEntriesInit<Item> {
    public final Aerometer aerometer = (Aerometer)((Object)this.addNew((Object)new Aerometer(this.getMod(), this.createConfigFor(Aerometer.class))));
    public final ForgeBucketItem pollutedWaterBucket;

    public Items(ForgeMod mod) {
        super(mod, Item.class);
        for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
            if (!(pollutant instanceof AbstractGas)) continue;
            this.addNew((Object)new GasBlockItem((AbstractGas)pollutant, new Item.Properties().func_234689_a_().setNoRepair().func_200916_a(ItemGroup.field_78035_l)));
        }
        UnitConfig bagConfig = this.createConfigFor(VacuumBag.class);
        UnitConfig tubeConfig = this.createConfigFor(VacuumTube.class);
        UnitConfig respiratorConfig = this.createConfigFor(Respirator.class);
        for (Materials material : Materials.values()) {
            material.vacuumBag = (VacuumBag)this.addNew(new VacuumBag(this.getMod(), bagConfig, material));
            material.vacuumTube = (VacuumTube)((Object)this.addNew((Object)new VacuumTube(this.getMod(), tubeConfig, material)));
            material.respirator = (Respirator)((Object)this.addNew((Object)new Respirator(this.getMod(), respiratorConfig, material)));
            material.filterFrameItem = (FilterFrame.BlockItem)this.addNew(new FilterFrame.BlockItem((ForgeBlock)material.filterFrame, new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
        }
        this.pollutedWaterBucket = (ForgeBucketItem)this.addNew(new ForgeBucketItem("polluted_water_bucket", () -> AdPother.getInstance().fluids.pollutedWaterStill));
    }
}

