/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEffect;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;

public class Respirators
extends RelatedUnitsInit<Respirator, BuiltIn> {
    public Respirators(ForgeMod mod) {
        super(mod, BuiltIn.class);
    }

    public Respirator createCustomUnitFrom(UnitConfig config, String name) {
        return new Respirator(config, UnitId.EMPTY, 0, "");
    }

    public Respirator createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
        return e.createRespirator(config, UnitId.from((Enum)e, (String)"*"));
    }

    public RespiratorEffect getEffect() {
        return AdPother.getInstance().effects.respirator;
    }

    public CommonTime.Interval getEffectDurationFor(Respirator respirator, ItemStack stack, int damage) {
        if (damage > 0) {
            IStorage.Content content = respirator.getContent(stack);
            double seconds = content.hasFunctionalFilters() ? (double)(content.getCapacity() - content.getHighestFullness()) : 0.0;
            seconds /= (double)damage;
            seconds = Math.max(2.0, seconds);
            return CommonTime.Interval.seconds((double)seconds);
        }
        return CommonTime.Interval.hours((double)1.0);
    }

    public ItemStack findOn(LivingEntity living, boolean onlyFunctional) {
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            Respirator respirator = (Respirator)this.findBy(stack);
            if (respirator == null || onlyFunctional && !respirator.isFunctional(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void updateEffectFor(LivingEntity living, int damage) {
        Respirator respirator;
        living.func_195063_d((Effect)this.getEffect());
        ItemStack stack = this.findOn(living, true);
        Respirator respirator2 = respirator = stack.func_190926_b() ? null : (Respirator)this.findBy(stack);
        if (respirator != null) {
            CommonTime.Interval duration = this.getEffectDurationFor(respirator, stack, damage);
            living.func_195064_c(this.getEffect().createInstance(duration, false));
        }
    }

    public static class Respirator
    extends RelatedUnit
    implements IStorageItem {
        public final int durability;
        private final String functionalStateTag;

        public Respirator(UnitConfig config, UnitId id, int durability, String functionalStateTag) {
            super(config, id);
            this.durability = UnitConfig.getInt((UnitConfig)config, (String)this.getClassCategory(), (String)"durability", (int)durability, (IntBounds)GameBounds.DURABILITY.getIntBounds(), (String)"Defines how long (in seconds) this respirator can withstand low-level pollution.");
            this.functionalStateTag = UnitConfig.getStr((UnitConfig)config, (String)this.getClassCategory(), (String)"functionalStateTag", (String)functionalStateTag, (String)"Defines the name of the NBT tag that stores info about the active state.\nRespirator is considered functional only if the returning value is > 0 or true.\nSet empty string for no checks");
            this.saveConfig();
        }

        public boolean isFunctional(ItemStack stack) {
            int value;
            CompoundNBT compound;
            if (ForgeItem.isBroken((ItemStack)stack)) {
                return false;
            }
            if (!this.functionalStateTag.isEmpty() && (compound = stack.func_77978_p()) != null && (value = compound.func_74762_e(this.functionalStateTag)) <= 0) {
                return false;
            }
            return this.getContent(stack).hasFunctionalFilters();
        }

        public String getTagName() {
            return this.functionalStateTag;
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return this.durability;
        }
    }

    public static class RespiratorEffect
    extends ForgeEffect {
        protected RespiratorEffect(ForgeMod mod) {
            super(mod, "respirator", EffectType.BENEFICIAL, Pollutants.BuiltIn.CARBON.get().getColor());
        }

        public void func_76394_a(LivingEntity living, int amplifier) {
        }
    }

    static enum BuiltIn implements IForgeEnum
    {
        adpother$iron_respirator(600),
        adpother$gold_respirator(720),
        adpother$diamond_respirator(1440),
        mekanism$scuba_mask(600),
        mekanism$hazmat_mask(600),
        mekanism$mekasuit_helmet(1440);

        public final int durability;
        public final String functionalStateTag;

        private BuiltIn(String functionalStateTag, int durability) {
            this.durability = durability;
            this.functionalStateTag = functionalStateTag;
        }

        private BuiltIn(int durability) {
            this("", durability);
        }

        Respirator createRespirator(UnitConfig config, UnitId id) {
            return new Respirator(config, id, this.durability, this.functionalStateTag);
        }
    }
}

