/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeCacheCleaner;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.renderers.AerometerRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Aerometer
extends GlassMeter {
    public static final float THICKNESS = 0.08f;
    private Cleaner cleaner;

    public Aerometer(ForgeMod mod, UnitConfig config) {
        super(mod, config, "aerometer", new Item.Properties().func_200916_a(ItemGroup.field_78040_i).setISTER(() -> AerometerRenderer::new), 4, EquipmentSlotType.OFFHAND, TextFormatting.GREEN);
    }

    public static Optional<Entity> getCarrierFor(ItemStack stack) {
        if (stack.func_77973_b() instanceof Aerometer) {
            Aerometer meter = (Aerometer)stack.func_77973_b();
            return Optional.ofNullable((Entity)meter.carriers.get(stack));
        }
        return Optional.empty();
    }

    public static List<ItemStack> findInInventoryOf(PlayerEntity player) {
        ArrayList<ItemStack> found = new ArrayList<ItemStack>();
        PlayerInventory inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof Aerometer)) continue;
            found.add(stack);
        }
        return found;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        this.updateCarrier(stack, entity);
    }

    public void updateCarrier(ItemStack stack, Entity entity) {
        if (ForgeEntity.isClientSide((Entity)entity)) {
            this.carriers.put(stack, entity);
            this.cleanUselessStacks();
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        this.updateCarrier(stack, (Entity)entity);
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        Optional<Entity> carrier;
        if (Aerometer.notBroken((ItemStack)stack) && (carrier = Aerometer.getCarrierFor(stack)).isPresent()) {
            Tooltip tip = Tooltip.of((ForgeMod)AdPother.getInstance(), (String)"aerometer", lines);
            EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
            pollution.getInfos().map(info -> info.getPollutant()).forEach(pollutant -> tip.addRaw(pollutant.getTextColor() + pollutant.func_235333_g_().getString() + ": " + pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toColoredText()));
        }
        super.func_77624_a(stack, world, lines, flag);
    }

    private void cleanUselessStacks() {
        if (this.cleaner == null || this.cleaner.isTimeToRun()) {
            this.cleaner = new Cleaner(CommonTime.Interval.seconds((double)10.0));
        }
    }

    public class Cleaner
    extends ForgeCacheCleaner {
        public Cleaner(CommonTime.Interval runInterval) {
            super(runInterval);
        }

        public void run() {
            Iterator iterator = Aerometer.this.carriers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                Entity entity = (Entity)entry.getValue();
                if (!stack.func_190926_b() && ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
                iterator.remove();
            }
        }
    }
}

