/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.ChestWearItem;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.items.IBaubleWear;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VacuumBag
extends ChestWearItem
implements IStorageItem,
IBaubleWear {
    private final int capacity;

    public VacuumBag(ForgeMod mod, UnitConfig config, Materials material) {
        super(mod, config, material.getName() + "_vacuum_bag", new Item.Properties().func_200916_a(ItemGroup.field_78040_i), 64, UnitId.from((String)"#forge:leather"), SoundEvents.field_187728_s);
        this.capacity = UnitConfig.getInt((UnitConfig)config, (String)this.getUnitCategory(), (String)"capacity", (int)material.capacity, (IntBounds)IntBounds.INTEGER_POSITIVE, (String)"Defines the maximum capacity of the bag.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        IStorageItem.super.addInformation(stack, world, lines, flag);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        GasEntity carrier;
        Optional state;
        World world = entity.func_130014_f_();
        if (this.isServerSide((IWorldReader)world) && entity instanceof GasEntity && (state = (carrier = (GasEntity)entity).getCarriedBlockState()).isPresent() && carrier.spend()) {
            Block.func_220075_c((BlockState)((BlockState)state.get()), (World)world, (BlockPos)carrier.func_233580_cy_());
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return state.func_177230_c() instanceof Pollutant;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        this.installFiltersFor(stack, new Pollutant[]{Pollutants.BuiltIn.SULFUR.get()});
    }

    @Override
    public int fill(ItemStack storage, Pollutant<?> pollutant, int amount) {
        if (VacuumBag.isBroken((ItemStack)storage)) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        float gradeFactor = content.getFullnessPercentageFor(pollutant).getGrade().ordinal() + 1;
        float wearoutChance = 0.05f * gradeFactor;
        if (CommonMath.Random.result((float)wearoutChance)) {
            ForgeItem.damageItem((int)1, (ItemStack)storage, (boolean)false, null, null);
        }
        Percentage wearout = this.getWearoutPercentage(storage);
        boolean leak = false;
        if (wearout.getGrade() == Percentage.Grade.HIGH) {
            float chance = Percentage.HUNDRED.getValue() - wearout.getGrade().threshold;
            float probability = 1.0f / Math.max(1.0f, chance);
            leak = CommonMath.Random.result((float)probability);
        }
        if (leak) {
            return 0;
        }
        return IStorageItem.super.fill(storage, pollutant, amount);
    }

    @Override
    public int getInitialCapacity(ItemStack storage) {
        return this.capacity;
    }
}

