/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import java.util.Iterator;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VacuumTube
extends DamageableItem {
    public static final FloatBounds SUCK_INTERVAL_BOUNDS_IN_SEC = FloatBounds.from((Float)Float.valueOf(0.25f), (Float)Float.valueOf(1.0f));
    protected final GameTime suckInterval;
    protected final float speed;
    protected final boolean canSuckIntoInventory;

    public VacuumTube(ForgeMod mod, UnitConfig config, Materials material) {
        super(mod, config, material.getName() + "_vacuum_tube", new Item.Properties().func_200916_a(ItemGroup.field_78040_i), material.durability, UnitId.from((String)material.tag));
        this.speed = UnitConfig.getFloat((UnitConfig)this.getConfig(), (String)this.getUnitCategory(), (String)"speed", (float)material.speed, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Defines operating speed for the vacuum cleaner.");
        this.suckInterval = GameTime.seconds((float)SUCK_INTERVAL_BOUNDS_IN_SEC.approxDown(this.speed).floatValue());
        this.canSuckIntoInventory = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getUnitCategory(), (String)"canSuckIntoInventory", (boolean)false, (String)"Defines the ability to suck pollution into a player's inventory");
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)player.func_184586_b(hand));
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        World world = living.func_130014_f_();
        if (this.isClientSide((IWorldReader)world) && living instanceof ClientPlayerEntity && this.suckInterval.pastIn(world)) {
            BlockPos pos;
            BlockState state;
            Minecraft mc = Minecraft.func_71410_x();
            float reachDistance = mc.field_71442_b.func_78757_d();
            BlockRayTraceResult rayTraceResult = ForgeEntity.rayTraceBlockBeingLookedAt((Entity)living, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.VISUAL, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY, (float)1.0f, (float)reachDistance);
            if (rayTraceResult instanceof BlockRayTraceResult && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(pos = rayTraceResult.func_216350_a())).func_177230_c() instanceof AbstractGas) {
                new ExhaustMsg(pos, (PlayerEntity)((ClientPlayerEntity)living)).sendToServer();
            }
        }
        super.onUsingTick(stack, living, count);
    }

    public static boolean exhaust(World world, BlockPos pos, PlayerEntity player) {
        BlockState state = world.func_180495_p(pos);
        ItemStack activeStack = player.func_184607_cu();
        if (state.func_177230_c() instanceof Pollutant && activeStack.func_77973_b() instanceof VacuumTube) {
            VacuumBag bag;
            ItemStack stack;
            Pollutant pollutant = (Pollutant)state.func_177230_c();
            VacuumTube tube = (VacuumTube)activeStack.func_77973_b();
            boolean pumped = false;
            Iterator iterator = ForgeEntity.getEquipmentOn((Entity)player).iterator();
            while (!(!iterator.hasNext() || (stack = (ItemStack)iterator.next()).func_77973_b() instanceof VacuumBag && (pumped = (bag = (VacuumBag)stack.func_77973_b()).fill(stack, pollutant, 1) > 0))) {
            }
            if (!pumped && (tube.canSuckIntoInventory || player.func_184812_l_())) {
                ItemStack suckedStack = new ItemStack((IItemProvider)pollutant);
                pumped = player.field_71071_by.func_70441_a(suckedStack);
            }
            if (!pumped) {
                BlockPos toPos = player.func_233580_cy_();
                boolean bl = pumped = pollutant.pump((IWorld)world, toPos) || pollutant.pump((IWorld)world, toPos.func_177984_a());
            }
            if (pumped && pollutant.spend((IWorld)world, pos)) {
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187524_aN, SoundCategory.BLOCKS, 0.1f, tube.speed);
                return true;
            }
        }
        return false;
    }

    public GameTime getSuckInterval() {
        return this.suckInterval;
    }

    public static class ExhaustMsg
    extends ForgeNetMsg<ExhaustMsg> {
        public BlockPos pos;
        public int playerId;

        public ExhaustMsg() {
        }

        public ExhaustMsg(BlockPos pos, PlayerEntity player) {
            this.pos = pos;
            this.playerId = player.func_145782_y();
        }

        public ExhaustMsg create() {
            return new ExhaustMsg();
        }

        public void handle(World world, PlayerEntity player) {
            Entity entity = world.func_73045_a(this.playerId);
            if (entity instanceof PlayerEntity) {
                VacuumTube.exhaust(world, this.pos, (PlayerEntity)entity);
            }
        }

        public void sendToServer() {
            AdPother.getInstance().getConnection().sendToServer((Object)this);
        }
    }
}

