/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public abstract class AbstractPollution {
    protected Map<Pollutant<?>, PollutionInfo> infoForPollutant = new ConcurrentHashMap();

    public Stream<PollutionInfo> getInfos() {
        return this.infoForPollutant.values().stream();
    }

    public boolean isEmpty() {
        return !this.getInfos().anyMatch(info -> !info.isEmpty());
    }

    @Nonnull
    public PollutionInfo getOrCreateInfoFor(Pollutant<?> pollutant) {
        PollutionInfo info = this.infoForPollutant.get(pollutant);
        if (info == null) {
            info = new PollutionInfo(pollutant);
            this.infoForPollutant.put(pollutant, info);
        }
        return info;
    }

    public Optional<PollutionInfo> getInfoFor(Pollutant<?> pollutant) {
        return Optional.ofNullable(this.infoForPollutant.get(pollutant));
    }

    public void readFrom(CompoundNBT compound) {
        if (compound.func_150297_b("pollutants", 9)) {
            this.infoForPollutant.clear();
            ListNBT list = compound.func_150295_c("pollutants", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                PollutionInfo info = new PollutionInfo(null).readFrom(tag);
                if (info.isEmpty()) continue;
                this.infoForPollutant.put(info.getPollutant(), info);
            }
        }
    }

    public void writeTo(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        this.getInfos().filter(info -> !info.isEmpty()).forEach(info -> {
            CompoundNBT tag = info.writeTo(new CompoundNBT());
            list.add((Object)tag);
        });
        compound.func_218657_a("pollutants", (INBT)list);
    }
}

