/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CarrierSpawnLimiter {
    public static int maxTotalAmount = 50;
    private Set<Entity> entities = new HashSet<Entity>();
    private long lastSpawn = 0L;

    public boolean canSpawnAt(World world, BlockPos pos) {
        long time = world.func_82737_E();
        return time != this.lastSpawn && this.getQuantity() < maxTotalAmount;
    }

    public boolean validEntity(Entity entity) {
        return entity instanceof GasEntity;
    }

    public void onEntityAdded(Entity entity) {
        if (this.validEntity(entity)) {
            this.entities.add(entity);
            this.lastSpawn = entity.field_70170_p.func_82737_E();
        }
    }

    public void onEntityRemoved(Entity entity) {
        if (this.validEntity(entity)) {
            this.entities.remove(entity);
        }
    }

    public int getQuantity() {
        return this.entities.size();
    }
}

