/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ChunkPollution
extends AbstractPollution {
    private final ChunkLoc location;

    public ChunkPollution(ChunkLoc location) {
        this.location = location;
    }

    public void increaseBy(Emitter emitter, Fuel fuel, TileEntity tile) {
        World world = tile.func_145831_w();
        if (!(world instanceof ServerWorld)) {
            return;
        }
        BiomeId biome = BiomeId.from((IWorld)world, (BlockPos)tile.func_174877_v());
        for (Pollutant<?> pollutant : fuel.getPollutants()) {
            if (!pollutant.inAllowableDimension(world)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            float emitterRate = emitter.getEmissionOf(pollutant);
            double totalAmount = fuel.getEmissionOf(pollutant) * biomeRate * emitterRate * Emission.globalRate;
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount <= 0) continue;
            WorldData.scheduleEmissionFor(tile, emitter, pollutant, intAmount);
        }
    }

    public void increaseBy(SourceBase source, float factor, ServerWorld world, BlockPos pos) {
        BiomeId biome = BiomeId.from((IWorld)world, (BlockPos)pos);
        for (Pollutant<?> pollutant : source.getPollutants()) {
            TileEntity tile;
            Emitter emitter;
            if (!pollutant.inAllowableDimension((World)world)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            double totalAmount = factor * source.getEmissionOf(pollutant) * biomeRate * Emission.globalRate;
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount <= 0) continue;
            if (source instanceof Emitter && ((emitter = (Emitter)source).getType().isTile() || emitter.getType().isFuel()) && (tile = world.func_175625_s(pos)) != null) {
                WorldData.scheduleEmissionFor(tile, emitter, pollutant, intAmount);
                continue;
            }
            pollutant.generateAt((World)world, pos, intAmount, 1);
        }
    }

    protected int getIntAndUpdateFractAmount(Pollutant<?> pollutant, double amount) {
        if (CommonMath.notZero((double)amount)) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            double fractAmount = info.getFraction() + amount;
            int intAmount = MathHelper.func_76128_c((double)fractAmount);
            info.setFraction(fractAmount -= (double)intAmount);
            return intAmount;
        }
        return 0;
    }

    public void increaseBy(ServerWorld world, BlockPos pos, BlockState state, int blocksAmount) {
        Pollutant pollutant;
        if (state != null && state.func_177230_c() instanceof Pollutant && (pollutant = (Pollutant)state.func_177230_c()).affectsPollutionLevel((IWorld)world, pos, state)) {
            int amount = pollutant.getCarriedPollutionAmount(state) * blocksAmount;
            this.increaseBy(world, pollutant, amount);
        }
    }

    protected void increaseBy(ServerWorld world, Pollutant<?> pollutant, int amount) {
        if (amount != 0) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            info.increaseQuantity(amount);
        }
    }

    public ChunkLoc getLocation() {
        return this.location;
    }

    public void clean(World world) {
        ChunkBounds bounds = this.getLocation().getBounds();
        int x = bounds.getX().getMin();
        while (bounds.getX().encloses(Integer.valueOf(x))) {
            int z = bounds.getZ().getMin();
            while (bounds.getZ().encloses(Integer.valueOf(z))) {
                int y = bounds.getY().getMin();
                while (bounds.getY().encloses(Integer.valueOf(y))) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block instanceof Pollutant) {
                        world.func_217377_a(pos, false);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        ChunkPos chunkPos = this.getLocation().getPos();
        for (ClassInheritanceMultiMap entityList : world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b).func_177429_s()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof GasEntity)) continue;
                entity.func_70106_y();
            }
        }
        this.getLocation().getChunk(world).ifPresent(chunk -> chunk.func_76630_e());
        this.infoForPollutant.clear();
    }

    public void recalculate(World world) {
        this.getInfos().forEach(info -> info.setQuantity(0));
        ChunkBounds bounds = this.getLocation().getBounds();
        bounds.forEach(pos -> {
            Pollutant pollutant;
            BlockState state = world.func_180495_p((BlockPos)pos);
            if (state.func_177230_c() instanceof Pollutant && (pollutant = (Pollutant)state.func_177230_c()).affectsPollutionLevel((IWorld)world, (BlockPos)pos, state)) {
                int amount = pollutant.getCarriedPollutionAmount(state);
                this.getOrCreateInfoFor(pollutant).increaseQuantity(amount);
            }
        });
        this.getLocation().getChunk(world).ifPresent(chunk -> chunk.func_76630_e());
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{this.getInfos(), Args.get((String)"location", (Object)this.getLocation())});
    }
}

